/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.pos;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.pos.PositionAdjustments;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/pos/BaseDodgePos;", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "myGroupCount", "", "mySize", "", "myIsHorizontalPos", "", "(Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;ILjava/lang/Double;Z)V", "myDodgingNeeded", "Ljava/lang/Double;", "handlesGroups", "isDodgingNeeded", "translate", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "v", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "plot-base"})
public abstract class BaseDodgePos
implements PositionAdjustment {
    private final int myGroupCount;
    @Nullable
    private final Double mySize;
    private final boolean myIsHorizontalPos;
    private final boolean myDodgingNeeded;

    public BaseDodgePos(@NotNull Aesthetics aesthetics2, int myGroupCount, @Nullable Double mySize, boolean myIsHorizontalPos) {
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        this.myGroupCount = myGroupCount;
        this.mySize = mySize;
        this.myIsHorizontalPos = myIsHorizontalPos;
        this.myDodgingNeeded = this.isDodgingNeeded(aesthetics2);
    }

    private final boolean isDodgingNeeded(Aesthetics aesthetics2) {
        HashMap groupBy = new HashMap();
        Aes<Double> aes2 = this.myIsHorizontalPos ? Aes.Companion.getX() : Aes.Companion.getY();
        int n = aesthetics2.dataPointCount();
        for (int i = 0; i < n; ++i) {
            DataPointAesthetics p = aesthetics2.dataPointAt(i);
            if (!p.defined(aes2)) continue;
            Double d = p.get(aes2);
            Intrinsics.checkNotNull((Object)d);
            double value = ((Number)d).doubleValue();
            Integer group2 = p.group();
            if (groupBy.containsKey(value)) {
                if (Intrinsics.areEqual(groupBy.get(value), (Object)group2)) continue;
                return true;
            }
            Double d2 = value;
            ((Map)groupBy).put(d2, group2);
        }
        return false;
    }

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx2) {
        DoubleVector doubleVector;
        Double size2;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        if (!this.myDodgingNeeded) {
            return v;
        }
        Aes<Double> aes2 = this.myIsHorizontalPos ? Aes.Companion.getX() : Aes.Companion.getY();
        double dataResolution = ctx2.getResolution(aes2);
        Double d = this.mySize;
        if (d == null) {
            d = this.myIsHorizontalPos ? p.width() : p.height();
        }
        if (!SeriesUtil.INSTANCE.isFinite(size2 = d)) {
            return v;
        }
        Integer n = p.group();
        Intrinsics.checkNotNull((Object)n);
        int slotIndex = n;
        double median = (double)(this.myGroupCount - 1) / 2.0;
        double d2 = ((double)slotIndex - median) * dataResolution;
        Double d3 = size2;
        Intrinsics.checkNotNull((Object)d3);
        double offset2 = d2 * d3;
        Double d4 = p.get(aes2);
        Intrinsics.checkNotNull((Object)d4);
        double center = ((Number)d4).doubleValue();
        double scaler = 1.0 / (double)this.myGroupCount;
        if (this.myIsHorizontalPos) {
            double newX = (v.getX() + offset2 - center) * scaler + center;
            doubleVector = new DoubleVector(newX, v.getY());
        } else {
            double newY = (v.getY() + offset2 - center) * scaler + center;
            doubleVector = new DoubleVector(v.getX(), newY);
        }
        return doubleVector;
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.DODGE.handlesGroups();
    }

    @Override
    public boolean isIdentity() {
        return PositionAdjustment.DefaultImpls.isIdentity(this);
    }
}

