/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.dependency;

import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.settings.DiagramConfigElement;
import com.intellij.diagram.settings.DiagramConfigGroup;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.uml.java.utils.DiagramJavaBundle;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.jcip.annotations.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
final class DependenciesConfiguration {
    public final boolean myShowOneToOne;
    public final boolean myShowOneToMany;
    public final boolean myShowUsagesInCode;
    public final boolean myShowLinksInDocs;
    public final boolean myShowCyclic;
    public final boolean myShowNewExpressions;

    private DependenciesConfiguration(boolean showOneToOne, boolean showOneToMany, boolean showUsagesInCode, boolean showLinksInDocs, boolean showCyclic, boolean showNewExpressions) {
        this.myShowOneToOne = showOneToOne;
        this.myShowOneToMany = showOneToMany;
        this.myShowUsagesInCode = showUsagesInCode;
        this.myShowLinksInDocs = showLinksInDocs;
        this.myShowCyclic = showCyclic;
        this.myShowNewExpressions = showNewExpressions;
    }

    @NotNull
    public static DependenciesConfiguration fromUmlConfiguration(@NotNull DiagramConfiguration diagramConfiguration) {
        if (diagramConfiguration == null) {
            DependenciesConfiguration.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new DependenciesConfiguration(true, true, true, true, true, true);
        }
        DiagramProvider provider = Objects.requireNonNull(DiagramProvider.findByID((String)"JAVA"));
        DiagramConfigGroup dependenciesSettingsGroup = Objects.requireNonNull((DiagramConfigGroup)ContainerUtil.find((Object[])provider.getExtras().getAdditionalDiagramSettings(), it -> it.getName().equals(DiagramBundle.message((String)"dependencies", (Object[])new Object[0]))));
        Map<String, Boolean> optionToIsEnabled = dependenciesSettingsGroup.getElements().stream().filter(it -> it.getType() == DiagramConfigElement.Type.CHECKBOX).collect(Collectors.toMap(it -> it.getName(), it -> diagramConfiguration.isEnabledByDefault(provider, it.getName())));
        return new DependenciesConfiguration(optionToIsEnabled.getOrDefault(DiagramJavaBundle.message("config.element.show.one.to.one", new Object[0]), true), optionToIsEnabled.getOrDefault(DiagramJavaBundle.message("config.element.show.one.to.many", new Object[0]), true), optionToIsEnabled.getOrDefault(DiagramJavaBundle.message("config.element.show.usages", new Object[0]), false), optionToIsEnabled.getOrDefault(DiagramJavaBundle.message("config.element.show.links.in.docs", new Object[0]), false), optionToIsEnabled.getOrDefault(DiagramJavaBundle.message("config.element.show.cyclic", new Object[0]), false), optionToIsEnabled.getOrDefault(DiagramJavaBundle.message("config.element.others", new Object[0]), true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagramConfiguration", "com/intellij/uml/java/dependency/DependenciesConfiguration", "fromUmlConfiguration"));
    }
}

