/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.UnknownDatabaseInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public final class UnknownDatabaseInfoHelper {
    static UnknownDatabaseInfo obtainDatabaseInfo(JdbcIntermediateFacade facade) {
        try (JdbcIntermediateSession session = facade.openSession();){
            Connection connection = session.getConnection();
            try {
                UnknownDatabaseInfo unknownDatabaseInfo = UnknownDatabaseInfoHelper.obtainDatabaseInfo(connection);
                return unknownDatabaseInfo;
            }
            catch (SQLException e) {
                throw session.recognizeException(e);
            }
        }
    }

    static UnknownDatabaseInfo obtainDatabaseInfo(Connection connection) throws SQLException {
        DatabaseMetaData md = connection.getMetaData();
        String databaseProductName = md.getDatabaseProductName();
        return databaseProductName != null ? UnknownDatabaseInfoHelper.obtainDatabaseInfo(databaseProductName) : UnknownDatabaseInfoHelper.makeDefaultUnknownInfo();
    }

    private static UnknownDatabaseInfo obtainDatabaseInfo(@NotNull String rdbmsName) {
        if (rdbmsName == null) {
            UnknownDatabaseInfoHelper.$$$reportNull$$$0(0);
        }
        UnknownDatabaseInfo info = new UnknownDatabaseInfo();
        info.isOracle = rdbmsName.startsWith("Oracle");
        info.isDB2 = rdbmsName.startsWith("DB2");
        info.isHsql = rdbmsName.startsWith("HSQL");
        info.isDerby = rdbmsName.contains("Derby");
        info.fromSingleRowTable = info.isOracle ? " from dual" : (info.isDB2 || info.isDerby ? " from sysibm.sysdummy1" : (info.isHsql ? " from information_schema.schemata limit 1" : ""));
        return info;
    }

    private static UnknownDatabaseInfo makeDefaultUnknownInfo() {
        return new UnknownDatabaseInfo();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbmsName", "com/intellij/database/remote/jdba/jdbc/UnknownDatabaseInfoHelper", "obtainDatabaseInfo"));
    }
}

