/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote.vfs;

import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterVFileEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ,\u0010\u000f\u001a\u00020\f\"\u0004\b\u0000\u0010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013J4\u0010\u0014\u001a\u00020\f\"\u0004\b\u0000\u0010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013H\u0086@\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteVfsEventDispatcher;", "", "<init>", "()V", "remoteVfsPublisher", "Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterVFileEvent$Listener;", "getRemoteVfsPublisher", "()Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterVFileEvent$Listener;", "platformVfsPublisher", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "kotlin.jvm.PlatformType", "fireAuthorityCreated", "", "file", "Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;", "withVfsCreateFileEvent", "T", "requestor", "handler", "Lkotlin/Function0;", "withVfsDeleteFileEvent", "(Ljava/lang/Object;Lcom/intellij/jupyter/core/jupyter/remote/vfs/JupyterRemoteVirtualFile;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.jupyter.core"})
public final class JupyterRemoteVfsEventDispatcher {
    private final BulkFileListener platformVfsPublisher;

    public JupyterRemoteVfsEventDispatcher() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        this.platformVfsPublisher = (BulkFileListener)messageBus.syncPublisher(topic);
    }

    private final JupyterVFileEvent.Listener getRemoteVfsPublisher() {
        return (JupyterVFileEvent.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JupyterVFileEvent.Companion.getTOPIC());
    }

    public final void fireAuthorityCreated(@NotNull JupyterRemoteVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        this.getRemoteVfsPublisher().invoke(new JupyterVFileEvent.AuthorityCreated(file));
    }

    public final <T> void withVfsCreateFileEvent(@Nullable Object requestor, @NotNull JupyterRemoteVirtualFile file, @NotNull Function0<? extends T> handler2) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        ThreadingAssertions.assertWriteAccess();
        JupyterRemoteVirtualFile jupyterRemoteVirtualFile = file.getParent();
        if (jupyterRemoteVirtualFile == null) {
            return;
        }
        JupyterRemoteVirtualFile parent = jupyterRemoteVirtualFile;
        VFileCreateEvent createEvent = new VFileCreateEvent(requestor, (VirtualFile)parent, file.getName(), file.isDirectory(), null, null, null);
        this.platformVfsPublisher.before(CollectionsKt.listOf((Object)createEvent));
        handler2.invoke();
        this.platformVfsPublisher.after(CollectionsKt.listOf((Object)createEvent));
    }

    @Nullable
    public final <T> Object withVfsDeleteFileEvent(@Nullable Object requestor, @NotNull JupyterRemoteVirtualFile file, @NotNull Function0<? extends T> handler2, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.edtWriteAction(() -> JupyterRemoteVfsEventDispatcher.withVfsDeleteFileEvent$lambda$0(this, requestor, file, handler2), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final Unit withVfsDeleteFileEvent$lambda$0(JupyterRemoteVfsEventDispatcher this$0, Object $requestor, JupyterRemoteVirtualFile $file, Function0 $handler) {
        this$0.platformVfsPublisher.before(CollectionsKt.listOf((Object)new VFileDeleteEvent($requestor, (VirtualFile)$file)));
        $handler.invoke();
        this$0.platformVfsPublisher.after(CollectionsKt.listOf((Object)new VFileDeleteEvent($requestor, (VirtualFile)$file)));
        return Unit.INSTANCE;
    }
}

