/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.formatting;

import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.util.DiffRangeUtil;
import com.intellij.diff.util.LinesRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.formatting.PrettierFormattingContext;
import com.intellij.prettierjs.formatting.PrettierFormattingDiff;
import com.intellij.util.LineSeparator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0000\u00a8\u0006\u000e"}, d2={"applyTextDifferencesToDocument", "", "formattingContext", "Lcom/intellij/prettierjs/formatting/PrettierFormattingContext;", "formattingDiff", "Lcom/intellij/prettierjs/formatting/PrettierFormattingDiff;", "updateLineSeparatorIfNeeded", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "newSeparator", "Lcom/intellij/util/LineSeparator;", "intellij.prettierJS"})
public final class PrettierApplyStrategyKt {
    public static final void applyTextDifferencesToDocument(@NotNull PrettierFormattingContext formattingContext, @NotNull PrettierFormattingDiff formattingDiff) {
        Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
        Intrinsics.checkNotNullParameter((Object)formattingDiff, (String)"formattingDiff");
        Document document = formattingContext.getDocument();
        FairDiffIterable textDifferences = formattingDiff.getTextDifferences();
        LineOffsets originalLineOffsets = formattingDiff.getOriginalLineOffsets();
        LineOffsets formattedLineOffsets = formattingDiff.getFormattedLineOffsets();
        String formattedText = formattingContext.getFormattedContent();
        for (Range change : CollectionsKt.reversed((Iterable)textDifferences.iterateChanges())) {
            if (change.isEmpty()) continue;
            int originalStartLine = change.start1;
            int originalEndLine = change.end1;
            int formattedStartLine = change.start2;
            int formattedEndLine = change.end2;
            if (originalStartLine == originalEndLine) {
                CharSequence insertionText = DiffRangeUtil.getLinesContent((CharSequence)formattedText, (LineOffsets)formattedLineOffsets, (int)formattedStartLine, (int)formattedEndLine, (boolean)false);
                int offset = originalStartLine == document.getLineCount() ? document.getTextLength() : document.getLineStartOffset(originalStartLine);
                document.insertString(offset, (CharSequence)(insertionText + "\n"));
                continue;
            }
            if (formattedStartLine == formattedEndLine) {
                LinesRange range = DiffRangeUtil.getLinesRange((LineOffsets)originalLineOffsets, (int)originalStartLine, (int)originalEndLine, (boolean)false);
                int startOffset = range.getStartOffset();
                int endOffset = range.getEndOffset();
                if (startOffset > 0) {
                    --startOffset;
                } else if (endOffset < document.getTextLength()) {
                    ++endOffset;
                }
                document.deleteString(startOffset, endOffset);
                continue;
            }
            CharSequence replacementText = DiffRangeUtil.getLinesContent((CharSequence)formattedText, (LineOffsets)formattedLineOffsets, (int)formattedStartLine, (int)formattedEndLine, (boolean)false);
            LinesRange range = DiffRangeUtil.getLinesRange((LineOffsets)originalLineOffsets, (int)originalStartLine, (int)originalEndLine, (boolean)false);
            document.replaceString(range.getStartOffset(), range.getEndOffset(), replacementText);
        }
    }

    public static final boolean updateLineSeparatorIfNeeded(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable LineSeparator newSeparator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (newSeparator != null && !Intrinsics.areEqual((Object)virtualFile.getDetectedLineSeparator(), (Object)newSeparator.getSeparatorString())) {
            AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project, (VirtualFile)virtualFile, (String)newSeparator.getSeparatorString());
            return true;
        }
        return false;
    }
}

