/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0007\u001a\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "dockerSocketUrl", "", "fixDefaultDockerConfigurationIfNeeded", "", "Lcom/intellij/docker/DockerCloudConfiguration;", "initializeDockerConfigurationForTest", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "serverName", "intellij.clouds.docker"})
public final class TestUtilsKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String dockerSocketUrl;

    @TestOnly
    public static final void fixDefaultDockerConfigurationIfNeeded(@NotNull DockerCloudConfiguration $this$fixDefaultDockerConfigurationIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$fixDefaultDockerConfigurationIfNeeded), (String)"<this>");
        if (SystemInfo.isUnix && StringsKt.contains$default((CharSequence)$this$fixDefaultDockerConfigurationIfNeeded.getApiUrl(), (CharSequence)"fd://", (boolean)false, (int)2, null)) {
            LOG.warn("Replacing unsupported Docker Engine API URL from " + $this$fixDefaultDockerConfigurationIfNeeded.getApiUrl() + " to " + dockerSocketUrl + " and resetting certificates path " + $this$fixDefaultDockerConfigurationIfNeeded.getCertificatesPath() + " to an empty string");
            $this$fixDefaultDockerConfigurationIfNeeded.setApiUrl(dockerSocketUrl);
            $this$fixDefaultDockerConfigurationIfNeeded.setCertificatesPath("");
        }
    }

    @TestOnly
    @NotNull
    public static final RemoteServer<DockerCloudConfiguration> initializeDockerConfigurationForTest(@Nullable String serverName) {
        String name;
        RemoteServer server;
        RemoteServersManager remoteServersManager = RemoteServersManager.getInstance();
        DockerCloudType dockerCloudType = DockerCloudType.getInstance();
        String string = serverName;
        if (string == null) {
            String string2 = dockerCloudType.getPresentableName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableName(...)");
        }
        if ((server = remoteServersManager.findByName(name = string, (ServerType)dockerCloudType)) == null) {
            server = remoteServersManager.createServer((ServerType)dockerCloudType, name);
            remoteServersManager.addServer(server);
        }
        ServerConfiguration serverConfiguration = server.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)serverConfiguration, (String)"getConfiguration(...)");
        TestUtilsKt.fixDefaultDockerConfigurationIfNeeded((DockerCloudConfiguration)serverConfiguration);
        return server;
    }

    public static /* synthetic */ RemoteServer initializeDockerConfigurationForTest$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return TestUtilsKt.initializeDockerConfigurationForTest(string);
    }

    static {
        String string;
        Logger logger = Logger.getInstance((String)"#com.intellij.docker.DockerTestUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        if (SystemInfoRt.isWindows) {
            string = "npipe:////./pipe/docker_engine";
        } else {
            string = System.getenv("DOCKER_HOST");
            if (string == null) {
                string = "unix:///var/run/docker.sock";
            }
        }
        dockerSocketUrl = string;
    }
}

