/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.ui;

import com.intellij.json.JsonLanguage;
import com.intellij.json.json5.Json5Language;
import com.intellij.json.psi.JsonFile;
import com.intellij.jsonpath.ui.JsonPathEvaluateView;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jsonpath/ui/JsonPathEvaluateFileView;", "Lcom/intellij/jsonpath/ui/JsonPathEvaluateView;", "project", "Lcom/intellij/openapi/project/Project;", "jsonFile", "Lcom/intellij/json/psi/JsonFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/json/psi/JsonFile;)V", "expressionHighlightingQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "fileAnchor", "Lcom/intellij/psi/PsiAnchor;", "jsonChangeTrackers", "", "Lcom/intellij/openapi/util/ModificationTracker;", "previousModificationCount", "", "detectChangesInJson", "", "getJsonFile", "intellij.jsonpath"})
@SourceDebugExtension(value={"SMAP\nJsonPathEvaluateFileView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonPathEvaluateFileView.kt\ncom/intellij/jsonpath/ui/JsonPathEvaluateFileView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1563#2:56\n1634#2,3:57\n1#3:60\n*S KotlinDebug\n*F\n+ 1 JsonPathEvaluateFileView.kt\ncom/intellij/jsonpath/ui/JsonPathEvaluateFileView\n*L\n18#1:56\n18#1:57,3\n*E\n"})
public final class JsonPathEvaluateFileView
extends JsonPathEvaluateView {
    @NotNull
    private final MergingUpdateQueue expressionHighlightingQueue;
    @NotNull
    private final PsiAnchor fileAnchor;
    @NotNull
    private final List<ModificationTracker> jsonChangeTrackers;
    private volatile long previousModificationCount;

    /*
     * WARNING - void declaration
     */
    public JsonPathEvaluateFileView(@NotNull Project project, @NotNull JsonFile jsonFile) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
        super(project);
        this.expressionHighlightingQueue = new MergingUpdateQueue("JSONPATH_EVALUATE", 1000, true, null, (Disposable)this, null, false, 96, null);
        PsiAnchor psiAnchor = PsiAnchor.create((PsiElement)((PsiElement)jsonFile));
        Intrinsics.checkNotNullExpressionValue((Object)psiAnchor, (String)"create(...)");
        this.fileAnchor = psiAnchor;
        Object object = new JsonLanguage[]{JsonLanguage.INSTANCE, Json5Language.INSTANCE};
        object = CollectionsKt.listOf((Object[])object);
        JsonPathEvaluateFileView jsonPathEvaluateFileView = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonLanguage jsonLanguage = (JsonLanguage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PsiModificationTracker.getInstance((Project)project).forLanguage((Language)it));
        }
        jsonPathEvaluateFileView.jsonChangeTrackers = (List)destination$iv$iv;
        BorderLayoutPanel content = new BorderLayoutPanel();
        content.addToTop((Component)this.getSearchWrapper());
        content.addToCenter((Component)this.getResultWrapper());
        this.setContent((JComponent)content);
        this.initToolbar();
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Topic topic = PsiModificationTracker.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, () -> JsonPathEvaluateFileView._init_$lambda$2(this));
    }

    /*
     * WARNING - void declaration
     */
    private final void detectChangesInJson() {
        long count = this.previousModificationCount;
        Iterable iterable = this.jsonChangeTrackers;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            ModificationTracker modificationTracker = (ModificationTracker)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.getModificationCount();
            l = l2 + l3;
        }
        long newCount = l;
        if (newCount != count) {
            this.previousModificationCount = newCount;
            this.resetExpressionHighlighting();
        }
    }

    @Override
    @Nullable
    public JsonFile getJsonFile() {
        PsiElement psiElement = this.fileAnchor.retrieve();
        return psiElement instanceof JsonFile ? (JsonFile)psiElement : null;
    }

    private static final void lambda$2$lambda$1(JsonPathEvaluateFileView this$0) {
        this$0.detectChangesInJson();
    }

    private static final void _init_$lambda$2(JsonPathEvaluateFileView this$0) {
        this$0.expressionHighlightingQueue.queue(Update.Companion.create((Object)this$0, () -> JsonPathEvaluateFileView.lambda$2$lambda$1(this$0)));
    }
}

