/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.ColumnSynonym;
import com.intellij.database.util.ColumnWithDasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.GridTablesModel;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00152\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J.\u0010$\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015H\u0002J$\u0010(\u001a\u00020%2\b\u0010)\u001a\u0004\u0018\u00010\u00112\b\u0010*\u001a\u0004\u0018\u00010\u00112\u0006\u0010+\u001a\u00020%H\u0002J \u0010,\u001a\u00020%2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010-\u001a\u00020\u00052\b\b\u0001\u0010.\u001a\u00020\u0011H\u0002J\u0010\u0010/\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u00100\u001a\u00020\u00052\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0015\u00a8\u00062"}, d2={"Lcom/intellij/database/datagrid/GridTablesModelBuilder;", "", "<init>", "()V", "build", "Lcom/intellij/database/util/GridTablesModel;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "queryText", "", "resultType", "Lcom/intellij/sql/psi/SqlTableType;", "columns", "", "Lcom/intellij/database/datagrid/GridColumn;", "buildForSingleTable", "table", "Lcom/intellij/database/model/DasTable;", "getDasTablesForColumns", "Lcom/intellij/database/util/ColumnWithDasTable;", "type", "resolveDasTable", "sqlExpression", "Lcom/intellij/sql/psi/SqlExpression;", "getColumnSynonym", "Lcom/intellij/database/util/ColumnSynonym;", "columnElement", "Lcom/intellij/sql/psi/SqlAsExpression;", "checkMetadata", "", "jdbcColumns", "columnsFromModel", "matches", "jdbcName", "modelName", "metadataMayReturnDifferentCase", "expressionHasSqlUnion", "notEditableGridTableModel", "reason", "gridTableModelForSingleTable", "gridTablesModelForTables", "columnsWithDasTable", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nGridTablesModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridTablesModelBuilder.kt\ncom/intellij/database/datagrid/GridTablesModelBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n1#2:237\n1#2:257\n774#3:238\n865#3,2:239\n1193#3,2:241\n1267#3,4:243\n1617#3,9:247\n1869#3:256\n1870#3:258\n1626#3:259\n1208#3,2:260\n1236#3,4:262\n774#3:266\n865#3,2:267\n1193#3,2:269\n1267#3,4:271\n*S KotlinDebug\n*F\n+ 1 GridTablesModelBuilder.kt\ncom/intellij/database/datagrid/GridTablesModelBuilder\n*L\n227#1:257\n224#1:238\n224#1:239,2\n225#1:241,2\n225#1:243,4\n227#1:247,9\n227#1:256\n227#1:258\n227#1:259\n228#1:260,2\n228#1:262,4\n230#1:266\n230#1:267,2\n231#1:269,2\n231#1:271,4\n*E\n"})
public final class GridTablesModelBuilder {
    @NotNull
    public final GridTablesModel build(@NotNull Dbms dbms, @NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable String queryText, @Nullable SqlTableType resultType, @NotNull List<? extends GridColumn> columns) {
        SqlTableType type;
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (!Registry.Companion.is("database.editor.smartMode", false)) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.smart.mode.off", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        if (queryText == null) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.query.is.empty", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        if (this.expressionHasSqlUnion(project, language, queryText)) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.query.has.union", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        SqlTableType sqlTableType = resultType;
        if (sqlTableType == null) {
            sqlTableType = DbSqlUtil.parseQueryTableType(project, language, dataSource, searchPath, queryText, null);
        }
        if ((type = sqlTableType) == null) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.no.metadata.for.query", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        List<ColumnWithDasTable> columnsWithDasTables = this.getDasTablesForColumns(type);
        HashSet<DasTable> tablesSet = new HashSet<DasTable>();
        if (columnsWithDasTables.isEmpty()) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.no.metadata.for.column", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        Map columnNameToDasTablesMap = new LinkedHashMap();
        for (ColumnWithDasTable columnWithDasTable : columnsWithDasTables) {
            Object object = columnWithDasTable.getColumnAlias();
            if ((object == null || (object = object.getRealName()) == null) && (object = columnWithDasTable.getColumnName()) == null) continue;
            Object columnName = object;
            DasTable dasTable = columnWithDasTable.getDasTable();
            if (dasTable == null) {
                String string = DatabaseBundle.message((String)"grid.tables.model.builder.has.column.without.table", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return this.notEditableGridTableModel(string);
            }
            if (columnNameToDasTablesMap.containsKey(columnName)) {
                Object v = columnNameToDasTablesMap.get(columnName);
                Intrinsics.checkNotNull(v);
                Set tablesWithSameName = (Set)v;
                if (tablesWithSameName.contains(dasTable)) {
                    Object[] objectArray = new Object[]{columnName, columnWithDasTable.getColumnName(), dasTable.getName()};
                    String string = DatabaseBundle.message((String)"grid.tables.model.builder.has.identical.columns", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return this.notEditableGridTableModel(string);
                }
                tablesWithSameName.add(dasTable);
            } else {
                Map map2 = columnNameToDasTablesMap;
                Object object2 = new DasTable[]{dasTable};
                object2 = SetsKt.mutableSetOf((Object[])object2);
                map2.put(columnName, object2);
            }
            tablesSet.add(dasTable);
        }
        if (!this.checkMetadata(dbms, columns, columnsWithDasTables)) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.metadata.mismatch", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        if (!DatabaseSettings.getSettings().isEnableEditSqlJoins() && tablesSet.size() > 1) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.switched.for.multiple.tables", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        return this.gridTablesModelForTables(columnsWithDasTables);
    }

    @NotNull
    public final GridTablesModel buildForSingleTable(@NotNull DasTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return this.gridTableModelForSingleTable(table);
    }

    private final List<ColumnWithDasTable> getDasTablesForColumns(SqlTableType type) {
        int columnCount = type.getColumnCount();
        List columnDasTables = new ArrayList();
        for (int i = 0; i < columnCount; ++i) {
            PsiElement dasTable;
            PsiElement columnElement = type.getSourceColumnElement(i);
            DasTable table = null;
            String columnName = "";
            ColumnSynonym columnSynonym = null;
            PsiElement psiElement = columnElement;
            Object object = dasTable = psiElement != null ? psiElement.getParent() : null;
            if (columnElement != null && dasTable instanceof DasTable && columnElement instanceof DasColumn) {
                columnName = ((DasNamed)columnElement).getName();
                table = (DasTable)dasTable;
            } else if (columnElement instanceof SqlAsExpression) {
                table = this.resolveDasTable((SqlExpression)columnElement);
                columnName = ((SqlAsExpression)columnElement).getName();
                columnSynonym = this.getColumnSynonym((SqlAsExpression)columnElement);
            }
            columnDasTables.add(new ColumnWithDasTable(table, i, columnName, columnSynonym));
        }
        return columnDasTables;
    }

    private final DasTable resolveDasTable(SqlExpression sqlExpression) {
        if (sqlExpression == null) {
            return null;
        }
        if (sqlExpression instanceof SqlAsExpression) {
            SqlExpression expression;
            SqlExpression sqlExpression2 = expression = ((SqlAsExpression)sqlExpression).getExpression();
            return sqlExpression2 != null ? this.resolveDasTable(sqlExpression2) : null;
        }
        if (sqlExpression instanceof SqlReferenceExpression) {
            PsiElement resolved = ((SqlReferenceExpression)sqlExpression).resolve();
            if (resolved == null) {
                return null;
            }
            if (resolved instanceof DasTable) {
                return (DasTable)resolved;
            }
            PsiElement parent = resolved.getParent();
            if (parent instanceof DasTable) {
                return (DasTable)parent;
            }
        }
        return null;
    }

    private final ColumnSynonym getColumnSynonym(SqlAsExpression columnElement) {
        SqlExpression childExpression = columnElement.getExpression();
        if (childExpression instanceof SqlReferenceExpression) {
            PsiElement sqlIdentifier;
            SqlExpression sqlExpression = columnElement.getExpression();
            Object object = sqlIdentifier = sqlExpression != null ? sqlExpression.getLastChild() : null;
            if (columnElement.getExpression() != null && sqlIdentifier instanceof SqlIdentifier) {
                String string = columnElement.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String alias = string;
                String string2 = ((SqlIdentifier)sqlIdentifier).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String realName = string2;
                boolean isQuoted = ((SqlReferenceExpression)childExpression).isQuoted();
                return new ColumnSynonym(alias, realName, isQuoted);
            }
        }
        return null;
    }

    private final boolean checkMetadata(Dbms dbms, List<? extends GridColumn> jdbcColumns, List<ColumnWithDasTable> columnsFromModel) {
        boolean checkTableName;
        boolean bl = checkTableName = !dbms.is(Dbms.GREENPLUM) && !dbms.is(Dbms.SQLITE) && !dbms.is(Dbms.MEMSQL);
        if (jdbcColumns.size() != columnsFromModel.size()) {
            return false;
        }
        for (GridColumn gridColumn : jdbcColumns) {
            String catalog;
            String schema;
            String columnName;
            DasTable table;
            ColumnWithDasTable columnWithDasTable;
            Object v1;
            block8: {
                if (gridColumn == null) {
                    return false;
                }
                if (!(gridColumn instanceof JdbcGridColumn)) {
                    return false;
                }
                Iterable iterable = columnsFromModel;
                for (Object t : iterable) {
                    ColumnWithDasTable it = (ColumnWithDasTable)t;
                    boolean bl2 = false;
                    if (!(it.getColumnNumber() == ((JdbcGridColumn)gridColumn).getColumnNumber())) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            if ((ColumnWithDasTable)v1 == null) {
                return false;
            }
            if (columnWithDasTable.getDasTable() == null) {
                return false;
            }
            if (columnWithDasTable.getColumnName() == null) {
                return false;
            }
            boolean metadataMayReturnDifferentCase = dbms.in(Dbms.MYSQL_LIKE);
            Intrinsics.checkNotNullExpressionValue((Object)DasUtil.getSchema((DasObject)((DasObject)table)), (String)"getSchema(...)");
            Intrinsics.checkNotNullExpressionValue((Object)DasUtil.getCatalog((DasObject)((DasObject)table)), (String)"getCatalog(...)");
            if ((!checkTableName || Intrinsics.areEqual((Object)table.getKind(), (Object)ObjectKind.VIEW) || this.matches(((JdbcGridColumn)gridColumn).getName(), columnName, metadataMayReturnDifferentCase)) && this.matches(((JdbcGridColumn)gridColumn).getTable(), table.getName(), metadataMayReturnDifferentCase) && this.matches(((JdbcGridColumn)gridColumn).getSchema(), schema, metadataMayReturnDifferentCase) && (((CharSequence)catalog).length() == 0 || this.matches(((JdbcGridColumn)gridColumn).getCatalog(), catalog, metadataMayReturnDifferentCase))) continue;
            return false;
        }
        return true;
    }

    private final boolean matches(String jdbcName, String modelName, boolean metadataMayReturnDifferentCase) {
        return StringUtil.isEmpty((String)jdbcName) || StringUtilRt.equal((CharSequence)modelName, (CharSequence)jdbcName, (!metadataMayReturnDifferentCase ? 1 : 0) != 0);
    }

    private final boolean expressionHasSqlUnion(Project project, Language language, String queryText) {
        Boolean bl = ((EvaluationHelper)EvaluationHelper.EP.forLanguage(language)).expressionHasSqlUnion(project, language, queryText, null);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"expressionHasSqlUnion(...)");
        return bl;
    }

    private final GridTablesModel notEditableGridTableModel(@NlsContexts.HintText String reason) {
        return new GridTablesModel(MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap(), false, true, reason);
    }

    private final GridTablesModel gridTableModelForSingleTable(DasTable table) {
        return new GridTablesModel(MapsKt.emptyMap(), MapsKt.mapOf((Pair)TuplesKt.to((Object)table.getName(), (Object)table)), MapsKt.emptyMap(), true, false, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GridTablesModel gridTablesModelForTables(@NotNull List<ColumnWithDasTable> columnsWithDasTable) {
        void $this$filterTo$iv$iv;
        Map map2;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object element$iv$iv3;
        void $this$associateTo$iv$iv;
        ColumnWithDasTable it;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(columnsWithDasTable, (String)"columnsWithDasTable");
        Iterable $this$filter$iv = columnsWithDasTable;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
            it = (ColumnWithDasTable)element$iv$iv2;
            boolean bl = false;
            if (!(it.getDasTable() != null)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$associate$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
            Map bl = destination$iv$iv2;
            ColumnWithDasTable it2 = (ColumnWithDasTable)element$iv$iv3;
            boolean bl2 = false;
            Integer n = it2.getColumnNumber();
            DasTable dasTable = it2.getDasTable();
            Intrinsics.checkNotNull((Object)dasTable);
            it2 = TuplesKt.to((Object)n, (Object)dasTable);
            bl.put(it2.getFirst(), it2.getSecond());
        }
        $this$associate$iv = columnsWithDasTable;
        Map map3 = destination$iv$iv2;
        boolean $i$f$mapNotNull = false;
        void capacity$iv22 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv3 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv3.hasNext()) {
            DasTable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv4 = element$iv$iv$iv = element$iv$iv3.next();
            boolean bl = false;
            ColumnWithDasTable it3 = (ColumnWithDasTable)element$iv$iv4;
            boolean bl3 = false;
            if (it3.getDasTable() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv32 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv32);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv3 : $this$associateByTo$iv$iv) {
            void it4;
            DasTable element$iv$iv$iv = (DasTable)element$iv$iv3;
            map2 = destination$iv$iv;
            boolean bl = false;
            String string = it4.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            map2.put(string, element$iv$iv3);
        }
        $this$associateBy$iv = columnsWithDasTable;
        map2 = destination$iv$iv;
        $i$f$filter = false;
        Iterable capacity$iv32 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv5 : $this$filterTo$iv$iv) {
            it = (ColumnWithDasTable)element$iv$iv5;
            boolean bl = false;
            if (!(it.getColumnAlias() != null)) continue;
            destination$iv$iv.add(element$iv$iv5);
        }
        Object object = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)object;
        $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateTo = false;
        for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
            Map map4 = destination$iv$iv;
            ColumnWithDasTable it5 = (ColumnWithDasTable)element$iv$iv3;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it5.getColumnNumber(), (Object)it5.getColumnAlias());
            map4.put(pair.getFirst(), pair.getSecond());
        }
        object = destination$iv$iv;
        String string = null;
        boolean bl = false;
        boolean bl5 = false;
        Object object2 = object;
        Map map5 = map2;
        Map map6 = map3;
        return new GridTablesModel(map6, map5, (Map)object2, bl5, bl, string);
    }
}

