/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler.callgraph;

import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.DataProviderFactory;
import com.intellij.openapi.graph.view.BackgroundRenderer;
import com.intellij.openapi.graph.view.DefaultBackgroundRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.python.profiler.FunctionStat;
import com.intellij.python.profiler.callgraph.CallGraphBuilder;
import com.intellij.python.profiler.callgraph.CallGraphDiagramModel;
import com.intellij.python.profiler.callgraph.CallGraphPresentationModel;
import com.intellij.util.ui.UIUtil;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aL\u0010\u0000\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f\u00a8\u0006\r"}, d2={"createCallGraphBuilder", "Lcom/intellij/openapi/graph/builder/GraphBuilder;", "Lcom/intellij/diagram/DiagramNode;", "Lcom/intellij/python/profiler/FunctionStat;", "Lcom/intellij/diagram/DiagramEdge;", "project", "Lcom/intellij/openapi/project/Project;", "functionsStats", "", "localPathFunction", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "Lcom/intellij/python/profiler/LocalPathFunction;", "intellij.python.profiler"})
public final class CallGraphViewKt {
    @NotNull
    public static final GraphBuilder<DiagramNode<FunctionStat>, DiagramEdge<FunctionStat>> createCallGraphBuilder(@NotNull Project project, @NotNull List<? extends FunctionStat> functionsStats, @NotNull Function1<? super Path, ? extends Path> localPathFunction) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(functionsStats, (String)"functionsStats");
        Intrinsics.checkNotNullParameter(localPathFunction, (String)"localPathFunction");
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(graph);
        view.getJComponent().putClientProperty("Diagram-View-Component-Key", true);
        DefaultBackgroundRenderer renderer = GraphManager.getGraphManager().createDefaultBackgroundRenderer(view);
        renderer.setColor(UIUtil.getListBackground());
        view.setBackgroundRenderer((BackgroundRenderer)renderer);
        Intrinsics.checkNotNull((Object)graph);
        CallGraphPresentationModel presentationModel = new CallGraphPresentationModel(project, (Graph)graph, localPathFunction);
        CallGraphDiagramModel model = new CallGraphDiagramModel(project, functionsStats);
        CallGraphBuilder builder = (CallGraphBuilder)((Object)WriteAction.computeAndWait(() -> CallGraphViewKt.createCallGraphBuilder$lambda$0(project, graph, view, model, presentationModel)));
        graph.addDataProvider((Object)"PROJECT", DataProviderFactory.create((Object)project));
        graph.addDataProvider((Object)"GRAPH_BUILDER", DataProviderFactory.create((Object)((Object)builder)));
        Intrinsics.checkNotNull((Object)((Object)builder));
        return (GraphBuilder)builder;
    }

    private static final CallGraphBuilder createCallGraphBuilder$lambda$0(Project $project, Graph2D $graph, Graph2DView $view, CallGraphDiagramModel $model, CallGraphPresentationModel $presentationModel) {
        Intrinsics.checkNotNull((Object)$graph);
        Intrinsics.checkNotNull((Object)$view);
        return new CallGraphBuilder($project, $graph, $view, $model, $presentationModel);
    }
}

