/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dataFlow;

import com.intellij.psi.PsiElement;
import com.intellij.sql.dataFlow.SqlErrorSpecInfo;
import com.intellij.sql.dataFlow.SqlErrorSpecMatch;
import com.intellij.sql.dataFlow.SqlStateInfo;
import com.intellij.sql.psi.SqlErrorSpec;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlConditionDefinition;
import com.intellij.sql.psi.impl.SqlConditionErrorSpec;
import com.intellij.sql.psi.impl.SqlErrorCodeSpec;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.impl.SqlSpecialErrorSpec;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0001H\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/dataFlow/SqlErrorSpecHelper;", "", "<init>", "()V", "resolveSpec", "Lcom/intellij/sql/dataFlow/SqlErrorSpecInfo;", "errorSpec", "Lcom/intellij/sql/psi/SqlErrorSpec;", "context", "Lcom/intellij/psi/PsiElement;", "getNotFoundErrorSpec", "getDefaultErrorCode", "sqlState", "Lcom/intellij/sql/dataFlow/SqlStateInfo;", "getSqlStateByErrorCode", "errorCode", "match", "Lcom/intellij/sql/dataFlow/SqlErrorSpecMatch;", "pattern", "Companion", "intellij.database.sql.core.impl"})
public class SqlErrorSpecHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final SqlErrorSpecHelper DEFAULT_INSTANCE = new SqlErrorSpecHelper();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public SqlErrorSpecInfo resolveSpec(@Nullable SqlErrorSpec errorSpec, @Nullable PsiElement context) {
        SqlErrorSpec sqlErrorSpec = errorSpec;
        if (sqlErrorSpec instanceof SqlSpecialErrorSpec) {
            SqlSpecialErrorSpec.Kind kind = ((SqlSpecialErrorSpec)errorSpec).getErrorKind();
            if (kind == null) {
                return null;
            }
            SqlSpecialErrorSpec.Kind kind2 = kind;
            SqlStateInfo.Wildcard sqlState = new SqlStateInfo.Wildcard(kind2);
            Object object = this.getDefaultErrorCode(sqlState, context);
            v1 = new SqlErrorSpecInfo(sqlState, object);
            return v1;
        } else if (sqlErrorSpec instanceof SqlErrorCodeSpec) {
            SqlExpression sqlExpression = ((SqlErrorCodeSpec)errorSpec).getErrorCode();
            if (!(sqlExpression instanceof SqlLiteralExpression)) return null;
            SqlLiteralExpression sqlLiteralExpression = (SqlLiteralExpression)sqlExpression;
            if (sqlLiteralExpression == null) {
                return null;
            }
            SqlLiteralExpression literal = sqlLiteralExpression;
            if (literal instanceof SqlStringLiteralExpression) {
                String string = ((SqlStringLiteralExpression)literal).getValue();
                if (string == null) {
                    return null;
                }
                String value = string;
                SqlStateInfo.Specific specific = new SqlStateInfo.Specific(value);
                Object errorCode = this.getDefaultErrorCode(specific, context);
                v1 = new SqlErrorSpecInfo(specific, errorCode);
                return v1;
            } else {
                String string = literal.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                Integer n = StringsKt.toIntOrNull((String)string);
                if (n == null) return null;
                int errorCode = n;
                SqlStateInfo sqlStateInfo = this.getSqlStateByErrorCode(errorCode);
                if (sqlStateInfo == null) {
                    return null;
                }
                SqlStateInfo sqlStateInfo2 = sqlStateInfo;
                v1 = new SqlErrorSpecInfo(sqlStateInfo2, errorCode);
            }
            return v1;
        } else {
            if (!(sqlErrorSpec instanceof SqlConditionErrorSpec)) return null;
            PsiElement target2 = ((SqlConditionErrorSpec)errorSpec).resolve();
            if (target2 instanceof SqlConditionDefinition) {
                SqlErrorCodeSpec sqlErrorCodeSpec = ((SqlConditionDefinition)target2).getErrorSpec();
                if (sqlErrorCodeSpec == null) {
                    return null;
                }
                SqlErrorCodeSpec targetSpec = sqlErrorCodeSpec;
                v1 = this.resolveSpec(targetSpec, context);
                return v1;
            } else {
                PsiElement psiElement = target2;
                if (psiElement == null) {
                    String name2 = ((SqlConditionErrorSpec)errorSpec).getReference().getCanonicalText();
                    boolean bl = false;
                    if (!SqlPsiUtilKt.getSqlDialect((PsiElement)errorSpec).getExceptionNames().contains(name2)) return null;
                    String string = name2;
                    String string2 = string;
                    if (string2 == null) return null;
                    String string3 = string2;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    String string4 = string3.toUpperCase(locale);
                    String string5 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                    psiElement = string5;
                    if (string5 == null) {
                        return null;
                    }
                }
                PsiElement errorCode = psiElement;
                return new SqlErrorSpecInfo(SqlStateInfo.Unknown.INSTANCE, errorCode);
            }
        }
    }

    @Nullable
    public SqlErrorSpecInfo getNotFoundErrorSpec() {
        return null;
    }

    @Nullable
    public Object getDefaultErrorCode(@NotNull SqlStateInfo sqlState, @Nullable PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)sqlState, (String)"sqlState");
        return null;
    }

    @Nullable
    public SqlStateInfo getSqlStateByErrorCode(@NotNull Object errorCode) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        return null;
    }

    @NotNull
    public SqlErrorSpecMatch match(@NotNull SqlErrorSpecInfo errorSpec, @NotNull SqlErrorSpecInfo pattern) {
        Intrinsics.checkNotNullParameter((Object)errorSpec, (String)"errorSpec");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SqlStateInfo sqlState = errorSpec.component1();
        Object errorCode = errorSpec.component2();
        SqlStateInfo patternSqlState = pattern.component1();
        Object patternErrorCode = pattern.component2();
        if (patternErrorCode != null && Intrinsics.areEqual((Object)patternErrorCode, (Object)errorCode)) {
            return new SqlErrorSpecMatch.Matched(0);
        }
        if (!Intrinsics.areEqual((Object)patternSqlState, (Object)SqlStateInfo.Unknown.INSTANCE) && Intrinsics.areEqual((Object)patternSqlState, (Object)sqlState)) {
            return new SqlErrorSpecMatch.Matched(1);
        }
        Object object = patternSqlState instanceof SqlStateInfo.Wildcard ? (SqlStateInfo.Wildcard)patternSqlState : null;
        if (object == null || (object = ((SqlStateInfo.Wildcard)object).getKind()) == null) {
            return SqlErrorSpecMatch.Unmatched.INSTANCE;
        }
        Object patternKind = object;
        if (Intrinsics.areEqual((Object)sqlState, (Object)SqlStateInfo.Unknown.INSTANCE) && patternKind == SqlSpecialErrorSpec.Kind.OTHERS) {
            return new SqlErrorSpecMatch.Matched(2);
        }
        Object object2 = sqlState instanceof SqlStateInfo.Specific ? (SqlStateInfo.Specific)sqlState : null;
        if (object2 == null || (object2 = ((SqlStateInfo.Specific)object2).getValue()) == null) {
            return SqlErrorSpecMatch.Unmatched.INSTANCE;
        }
        Object sqlStateValue = object2;
        boolean matchesWildcard = switch (WhenMappings.$EnumSwitchMapping$0[((Enum)patternKind).ordinal()]) {
            case 1 -> StringsKt.startsWith$default((String)sqlStateValue, (String)"01", (boolean)false, (int)2, null);
            case 2 -> StringsKt.startsWith$default((String)sqlStateValue, (String)"02", (boolean)false, (int)2, null);
            case 3 -> {
                if (!(StringsKt.startsWith$default((String)sqlStateValue, (String)"00", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sqlStateValue, (String)"01", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sqlStateValue, (String)"02", (boolean)false, (int)2, null))) {
                    yield true;
                }
                yield false;
            }
            case 4 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
        return matchesWildcard ? (SqlErrorSpecMatch)new SqlErrorSpecMatch.Matched(2) : (SqlErrorSpecMatch)SqlErrorSpecMatch.Unmatched.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/sql/dataFlow/SqlErrorSpecHelper$Companion;", "", "<init>", "()V", "DEFAULT_INSTANCE", "Lcom/intellij/sql/dataFlow/SqlErrorSpecHelper;", "intellij.database.sql.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqlSpecialErrorSpec.Kind.values().length];
            try {
                nArray[SqlSpecialErrorSpec.Kind.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlSpecialErrorSpec.Kind.NOT_FOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlSpecialErrorSpec.Kind.EXCEPTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlSpecialErrorSpec.Kind.OTHERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

