/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.maria;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasColumnSymbol;
import com.intellij.database.symbols.DasPsiSymbol;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.DasTableSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.maria.MariaTokens;
import com.intellij.sql.dialects.mysql.MysqlDialectBase;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlLockTableStatement;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MariaDialect
extends MysqlDialectBase {
    public static final MariaDialect INSTANCE = new MariaDialect();

    private MariaDialect() {
        super("MariaDB");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(MariaTokens.class);
        if (tokensHelper == null) {
            MariaDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MARIA;
        if (dbms == null) {
            MariaDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MariaDialect.$$$reportNull$$$0(2);
        }
        if (type == SqlDbElementType.CURSOR && expectedTypes.contains(ObjectKind.ROUTINE)) {
            return true;
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            MariaDialect.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            MariaDialect.$$$reportNull$$$0(4);
        }
        if (!MariaDialect.processReservedEntitiesWithTypeSimple(LazyData.RE_SYSTEM_TIME, null, name2, place, resolve2, processor, false, false)) {
            return false;
        }
        if (name2 != null && LazyData.SEQUENCE_TABLE_PATTERN.matcher(name2).matches()) {
            SequenceTable dasTable = new SequenceTable(name2, place);
            return processor.executeTarget(dasTable, dasTable.createType(), false, ResolveState.initial());
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            for (ReservedEntity.Typed re : LazyData.RE_TIME_PERIOD_COLUMNS) {
                if (MariaDialect.processReservedEntitiesWithTypeSimple(re, re.type, name2, place, resolve2, processor, false, false)) continue;
                return false;
            }
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor);
    }

    @Override
    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        ObjectKind kind;
        if (identifier == null) {
            MariaDialect.$$$reportNull$$$0(5);
        }
        return (kind = SqlImplUtil.getIdentifierKind(identifier)) == ObjectKind.USER ? 80 : (kind == ObjectKind.ROLE ? 128 : super.getMaxIdentifierLength(identifier, version));
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            MariaDialect.$$$reportNull$$$0(6);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlLockTableStatement.class}) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/maria/MariaDialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/maria/MariaDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final ReservedEntity RE_SYSTEM_TIME = new ReservedEntity(Dbms.MARIA, "system_time", ObjectKind.PERIOD);
        static final List<ReservedEntity.Typed> RE_TIME_PERIOD_COLUMNS;
        static final Pattern SEQUENCE_TABLE_PATTERN;

        LazyData() {
        }

        static {
            DasTypeSystemBase typeSystem = DasTypeSystems.getTypeSystem(Dbms.MARIA);
            RE_TIME_PERIOD_COLUMNS = List.of(new ReservedEntity.Typed(Dbms.MARIA, "row_start", ObjectKind.COLUMN, typeSystem.getTimestampType()), new ReservedEntity.Typed(Dbms.MARIA, "row_end", ObjectKind.COLUMN, typeSystem.getTimestampType()));
            SEQUENCE_TABLE_PATTERN = Pattern.compile("seq_\\d+_to_\\d+(_step_\\d+)?", 2);
        }
    }

    private final class SequenceTable
    extends FakePsiElement
    implements DasTable,
    DasTableSymbol,
    DasPsiSymbol {
        private final String myName;
        private final PsiElement myContext;
        private final MySeqColumn myColumn;

        private SequenceTable(@NotNull String name2, PsiElement element) {
            if (name2 == null) {
                SequenceTable.$$$reportNull$$$0(0);
            }
            if (element == null) {
                SequenceTable.$$$reportNull$$$0(1);
            }
            this.myColumn = new MySeqColumn();
            this.myName = name2;
            this.myContext = element;
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = Dbms.MARIA;
            if (dbms == null) {
                SequenceTable.$$$reportNull$$$0(2);
            }
            return dbms;
        }

        @Override
        public boolean isSystem() {
            return false;
        }

        @Override
        public boolean isTemporary() {
            return false;
        }

        @Override
        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
            Set<DasColumn.Attribute> set = Collections.emptySet();
            if (set == null) {
                SequenceTable.$$$reportNull$$$0(3);
            }
            return set;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                SequenceTable.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                SequenceTable.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        public boolean isQuoted() {
            return true;
        }

        @Override
        @Nullable
        public DasTable getDasObject() {
            return this;
        }

        @Override
        @NotNull
        public JBIterable<? extends DasObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = kind == ObjectKind.COLUMN ? JBIterable.of((Object)this.myColumn) : JBIterable.empty();
            if (jBIterable == null) {
                SequenceTable.$$$reportNull$$$0(6);
            }
            return jBIterable;
        }

        public PsiElement getParent() {
            return this.myContext.getContainingFile();
        }

        public SqlTableType createType() {
            return SqlTableTypeBase.createType((PsiElement)this.myColumn, MariaDialect.this.getTypeSystem().getIntType(), this.myColumn.getName(), false, false, (PsiElement)this, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SequenceTable table = (SequenceTable)o;
            return this.myName.equals(table.myName) && this.myContext.equals(table.myContext);
        }

        public int hashCode() {
            return Objects.hash(this.myName, this.myContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/dialects/maria/MariaDialect$SequenceTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/dialects/maria/MariaDialect$SequenceTable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }

        class MySeqColumn
        extends FakePsiElement
        implements DasColumn,
        PsiMetaOwner,
        PsiPresentableMetaData,
        DasColumnSymbol,
        DasPsiSymbol {
            MySeqColumn() {
            }

            @Override
            @NotNull
            public Dbms getDbms() {
                Dbms dbms = Dbms.MARIA;
                if (dbms == null) {
                    MySeqColumn.$$$reportNull$$$0(0);
                }
                return dbms;
            }

            @Override
            public short getPosition() {
                return 1;
            }

            @Override
            @NotNull
            public DasTable getTable() {
                SequenceTable sequenceTable = SequenceTable.this;
                if (sequenceTable == null) {
                    MySeqColumn.$$$reportNull$$$0(1);
                }
                return sequenceTable;
            }

            @Override
            @NotNull
            public DasType getDasType() {
                DasType dasType = MariaDialect.this.getTypeSystem().getIntType();
                if (dasType == null) {
                    MySeqColumn.$$$reportNull$$$0(2);
                }
                return dasType;
            }

            @Override
            public boolean isNotNull() {
                return true;
            }

            @Override
            @Nullable
            public String getDefault() {
                return null;
            }

            @Override
            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    MySeqColumn.$$$reportNull$$$0(3);
                }
                return objectKind;
            }

            @Override
            @NonNls
            @NotNull
            public String getName() {
                return "seq";
            }

            @Override
            public boolean isQuoted() {
                return true;
            }

            public PsiElement getParent() {
                return SequenceTable.this;
            }

            @NotNull
            public PsiMetaData getMetaData() {
                MySeqColumn mySeqColumn = this;
                if (mySeqColumn == null) {
                    MySeqColumn.$$$reportNull$$$0(4);
                }
                return mySeqColumn;
            }

            @NlsSafe
            @NotNull
            public String getTypeName() {
                String string = StringUtil.toLowerCase((String)this.getKind().name());
                if (string == null) {
                    MySeqColumn.$$$reportNull$$$0(5);
                }
                return string;
            }

            @Nullable
            public Icon getIcon() {
                return null;
            }

            public PsiElement getDeclaration() {
                return null;
            }

            public String getName(PsiElement context) {
                return SequenceTable.this.myName;
            }

            @Override
            @NotNull
            public DasColumn getDasObject() {
                MySeqColumn mySeqColumn = this;
                if (mySeqColumn == null) {
                    MySeqColumn.$$$reportNull$$$0(6);
                }
                return mySeqColumn;
            }

            public void init(PsiElement element) {
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MySeqColumn column2 = (MySeqColumn)o;
                return this.getParent().equals(column2.getParent());
            }

            public int hashCode() {
                return Objects.hash(this.getParent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/dialects/maria/MariaDialect$SequenceTable$MySeqColumn";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDbms";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMetaData";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTypeName";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasObject";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }
}

