/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testing.JsTestConfigurationUtil;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.vitest.VitestRunConfiguration;
import com.intellij.javascript.testing.vitest.VitestRunSettings;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ0\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u000b\u0010\u001f\u001a\u00070\u0005\u00a2\u0006\u0002\b 2\u000b\u0010!\u001a\u00070\u0005\u00a2\u0006\u0002\b\"2\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010%\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestUtil;", "", "<init>", "()V", "VITEST_PACKAGE_NAME", "", "PKG_DESCRIPTOR", "Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "getPKG_DESCRIPTOR", "()Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "findContextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "findFile", "path", "writeXml", "", "element", "Lorg/jdom/Element;", "readXml", "checkRunConfiguration", "configuration", "Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "getVitestMainJsFile", "Ljava/nio/file/Path;", "pkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "notify", "project", "Lcom/intellij/openapi/project/Project;", "title", "Lcom/intellij/openapi/util/NlsContexts$NotificationTitle;", "content", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "notificationType", "Lcom/intellij/notification/NotificationType;", "TAG__CONFIG_FILE", "TAG__NODE_INTERPRETER", "TAG__NODE_OPTIONS", "TAG__VITEST_PACKAGE", "TAG__WORKING_DIR", "TAG__VITEST_OPTIONS", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nVitestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestUtil.kt\ncom/intellij/javascript/testing/vitest/VitestUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n14#2:113\n*S KotlinDebug\n*F\n+ 1 VitestUtil.kt\ncom/intellij/javascript/testing/vitest/VitestUtil\n*L\n99#1:113\n*E\n"})
public final class VitestUtil {
    @NotNull
    public static final VitestUtil INSTANCE = new VitestUtil();
    @NotNull
    private static final String VITEST_PACKAGE_NAME = "vitest";
    @NotNull
    private static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor("vitest");
    @NotNull
    private static final String TAG__CONFIG_FILE = "config";
    @NotNull
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    @NotNull
    private static final String TAG__NODE_OPTIONS = "node-options";
    @NotNull
    private static final String TAG__VITEST_PACKAGE = "vitest-package";
    @NotNull
    private static final String TAG__WORKING_DIR = "working-dir";
    @NotNull
    private static final String TAG__VITEST_OPTIONS = "vitest-options";

    private VitestUtil() {
    }

    @NotNull
    public final NodePackageDescriptor getPKG_DESCRIPTOR() {
        return PKG_DESCRIPTOR;
    }

    @Nullable
    public final VirtualFile findContextFile(@NotNull VitestRunSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        VirtualFile virtualFile = this.findFile(settings.getConfigFilePath());
        if (virtualFile == null) {
            virtualFile = this.findFile(settings.getWorkingDir());
        }
        return virtualFile;
    }

    private final VirtualFile findFile(String path2) {
        return FileUtil.isAbsolute((String)path2) ? LocalFileSystem.getInstance().findFileByPath(path2) : null;
    }

    public final void writeXml(@NotNull Element element2, @NotNull VitestRunSettings settings) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (((CharSequence)settings.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings.getConfigFilePath()));
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__NODE_INTERPRETER, settings.getInterpreterRef().getReferenceName());
        JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__NODE_OPTIONS, settings.getNodeOptions());
        NodePackage nodePackage = settings.getVitestPackage();
        if (nodePackage != null) {
            NodePackage it = nodePackage;
            boolean bl = false;
            JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__VITEST_PACKAGE, it.getSystemIndependentPath());
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDir()));
        if (((CharSequence)settings.getVitestOptions()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__VITEST_OPTIONS, settings.getVitestOptions());
        }
        settings.getEnvData().writeExternal(element2);
        settings.getScope().writeExternal(element2);
    }

    @NotNull
    public final VitestRunSettings readXml(@NotNull Element element2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        VitestRunSettings.Builder builder2 = new VitestRunSettings.Builder(null, null, null, null, null, null, null, null, 255, null);
        String string2 = JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__CONFIG_FILE);
        if (string2 == null) {
            string2 = "";
        }
        builder2.setConfigFilePath(string2);
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__NODE_INTERPRETER));
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"create(...)");
        builder2.setInterpreterRef(nodeJsInterpreterRef);
        String string3 = JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__NODE_OPTIONS);
        if (string3 == null) {
            string3 = "";
        }
        builder2.setNodeOptions(string3);
        String string4 = JDOMExternalizerUtil.readCustomField((Element)element2, (String)TAG__VITEST_PACKAGE);
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            builder2.setVitestPackage(PKG_DESCRIPTOR.createPackage(it));
        }
        if ((string = JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__WORKING_DIR)) == null) {
            string = "";
        }
        builder2.setWorkingDir(string);
        String string5 = JsTestConfigurationUtil.INSTANCE.readValue(element2, TAG__VITEST_OPTIONS);
        if (string5 == null) {
            string5 = "";
        }
        builder2.setVitestOptions(string5);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)element2);
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"readExternal(...)");
        builder2.setEnvData(environmentVariablesData);
        builder2.setScope(JsTestRunScope.Companion.readExternal(element2));
        return builder2.build();
    }

    public final void checkRunConfiguration(@NotNull VitestRunConfiguration configuration) throws RuntimeConfigurationException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        VitestRunSettings settings = configuration.getSettings();
        if (((CharSequence)settings.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.validatePath(false, "configuration file", settings.getConfigFilePath());
        }
        JsTestConfigurationUtil.INSTANCE.validatePath(true, "working directory", settings.getWorkingDir());
        NodeInterpreterUtil.checkForRunConfiguration(settings.getInterpreterRef().resolve(configuration.getProject()));
        configuration.getOrDetectVitestPackage().validateForRunConfiguration(VITEST_PACKAGE_NAME);
        settings.getScope().validateForRunConfiguration(false);
    }

    @NotNull
    public final Path getVitestMainJsFile(@NotNull NodePackage pkg) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        String string = PackageJsonUtil.guessDefaultBinaryNameOfDependency(pkg);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"guessDefaultBinaryNameOfDependency(...)");
        String binaryName = string;
        Path path2 = NodePackage.findBinFilePath$default(pkg, binaryName, "./vitest.mjs", null, 4, null);
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            return it;
        }
        Object[] objectArray = new Object[]{pkg.getName()};
        throw new ExecutionException(JavaScriptBundle.message("node.package.cannot.find.bin.file.dialog.message", objectArray));
    }

    public final void notify(@NotNull Project project, @NotNull String title, @NotNull String content, @NotNull NotificationType notificationType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)notificationType, (String)"notificationType");
        NotificationGroup vitestNotificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Vitest test runner");
        if (vitestNotificationGroup == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(VitestUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot find \"Vitest test runner\" notification group");
            return;
        }
        vitestNotificationGroup.createNotification(title, content, notificationType).notify(project);
    }
}

