/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocBuilderSimpleInfo {
    public static final String NEW_LINE_MARKDOWN_PLACEHOLDER = "\n\n";
    @NotNull
    private final StringBuilder myDescription = new StringBuilder();
    @NotNull
    protected final List<String> myExamples = new SmartList();
    @NotNull
    protected final MultiMap<String, String> mySimpleTags = MultiMap.createLinked();
    @Nullable
    JSType type;
    @Nullable
    String modifiers;
    @Nullable
    String finalAccess;
    @Nullable
    String namespace;
    boolean hasFiredEvents;

    boolean hasDescription() {
        return !this.myDescription.isEmpty() || !this.myExamples.isEmpty();
    }

    void addSimpleTag(@NotNull String key, @Nullable String text) {
        if (key == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(0);
        }
        this.mySimpleTags.putValue((Object)key, (Object)StringUtil.notNullize((String)text));
    }

    void addExample(@NotNull String example) {
        if (example == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(1);
        }
        this.myExamples.add(example);
    }

    @NotNull
    String getFinalDescription() {
        StringBuilder result2 = new StringBuilder(this.myDescription);
        for (String info : this.myExamples) {
            result2.append(info);
        }
        String string = result2.toString();
        if (string == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String convertMarkdownToHtml(@NotNull String html, @NotNull Project project) {
        if (html == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(4);
        }
        String string = StringUtil.trimStart((String)DocMarkdownToHtmlConverter.convert((Project)project, (String)html), (String)"<p>");
        if (string == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    String getHtmlDescription() {
        String string = this.myDescription.toString();
        if (string == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    void mergeHtmlDescriptionAndPlaceHolders(@NotNull JSDocBuilderSimpleInfo info) {
        if (info == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(7);
        }
        this.appendDescription(info.getHtmlDescription());
        this.myExamples.addAll(info.myExamples);
    }

    void appendDescription(@Nullable CharSequence htmlText) {
        if (htmlText == null) {
            return;
        }
        if (!this.myDescription.isEmpty() && !JSDocBuilderSimpleInfo.startsWithParagraphHeaderOrPre(htmlText)) {
            this.myDescription.append("<p>");
        }
        this.myDescription.append(htmlText);
    }

    private static boolean startsWithParagraphHeaderOrPre(@NotNull CharSequence htmlText) {
        if (htmlText == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(8);
        }
        if (htmlText.length() < 3) {
            return false;
        }
        if (htmlText.charAt(0) != '<') {
            return false;
        }
        char ch1 = htmlText.charAt(1);
        if (ch1 == 'p') {
            if (JSDocBuilderSimpleInfo.tagNameEnd(htmlText.charAt(2))) {
                return true;
            }
            if (htmlText.length() < 5) {
                return false;
            }
            return htmlText.charAt(2) == 'r' && htmlText.charAt(3) == 'e' && JSDocBuilderSimpleInfo.tagNameEnd(htmlText.charAt(4));
        }
        if (ch1 != 'h' || htmlText.length() < 4) {
            return false;
        }
        char ch2 = htmlText.charAt(2);
        return ch2 >= '1' && ch2 <= '6' && JSDocBuilderSimpleInfo.tagNameEnd(htmlText.charAt(3));
    }

    private static boolean tagNameEnd(char ch) {
        return ch == '>' || Character.isWhitespace(ch);
    }

    void mergeDescriptionWith(@NotNull JSDocBuilderSimpleInfo toMerge) {
        if (toMerge == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(9);
        }
        if (toMerge.hasDescription()) {
            this.appendDescription(toMerge.myDescription);
        }
    }

    @NotNull
    CharSequence getTypeString(@Nullable PsiElement context2) {
        this.type = this.type != null && context2 != null && !DumbService.isDumb((Project)context2.getProject()) ? this.type.substitute(context2) : this.type;
        CharSequence charSequence = JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(this.type, context2, this.hasFiredEvents);
        if (charSequence == null) {
            JSDocBuilderSimpleInfo.$$$reportNull$$$0(10);
        }
        return charSequence;
    }

    boolean hasType() {
        return JSFormatUtil.isPossiblyPresentableType(this.type, null, true) && this.type.isSourceStrict();
    }

    public void setJSType(JSType type2) {
        this.type = type2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "example";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocBuilderSimpleInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMerge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocBuilderSimpleInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMarkdownToHtml";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSimpleTag";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addExample";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertMarkdownToHtml";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeHtmlDescriptionAndPlaceHolders";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startsWithParagraphHeaderOrPre";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeDescriptionWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 10 -> new IllegalStateException(string);
        };
    }
}

