/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.controlflow.instruction;

import com.intellij.codeInsight.controlflow.impl.DetachedInstructionImpl;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSInstructionWithReachability;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConditionInstruction
extends DetachedInstructionImpl
implements JSInstructionWithReachability {
    private final boolean myValue;
    @NotNull
    private final ConditionState myState;

    public JSConditionInstruction(@Nullable PsiElement element2, boolean value, @NotNull ConditionState state) {
        if (state == null) {
            JSConditionInstruction.$$$reportNull$$$0(0);
        }
        super(element2);
        this.myValue = value;
        this.myState = state;
    }

    @Override
    public boolean isReachable() {
        if (this.myState == ConditionState.UNKNOWN) {
            return true;
        }
        ConditionState expected = ConditionState.toCondition(this.myValue);
        return expected == this.myState;
    }

    public boolean getValue() {
        return this.myValue;
    }

    @NotNull
    public String getElementPresentation() {
        String string = super.getElementPresentation() + " condition: " + this.myValue + ", " + (this.isReachable() ? "reachable" : "unreachable");
        if (string == null) {
            JSConditionInstruction.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/controlflow/instruction/JSConditionInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/controlflow/instruction/JSConditionInstruction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static enum ConditionState {
        UNKNOWN,
        CONDITION_ALWAYS_TRUE,
        CONDITION_ALWAYS_FALSE;


        public static ConditionState toCondition(boolean value) {
            return value ? CONDITION_ALWAYS_TRUE : CONDITION_ALWAYS_FALSE;
        }
    }
}

