/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_PARSER_H__
#define __BSE_PARSER_H__

#include	<bse/bsebase.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */




/* --- prototypes --- */
GScanner*	bse_parser_setup		(const gchar	*input_name,
						 gint		in_fd,
						 guint		line_offs,
						 guint		position_offs,
						 gchar		*input_text,
						 guint		input_text_len);
BseErrorType	bse_parser_parse		(GScanner	*scanner,
						 BseIoDataFlags	 read_mask,
						 GSList		*sample_names,
						 GSList		*song_names);
BseErrorType	bse_parser_read_binary_appendices (GScanner	*scanner);
void		bse_parser_complete_samples	(GScanner	*scanner);
void		bse_parser_complete_songs	(GScanner	*scanner);
void		bse_parser_shutdown		(GScanner	*scanner);
BseErrorType	bse_parser_identify_fd		(gint		 fd,
						 BseIoDataFlags	*flags_p);
GSList*		bse_parser_get_song_list	(GScanner	*scanner);
GSList*		bse_parser_get_sample_list	(GScanner	*scanner);





#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_PARSER_H__ */
