#include "cslarts.h"
#include "soundserver.h"
#include "debug.h"
#include <stdio.h>

using namespace Arts;

/* obsolete:
void clientWaitBufferLevel(CSL::Adapter adapter, long id, long level)
{
	CSL::StreamStatus status;
		
	for(;;) {
		status = adapter.status(id);
		//printf("streambufferused = %d\n", status.streamBufferUsed);

		if(status.streamBufferUsed <= level) return;
		usleep(100000);
	}
}	*/

int main(int argc, char **argv)
{
	Dispatcher dispatcher;
	SoundServer server = Reference("global:Arts_SoundServer");
	arts_return_val_if_fail(!server.isNull(),1);

	CSL::Adapter adapter = (Arts::DynamicCast)server.createObject("CSL::Adapter");
	arts_return_val_if_fail(!adapter.isNull(),1);

	long sample = adapter.sampleNew(argv[1], "cslplaycxx", "CSL Play C++ Test");
	if (!sample)
		arts_fatal("unable to create sample");

	FILE *infile = fopen(argv[1],"r");
	if (infile == NULL)
		arts_fatal("unable to load sample from file '%s'", argv[1]);

	vector<mcopbyte> buffer;
	int len;
	buffer.resize(4096);
	while ((len = fread (&buffer[0], 1, buffer.size(), infile)) > 0)
		adapter.sampleWrite(sample, buffer);

	fclose(infile);

	adapter.sampleWriteDone(sample);
	adapter.samplePlay(sample);
	adapter.sampleWaitDone(sample);
	adapter.sampleRelease(sample);

	return 0;
}

// vim:ts=4:sts=4:sw=4
