/* CSL - Common Sound Layer
 * Copyright (C) 2000-2001 Stefan Westerfeld and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef CSL_STREAM_IMPL_H
#define CSL_STREAM_IMPL_H

#include "cslarts.h"
#include "stdsynthmodule.h"
#include "resample.h"
#include "pipebuffer.h"
#include "artsflow.h"

namespace CSL {

class Adapter_impl;

class Stream_impl : virtual public Stream_skel,
					virtual public Arts::StdSynthModule
{
protected:
	long _ID;
	Direction _direction;

	std::string _role;
	std::string _title;

	long _bufferUsed;
	long _bufferSize;

	StreamParams _params;
	bool _active;

	Adapter_impl *adapter;

public:
	Stream_impl(Adapter_impl *adapter);

	long ID() { return _ID; }
	Direction direction() { return _direction; }

	std::string role() { return _role; }
	std::string title() { return _title; }
	// void title(const std::string& newTitle);

	long bufferUsed() { return _bufferUsed; }
	long bufferSize() { return _bufferSize; }
	// void bufferSize(long newSize);

	StreamParams params() { return _params; }
	// void params(const StreamParams& newParams);
	
	bool active() { return _active; }
	// void active(bool newActive);
};

class PlayStream_impl : virtual public PlayStream_skel,
						virtual public Stream_impl,
						virtual public Arts::Refiller
{
private:
	Arts::Resampler resampler;
	Arts::Synth_AMAN_PLAY play;
	Arts::PipeBuffer buffer;
	bool connected;

public:
	PlayStream_impl(Adapter_impl *adapter, const std::string& role, long ID);

	// IDL:
	void title(const std::string& newTitle);
	void write(const std::vector<Arts::mcopbyte>& bytes);

	void bufferSize(long newSize);
	void params(const StreamParams& newParams);
	void active(bool newActive);

	void clearBuffer();
	void close();

	// SynthModule:
	void calculateBlock(unsigned long samples);

	// Refiller:
	unsigned long read(unsigned char *data, unsigned long len);
};

class RecordStream_impl : virtual public RecordStream_skel,
						  virtual public Stream_impl
{
	Arts::Synth_AMAN_RECORD record;
	Arts::PipeBuffer buffer;
	bool connected;
	Arts::mcopbyte *outblock;
	unsigned long maxsamples;

public:
	RecordStream_impl(Adapter_impl *adapter, const std::string& role, long ID);
	~RecordStream_impl();

	void title(const std::string& newTitle);
	std::vector<Arts::mcopbyte> *read(long len);

	void bufferSize(long newSize);
	void params(const StreamParams& newParams);
	void active(bool newActive);

	void clearBuffer();
	void close();

	void calculateBlock(unsigned long samples);
};

};
#endif /* CSL_STREAM_IMPL_H */
