#include <stdarg.h>

#include <gtk/gtk.h>

#include "at_interface.h"
#include "at_menu.h"
#include "at_com.h"
#include "at_quit.h"
#include "at_track.h"
#include "version.h"

GtkWidget *scrolled_window_vbox;


/* this is the GtkMenuEntry structure used to create new menus.  The
 * first member is the menu definition string.  The second, the
 * default accelerator key used to access this menu function with
 * the keyboard.  The third is the callback function to call when
 * this menu item is selected (by the accelerator key, or with the
 * mouse.) The last member is the data to pass to your callback function.
 */

GtkMenuEntry main_menu_items[] =
{
	{"<Main>/File/New", "<control>N", at_clip_new_cmd_callback, NULL},
	{"<Main>/File/Open", "<control>O", NULL, NULL},
	{"<Main>/File/About...", "<control>S", NULL, NULL},
	{"<Main>/File/<separator>", NULL, NULL, NULL},
	{"<Main>/File/Quit", "<control>Q", at_quit, NULL},
	{"<Main>/Preferences/Play...", NULL, at_com_play_configure, NULL},
    	{"<Main>/Preferences/Record...", NULL, at_com_record_configure, NULL}
};

/* calculate the number of menu_item's */
gint nmain_menu_items = sizeof(main_menu_items) / sizeof(main_menu_items[0]);


static gint at_interface_delete (void)
{
    return(TRUE);
}


void at_interface_init(void)
{
    GtkWidget *window;
    GtkWidget *box;
    GtkWidget *menubar;
    GtkAcceleratorTable *accel;
    
    gchar buf[1024];
    
    /* main window */
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    /* gtk_widget_set_usize (window, 400, 300);*/
    gtk_container_border_width(GTK_CONTAINER(window), 5);
    gtk_signal_connect(GTK_OBJECT(window), "destroy",
		       GTK_SIGNAL_FUNC(at_quit), NULL);
    gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		       GTK_SIGNAL_FUNC(at_interface_delete), NULL);
    sprintf (buf, "Audiotechque %s", VERSION);
    gtk_window_set_title (GTK_WINDOW(window), buf);
    gtk_window_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    
    /* main vbox */
    box = gtk_vbox_new(FALSE, 5);
    gtk_container_add (GTK_CONTAINER (window), box);
    gtk_widget_show (box);

    /* menubar */
    at_menu_new (&menubar, &accel, main_menu_items, nmain_menu_items);
    gtk_window_add_accelerator_table (GTK_WINDOW (window), accel);
    gtk_box_pack_start (GTK_BOX (box), menubar, FALSE, TRUE, 0);
    gtk_widget_show (menubar);

    /* show window */
    gtk_widget_show (window);

}


/* this is found in glib, but is not declared in glib.h */
extern char* g_vsprintf (gchar *fmt,
			 va_list *args,
			 va_list *args2);

/* Just for debugging and playing around with */
void at_print (gchar *format, ...)
{
    GtkWidget *label;
    
    va_list args, args2;
    gchar *buf;
    
    va_start (args, format);
    va_start (args2, format);
    buf = g_vsprintf (format, &args, &args2);
    va_end (args);
    va_end (args2);

    label = gtk_label_new (buf);
    gtk_box_pack_start(GTK_BOX(scrolled_window_vbox), label, FALSE, TRUE, 0);
    gtk_widget_show(label);
}
 
GtkWidget *at_interface_pixmapped_button_new (gchar *xpm_filename, 
					      gchar *label_text)
{
    GtkWidget *hbox;
    GtkWidget *pixmap;
    GtkWidget *button;
    GtkWidget *label;
    
    button = gtk_button_new();
    
    hbox = gtk_hbox_new(FALSE, 5);
    gtk_container_add (GTK_CONTAINER (button), hbox);
    gtk_widget_show (hbox);
    
    if (label_text != NULL) {
	label = gtk_label_new (label_text);
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 1);
	gtk_widget_show (label);
    }
    
    if (xpm_filename !=NULL) {
	pixmap = at_interface_pixmap_new (button, xpm_filename);
	gtk_box_pack_start (GTK_BOX (hbox), pixmap, FALSE, TRUE, 1);
	gtk_widget_show (pixmap);
    }
    
    return (button);
}
   
/* utility function */

GtkWidget *at_interface_pixmap_new (GtkWidget *parent, gchar *xpm_filename)
{
    GtkWidget *pixmapwid;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GtkStyle *style;

    gtk_widget_realize (parent);

    style = gtk_widget_get_style(parent);

    /* now on to the xpm stuff.. load xpm */
    pixmap = gdk_pixmap_create_from_xpm (parent->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 xpm_filename);
    pixmapwid = gtk_pixmap_new (pixmap, mask);
    return(pixmapwid);
}       


    

