/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_money_pot.c
 * @brief Implementation of the insert_money_pot function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_insert_money_pot.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_insert_money_pot (
  void *cls,
  const char *instance_id,
  const char *name,
  const char *description,
  uint64_t *money_pot_id)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (instance_id),
    GNUNET_PQ_query_param_string (name),
    GNUNET_PQ_query_param_string (description),
    GNUNET_PQ_query_param_end
  };
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_uint64 ("money_pot_serial",
                                  money_pot_id),
    GNUNET_PQ_result_spec_end
  };

  check_connection (pg);
  PREPARE (pg,
           "insert_money_pot",
           "INSERT INTO merchant_money_pots"
           "(merchant_serial"
           ",money_pot_name"
           ",money_pot_description)"
           " SELECT merchant_serial, $2, $3"
           "   FROM merchant_instances"
           "  WHERE merchant_id=$1"
           " ON CONFLICT DO NOTHING"
           " RETURNING money_pot_serial;");
  return GNUNET_PQ_eval_prepared_singleton_select (pg->conn,
                                                   "insert_money_pot",
                                                   params,
                                                   rs);
}
