---
title: 'Documentation'
linkTitle: 'Documentation'
menu:
  main:
    weight: 15
---

Skia is an open source 2D graphics library which provides common APIs that work
across a variety of hardware and software platforms. It serves as the graphics
engine for Google Chrome and Chrome OS, Android, Flutter, Mozilla Firefox and
Firefox OS, and many other products.

Skia is sponsored and managed by Google, but is available for use by anyone
under the BSD Free Software License. While engineering of the core components is
done by the Skia development team, we consider contributions from any source.

- Canonical source tree:
  [skia.googlesource.com/skia](https://skia.googlesource.com/skia).
- Issue tracker: [bug.skia.org](https://bug.skia.org/).
- Discussion forum:
  [skia-discuss@googlegroups.com](https://groups.google.com/forum/#!forum/skia-discuss).
- [API Reference and Overview](https://skia.org/docs/user/api/).
- Skia Fiddle: [fiddle.skia.org](https://fiddle.skia.org/c/@skcanvas_paint).

## Showcase

Click on any image below to see the source code that generated the image.

<table>
  <tr><th>Shapes</th><th>Bézier Curves</th></tr>
  <tr>
    <td>
      <a href='https://fiddle.skia.org/c/@shapes'><img src='https://fiddle.skia.org/i/@shapes_raster.png'></a>
    </td>
    <td>
      <a href='https://fiddle.skia.org/c/@bezier_curves'><img src='https://fiddle.skia.org/i/@bezier_curves_raster.png'></a>
    </td>
  </tr>

  <tr><th>Translations and Rotations</th><th>Text Rendering</th></tr>
  <tr>
    <td>
      <a href='https://fiddle.skia.org/c/@rotations'><img src='https://fiddle.skia.org/i/@rotations_raster.png'></a>
    </td>
    <td>
      <a href='https://fiddle.skia.org/c/@text_rendering'><img src='https://fiddle.skia.org/i/@text_rendering_raster.png'></a>
    </td>
  </tr>

  <tr><th>Discrete Path Effects</th><th>Composed Path Effects</th></tr>
  <tr>
    <td>
      <a href='https://fiddle.skia.org/c/@discrete_path'><img src='https://fiddle.skia.org/i/@discrete_path_raster.png'></a>
    </td>
    <td>
      <a href='https://fiddle.skia.org/c/@compose_path'><img src='https://fiddle.skia.org/i/@compose_path_raster.png'></a>
    </td>
  </tr>
  <tr><th>Sum Path Effects</th><th>Shaders</th></tr>
  <tr>
    <td>
      <a href='https://fiddle.skia.org/c/@sum_path_effect'><img src='https://fiddle.skia.org/i/@sum_path_effect_raster.png'></a>
    </td>
    <td>
      <a href='https://fiddle.skia.org/c/@shader'><img src='https://fiddle.skia.org/i/@shader_raster.png'></a>
    </td>
  </tr>
</table>

## Platforms

- Windows 7, 8, 8.1, 10
- macOS 10.10.5 or later
- iOS 11 or later
- Android 4.1 (JellyBean) or later
- Ubuntu 18.04+, Debian 10+, openSUSE 15.2+, or Fedora Linux 32+
