// $Id: FFActionHandler.h 489 2005-09-25 15:12:31Z ravemax $

#import <sys/time.h>

// Other classes
@class FFOptions, FFPreferences;
@class FFImageList, FFImageData, FFImageWindow, FFFullscreenWindow;
@class FFOSD;
@class FFPageView, FFPage;


@interface FFActionHandler : NSResponder {
	FFImageWindow*			m_imageWindow;
	FFPageView*				m_pageView;
	
	// Bunch of FF class instances
	FFOptions*				m_opts;
	FFPreferences*			m_prefs;
	FFImageList*			m_imgList;
	FFOSD*					m_OSD;
	
	// Ringer buffer
	NSLock*					m_imageLock, *m_loadLock;
	int						m_ringBufSize, m_fetchDist;
	FFPage**				m_ringBuffer;
	int						m_lastImgIdx, m_ringIdx;
	
	// Fullscreen
	FFFullscreenWindow*		m_fsWin;
	
	// Panning
	BOOL					m_ctrlForPanning;
	BOOL					m_panningOn;
	
	// Fullscreen cursor visibility
	NSTimer*				m_cursorHideTimer;
	struct timeval			m_lastMouseMove;
	struct timeval			m_lastFullscreenCheck;
	BOOL					m_mouseIsVisible;
	
	// Magnifying lens
	NSCursor*				m_crossCursorSmall;

	// Misc
	BOOL					m_singleImage; // Required for the view click
}

- (id)initWithOptions:(FFOptions*)opts preferences:(FFPreferences*)prefs
		 andImageList:(FFImageList*)imgList;
- (void)cleanUp;

// Panning & page
- (void)panLeft;
- (void)panLeftAccel;
- (void)panRight;
- (void)panRightAccel;
- (void)panUp;
- (void)panUpAccel;
- (void)panDown;
- (void)panDownAccel;
- (void)pageUp;
- (void)pageDown;

- (BOOL)canPageUp;
- (BOOL)canPageDown;
- (BOOL)canMoveLeft;
- (BOOL)canMoveRight;

// Misc. exported
- (void)showImageWindow;
- (NSWindow*)imageWindow;
- (void)autoFullScreenIfPossible;
- (void)showInternalStatus;

// [Internal] Forwarding
- (void)_switchToWindowedMode;

@end
