RCS_ID("$Id: FFOptions.m 564 2006-08-20 14:17:42Z ravemax $")

#import "FFOptions.h"

#ifdef FFVIEW_APPLICATION
	#import "FFPreferences.h"

	// The notifications (send)
	NSString*	RotationChangedNotification					= @"rotation_changed";
	NSString*	ScalingChangedNotification					= @"scaling_changed";
	NSString*	PageModeChangedNotification					= @"pagemode_changed";
	NSString*	NoBlowUpChangedNotification					= @"no_blowup_changed";
	NSString*	AntialiasingChangedNotification				= @"aa_changed";
	NSString*	SpeechOnChangedNotification					= @"speech_on_changed";
	NSString*   ScreenModeChangedNotification				= @"screenmode_changed";
	NSString*   OSDVisibilityChangedNotification			= @"osd_visibility_changed";
	NSString*	MagnifyingLensVisibilityChangedNotification	= @"mag_lens_visibility_changed";
	NSString*   ZoomMultiplierChangedNotification			= @"zoom_mult_changed";

	// Notifications (receive)
	NSString*   ToggleScreenModeNotification				= @"toggle_screen_mode";
	NSString*   ToggleOSDVisibilityNotification				= @"toggle_osd_visibility";
	NSString*	ToggleMagnifyingLensVisibilityNotification	= @"toggle_mag_lens_visibility";
	NSString*   ZoomInNotification							= @"zoom_in";
	NSString*   ZoomOutNotification							= @"zoom_out";

	// Names for the user defaults
	static NSString*	UDNameRotation			= @"udn_opt_rot";
	static NSString*	UDNameScaling			= @"udn_opt_scal";
	static NSString*	UDNamePageMode			= @"udn_opt_pmode";
	static NSString*	UDNameNoBlowUp			= @"udn_no_blowup";
	static NSString*	UDNameAntialiasing		= @"udn_opt_aa";
	static NSString*	UDNameSpeechOn			= @"udn_opt_speech";
	static NSString*	UDNameArchiveEncoding	= @"udn_arch_enc";

	// Boolean strings
	static NSString*	UDBoolTrue	= @"yes";
	static NSString*	UDBoolFalse	= @"no";
#endif // FFVIEW_APPLICATION


@implementation FFOptions

#pragma mark -
#pragma mark Initialisation and cleanup (FFVIEW_APPLICATION)

#ifdef FFVIEW_APPLICATION

- (id)initWithPrefs:(FFPreferences*)prefs {
	self = [super init];
	if (self != nil) {
		m_nc = [NSNotificationCenter defaultCenter]; // no retain!
	
		NSDictionary* defDict = [NSDictionary dictionaryWithObjectsAndKeys:
			[NSNumber numberWithInt:OPT_NO_ROTATION], UDNameRotation,
			[NSNumber numberWithInt:OPT_NO_SCALING], UDNameScaling,
			[NSNumber numberWithInt:OPT_MODE_SINGLE], UDNamePageMode,
			UDBoolFalse, UDNameNoBlowUp,
			UDBoolTrue, UDNameAntialiasing,
			UDBoolTrue, UDNameSpeechOn,
			
			[NSNumber numberWithInt:[NSString defaultCStringEncoding]], UDNameArchiveEncoding,
			nil];
		
		if ([prefs saveOpts]) {
			NSUserDefaults* ud = [NSUserDefaults standardUserDefaults];
			
			// Defaults
			[ud registerDefaults:defDict];

			// Load values
			[self setRotation:(FFOptRotation)[ud integerForKey:UDNameRotation]];
			[self setScaling:(FFOptScaling)[ud integerForKey:UDNameScaling]];
			[self setPageMode:(FFOptPageMode)[ud integerForKey:UDNamePageMode]];
			[self setNoBlowUp:[ud boolForKey:UDNameNoBlowUp]];
			[self setAntialiasing:[ud boolForKey:UDNameAntialiasing]];
			[self setSpeechOn:[ud boolForKey:UDNameSpeechOn]];

		} else {
			[self setRotation:(FFOptRotation)[[defDict objectForKey:UDNameRotation] intValue]];
			[self setScaling:(FFOptScaling)[[defDict objectForKey:UDNameScaling] intValue]];
			[self setPageMode:(FFOptPageMode)[[defDict objectForKey:UDNamePageMode] intValue]];
			[self setNoBlowUp:[[defDict objectForKey:UDNameNoBlowUp] isEqualToString:UDBoolTrue]];
			[self setAntialiasing:[[defDict objectForKey:UDNameAntialiasing] isEqualToString:UDBoolTrue]];
			[self setSpeechOn:[[defDict objectForKey:UDNameSpeechOn] isEqualToString:UDBoolTrue]];
		}
		
		// Format
		[self setArchiveEncoding:[[NSUserDefaults standardUserDefaults] integerForKey:UDNameArchiveEncoding]];
		
		// View
		[self setFullscreen:FALSE];
		[self setOSDVisibility:FALSE];
		[self setMagnifyingLensVisibility:FALSE];
		
		m_prefs = [prefs retain];
		[self zoomReset];
			
		// Notification to receive
		[m_nc addObserver:self selector:@selector(toggleScreenMode:)
					 name:ToggleScreenModeNotification object:nil];
		[m_nc addObserver:self selector:@selector(toggleOSDVisibility:) 
					 name:ToggleOSDVisibilityNotification object:nil];
		[m_nc addObserver:self selector:@selector(toggleMagnifyingLensVisibility:)
					 name:ToggleMagnifyingLensVisibilityNotification object:nil];
		[m_nc addObserver:self selector:@selector(zoomIn:)
					 name:ZoomInNotification object:nil];
		[m_nc addObserver:self selector:@selector(zoomOut:)
					 name:ZoomOutNotification object:nil];		
	}
	return self;
}

- (void)save {
	NSUserDefaults* ud = [NSUserDefaults standardUserDefaults];
	[ud setInteger:[self rotation] forKey:UDNameRotation];
	[ud setInteger:[self scaling] forKey:UDNameScaling];
	[ud setInteger:[self pageMode] forKey:UDNamePageMode];
	[ud setBool:[self noBlowUp] forKey:UDNameNoBlowUp];
	[ud setBool:[self antialiasing] forKey:UDNameAntialiasing];
	[ud setBool:[self speechOn] forKey:UDNameSpeechOn];
	
	[ud setInteger:[self archiveEncoding] forKey:UDNameArchiveEncoding];
}

- (void)dealloc {
	[m_nc removeObserver:self];
	[m_prefs release];
	[super dealloc];
}

#pragma mark -
#pragma mark Initialisation and cleanup (FFVIEW_FRAMEWORK)

#else // !FFVIEW_APPLICATION

- (id)init {
	self = [super init];
	if (self) {
		m_zoomFactor	= 0.25;
		
		m_rotation		= OPT_NO_ROTATION;
		m_scaling		= OPT_NO_SCALING;
		m_pageMode		= OPT_MODE_SINGLE;
		m_noBlowUp		= FALSE;
		m_antialiasing	= TRUE;
		m_speechOn		= FALSE; // will probably never be used
		
		[self zoomReset];
	}
	return self;
}

#endif // FFVIEW_APPLICATION

#pragma mark -
#pragma mark Getter

- (FFOptRotation)rotation			{ return m_rotation; }
- (FFOptScaling)scaling				{ return m_scaling; }
- (FFOptPageMode)pageMode			{ return m_pageMode; }
- (BOOL)noBlowUp					{ return m_noBlowUp; }
- (BOOL)antialiasing				{ return m_antialiasing; }
- (BOOL)speechOn					{ return m_speechOn; }
- (float)zoomMultiplier				{ return m_zoomMultiplier; }

#ifdef FFVIEW_APPLICATION
	- (BOOL)fullscreen					{ return m_fullscreen; }
	- (BOOL)isOSDVisible				{ return m_OSDVisibility; }
	- (BOOL)isMagnifyingLensVisible		{ return m_magnifyingLensVisibility; }
	- (NSStringEncoding)archiveEncoding	{ return m_archiveEncoding; }
#endif

#pragma mark -
#pragma mark Setters with notification

#ifdef FFVIEW_APPLICATION
	#define POST_NOTIFICATION(NAME) \
		[m_nc postNotificationName:NAME object:nil]
#else
	#define POST_NOTIFICATION(NAME)
#endif

- (void)setRotation:(FFOptRotation)rot {
	if (rot != m_rotation) {
		m_rotation = rot;
		POST_NOTIFICATION(RotationChangedNotification);
	}
}

- (void)setScaling:(FFOptScaling)scal {
	if (scal != m_scaling) {
		m_scaling = scal;
		POST_NOTIFICATION(ScalingChangedNotification);
	}
}

- (void)setPageMode:(FFOptPageMode)pmode {
	if (pmode != m_pageMode) {
		m_pageMode = pmode;
		POST_NOTIFICATION(PageModeChangedNotification);
	}
}

- (void)setNoBlowUp:(BOOL)no {
	if (no != m_noBlowUp) {
		m_noBlowUp = no;
		POST_NOTIFICATION(NoBlowUpChangedNotification);
	}
}

- (void)setAntialiasing:(BOOL)aa {
	if (aa != m_antialiasing) {
		m_antialiasing = aa;
		POST_NOTIFICATION(AntialiasingChangedNotification);
	}
}

- (void)setSpeechOn:(BOOL)speech {
	if (speech != m_speechOn) {
		m_speechOn = speech;
		POST_NOTIFICATION(SpeechOnChangedNotification);
	}
}

- (void)zoomReset {
	m_zoomMultiplier = 1.0;
	POST_NOTIFICATION(ZoomMultiplierChangedNotification);
}

#ifdef FFVIEW_APPLICATION
	#define ZOOM_FACTOR	[m_prefs zoomFactor]
#else
	#define ZOOM_FACTOR m_zoomFactor
#endif

- (void)zoomIn {
	m_zoomMultiplier += ZOOM_FACTOR;
	POST_NOTIFICATION(ZoomMultiplierChangedNotification);
}

- (void)zoomIn:(NSNotification*)notification {
	[self zoomIn];
}

- (void)zoomOut {
	if ((m_zoomMultiplier - ZOOM_FACTOR) > 0.0f) {
		m_zoomMultiplier -= ZOOM_FACTOR;
		POST_NOTIFICATION(ZoomMultiplierChangedNotification);
	}
}

- (void)zoomOut:(NSNotification*)notification {
	[self zoomOut];
}

#pragma mark -
#pragma mark Setters with notification (FFVIEW_APPLICATION)

#ifdef FFVIEW_APPLICATION

- (void)setFullscreen:(BOOL)fs {
	if (fs != m_fullscreen) {
		m_fullscreen = fs;
		POST_NOTIFICATION(ScreenModeChangedNotification);
	}
}

- (void)toggleScreenMode {
	[self setFullscreen:([self fullscreen] ^ TRUE)];
}

- (void)toggleScreenMode:(NSNotification*)notification {
	[self toggleScreenMode];
}

- (void)setOSDVisibility:(BOOL)osd {
	if (osd != m_OSDVisibility) {
		m_OSDVisibility  = osd;
		POST_NOTIFICATION(OSDVisibilityChangedNotification);
	}
}

- (void)toggleOSDVisibility {
	[self setOSDVisibility:([self isOSDVisible] ^ TRUE)];
}

- (void)toggleOSDVisibility:(NSNotification*)notification {
	[self toggleOSDVisibility];
}

- (void)setMagnifyingLensVisibility:(BOOL)lens {
	if (lens != m_magnifyingLensVisibility) {
		m_magnifyingLensVisibility = lens;
		POST_NOTIFICATION(MagnifyingLensVisibilityChangedNotification);
	}
}

- (void)toggleMagnifyingLensVisibility {
	[self setMagnifyingLensVisibility:([self isMagnifyingLensVisible] ^ TRUE)];
}

- (void)toggleMagnifyingLensVisibility:(NSNotification*)notification {
	[self toggleMagnifyingLensVisibility];
}

#pragma mark -
#pragma mark Setter w/o notification (FFVIEW_APPLICATION)

- (void)setArchiveEncoding:(NSStringEncoding)encoding {
	m_archiveEncoding = encoding;
}

#pragma mark -
#pragma mark Setter w/o notification (FFVIEW_FRAMEWORK)

#else // !FFVIEW_APPLICATION

- (void)setZoomFactor:(float)factor {
	m_zoomFactor = factor;
}

#endif // FFVIEW_APPLICATION

@end
