// $Id: FFArchivePDF.h 495 2005-09-26 16:15:17Z ravemax $
// PDFs are handled like an (pseudo) archive

#import <FFArchive/FFArchive.h>

@interface FFPDFImage : NSObject {
	CGPDFStreamRef		m_stream;
	CGPDFDictionaryRef	m_dict;
}

- (id)initWithStream:(CGPDFStreamRef)stream
	   andDictionary:(CGPDFDictionaryRef)dict;

- (CGPDFStreamRef)stream;
- (CGPDFDictionaryRef)dict;

@end

#pragma mark -

@interface FFArchivePDF : FFArchive {
	CGPDFDocumentRef		m_document;
	NSMutableArray*			m_files;
	NSMutableDictionary*	m_images;
}

- (id)initWithFile:(NSString*)filePath fallbackEncoding:(NSStringEncoding)enc;
- (NSArray*)filesInArchive;
- (void)extractFile:(NSString*)filename toFilePath:(NSString*)toPath;


@end
