RCS_ID("$Id$")

#import "FFMacModel.h"
#import <IOKit/IOKitLib.h>

static NSString* name = nil;

NSString* macModelName() {
	if (name == nil) {
		io_service_t platformExpert = IOServiceGetMatchingService(kIOMasterPortDefault, 
																  IOServiceMatching("IOPlatformExpertDevice"));
		if (platformExpert) {
			CFTypeRef model = IORegistryEntryCreateCFProperty(platformExpert,
															  CFSTR("model"),
															  kCFAllocatorDefault, 0);

			if (model == NULL)
				name = @"";
			else {
				name = [[NSString alloc] initWithCString:(const char*)CFDataGetBytePtr(model)
												encoding:NSASCIIStringEncoding];
				CFRelease(model);
			}
			IOObjectRelease(platformExpert);
		} else
			name = @"";
	}
	return name;
}
