RCS_ID("$Id: FFTile.m 559 2006-08-20 14:15:11Z ravemax $")

#import "FFTile.h"
#import "FFGL.h"

@implementation FFTile
	
- (void)_createTextureWithData:(GLubyte*)data rowLength:(GLint)rowLength
					skipPixels:(GLint)skipPixels skipRows:(GLint)skipRows {
	
	// Create texture name
	glDisable(GL_TEXTURE_2D);
	glGenTextures(1, &m_texName);
	glBindTexture(GL_TEXTURE_RECTANGLE_EXT, m_texName);
	
	// We need the pipeline exclusive since we modify the copy attributes
	lockGLPixelPipeline();
	
	// Set image data offset
	glPixelStorei(GL_UNPACK_ROW_LENGTH, rowLength);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, skipPixels);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, skipRows);
	
	// Create the texture
	#ifdef __LITTLE_ENDIAN__
		glTexImage2D(GL_TEXTURE_RECTANGLE_EXT, 0, GL_RGB8, width, height, 0,
					 GL_BGRA, GL_UNSIGNED_INT_8_8_8_8, data);
	#else
		glTexImage2D(GL_TEXTURE_RECTANGLE_EXT, 0, GL_RGB8, width, height, 0,
					 GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, data); // REV: ARGB -> BGRA
	#endif

	if (glGetError() != GL_NO_ERROR) {
		glDeleteTextures(1, &m_texName);
		m_texName = NO_TEXTURE;
	}
	
	// Reset image data offset
	glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
	glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);
	glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
	
	// Now some else can have the pipeline
	unlockGLPixelPipeline();
}

- (id)initWithData:(GLubyte*)data dataWidth:(GLuint)dataWidth
			 dataX:(GLint)dataX dataY:(GLint)dataY
			 width:(GLuint)wd height:(GLuint)ht
		  initialX:(float)ix initialY:(float)iy {

	FFLOG(6, @"FFTile: InitWith:wd=%u x ht=%u; ix=%4.1f, iy=%4.1f", 
		  wd, ht, ix, iy);
	
	self = [super init];
	if (self != nil) {
		self->width		= wd;
		self->height	= ht;
		self->x			= ix;
		self->y			= iy;
		
		[self _createTextureWithData:data rowLength:dataWidth
							   skipPixels:dataX skipRows:dataY];
		
		// Failed to create the texture
		if (m_texName == NO_TEXTURE) {
			m_texData		= data;
			m_texRowLen		= dataWidth;
			m_texSkipPx		= dataX;
			m_texSkipRows	= dataY;
		}
	}
	return self;
}

- (void)dealloc {
	if (m_texName != 0)
		glDeleteTextures(1, &m_texName);

	[super dealloc];
}

- (void)draw {
	FFLOG(6, @"FFTile: Draw: x=%4.2f, y=%4.2f; wd=%u, ht=%u - texName=%u",
		  x, y, width, height, m_texName);

	// No texture - try to create the texture now
	if (m_texName == NO_TEXTURE) { 
		[self _createTextureWithData:m_texData rowLength:m_texRowLen
						  skipPixels:m_texSkipPx skipRows:m_texSkipRows];
		
		if (m_texName == NO_TEXTURE) // No chance
			return;
	}
	
	// Draw the textured quad
	glPushMatrix();
	GL(glTranslatef(x, y, 0.0f));

	// Texture: CW - vertexes: CCW
	glBindTexture(GL_TEXTURE_RECTANGLE_EXT, m_texName);
	GL(glBegin(GL_QUADS));
		GL(glTexCoord2i(0, 0));
		GL(glVertex3i(0, height, 0));
		GL(glTexCoord2i(0, height));
		GL(glVertex3i(0, 0, 0));
		GL(glTexCoord2i(width, height));
		GL(glVertex3i(width, 0, 0));
		GL(glTexCoord2i(width, 0));
		GL(glVertex3i(width, height, 0));
	glEnd();
		
	glPopMatrix();
}

- (NSString*)description {
	return [NSString stringWithFormat:@"FFTile %d (%p): %ux%u @ %.1f,%.1f",
		m_texName, self, width, height, x, y];
}

@end
