// $Id: FFInputEventOVNode.h 407 2005-06-08 20:33:42Z ravemax $

#import "FFMainController.h"

@class FFInputEvent;

@interface FFInputEventOVNode : NSObject {
	NSString*				m_title;
	NSMutableArray*			m_subnodes; // type: FFInputEventOVNode
	FFInputEventOVNode*		m_superNode;
	FFInputEvent*			m_event;
	NSString*				m_eventAsString;
	NSColor*				m_bgColor;
	FFMenuAction			m_action;
}

+ (FFInputEventOVNode*)nodeWithTitle:(NSString*)title
				  andBackgroundColor:(NSColor*)col;
+ (FFInputEventOVNode*)nodeWithTitle:(NSString*)title 
					 backgroundColor:(NSColor*)col 
						   andAction:(FFMenuAction)action;

// Setters
- (void)setEvent:(FFInputEvent*)event;
- (void)setSuperNode:(FFInputEventOVNode*)node;
- (void)resetEvent;
- (void)setTitle:(NSString*)title;

// Getters
- (NSString*)title;
- (FFInputEvent*)event;
- (NSString*)eventAsString;
- (FFInputEventOVNode*)superNode;
- (NSColor*)backgroundColor;
- (FFMenuAction)action;

// Subnodes read access
- (BOOL)hasSubnodes;
- (int)numberOfSubnodes;
- (FFInputEventOVNode*)subnodeAtIndex:(int)index;
- (NSEnumerator*)subnodeEnumerator;
- (int)numberOfSubnodesWithEventAndAction:(FFMenuAction)action;
- (int)numberOfSubnodesWithEventAndTitle:(NSString*)title;
- (unsigned)indexOfNode:(FFInputEventOVNode*)node;
- (FFInputEventOVNode*)previousNode;

// Modifying the subnodes
- (void)addSubnode:(FFInputEventOVNode*)node;
- (void)insertNodeAfterThisNode:(FFInputEventOVNode*)node;
- (void)removeSubnode:(FFInputEventOVNode*)node;

@end
