RCS_ID("$Id: FFDropWindow.m 407 2005-06-08 20:33:42Z ravemax $")

#import "FFDropWindow.h"
#import <math.h>

@implementation FFDropWindow

#pragma mark File / directory drop

- (void)setDropReceiver:(id)recv andSelector:(SEL)sel {
	m_dropReceiver  = recv;
	m_dropSelector  = sel;
	
	[self registerForDraggedTypes:[NSArray arrayWithObject:NSFilenamesPboardType]];	
}

- (void)setFocusRingSelector:(SEL)sel {
	m_focusRingSelector = sel;
}

- (NSDragOperation)draggingEntered:(id<NSDraggingInfo>)sender {
	NSArray* types;

	types = [[sender draggingPasteboard] types];
	if ([types containsObject:NSFilenamesPboardType] && 
		([sender draggingSourceOperationMask] & NSDragOperationGeneric)) {
//		[m_dropReceiver performSelector:m_focusRingSelector withObject:[NSNumber numberWithBool:TRUE]];
		return NSDragOperationGeneric;
	}

	return NSDragOperationNone;
}

- (BOOL)performDragOperation:(id<NSDraggingInfo>)sender {
	NSPasteboard*	pb;
	NSArray*		types, *files;
	
	pb = [sender draggingPasteboard];
	types = [pb types];
	if ([types containsObject:NSFilenamesPboardType]) {
		files = [pb propertyListForType:NSFilenamesPboardType];
//		[m_dropReceiver performSelector:m_focusRingSelector withObject:[NSNumber numberWithBool:FALSE]];		
		[m_dropReceiver performSelector:m_dropSelector withObject:files];
	}
	
	return TRUE;
}

/*
- (void)draggingExited:(id <NSDraggingInfo>)sender {
	[m_dropReceiver performSelector:m_focusRingSelector withObject:[NSNumber numberWithBool:FALSE]];
}
*/

#pragma mark -
#pragma mark Snap to a window

- (void)dealloc {
	[super dealloc];
	[[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)setWindowToSnap:(NSWindow*)win andTolerance:(float)tolerance {
	if (tolerance > 0.0f) { // 0.0f = snapping disabled
		m_snapTolerance	= tolerance;
		m_winToSnap		= win;
		m_snapped		= FALSE;
	
		[[NSNotificationCenter defaultCenter] addObserver:self 
			selector:@selector(windowMoved:) name:NSWindowDidMoveNotification object:self];
	}
}

- (void)windowMoved:(NSNotification*)not {		
	NSRect	winFrame, ownFrame;
	float	ownXR, winXR;
	BOOL	snap;

	// Only snap if the window is visible
	if ([m_winToSnap isVisible]) {
		winFrame	= [m_winToSnap frame];
		ownFrame	= [self frame];
		ownXR		= winFrame.origin.x + winFrame.size.width;
		winXR		= ownFrame.origin.x + ownFrame.size.width;
	
		// Left
		if (fabs(winFrame.origin.x - winXR) < m_snapTolerance) {
			ownFrame.origin.x = winFrame.origin.x - ownFrame.size.width;
			snap = TRUE;
		}
	
		// Right
		else if (fabs(ownFrame.origin.x - ownXR) < m_snapTolerance) {
			ownFrame.origin.x	= ownXR;
			snap	= TRUE;

		// No snap
		} else
			snap	= FALSE;
		
	// Isn't visible
	} else
		snap = FALSE;
	
	// Now update
	if (snap) {
		[self setFrameOrigin:ownFrame.origin];
		if (!m_snapped) {
			[m_winToSnap addChildWindow:self ordered:NSWindowAbove];
			m_snapped = TRUE;
		}
	} else if (m_snapped) {
		[m_winToSnap removeChildWindow:self];		
		m_snapped = FALSE;
	}
}

@end
