# Base Io build system
# Written by Jeremy Tregunna <jeremy.tregunna@me.com>
#
# Find libMYSQL.

FIND_PATH(MYSQL_INCLUDE_DIR mysql.h /usr/include/mysql)

SET(MYSQL_NAMES ${MYSQL_NAMES} mysqlclient mysqlclient_r)
FIND_LIBRARY(MYSQL_LIBRARY NAMES ${MYSQL_NAMES} PATH /usr/lib/mysql)

IF(MYSQL_INCLUDE_DIR AND MYSQL_LIBRARY)
	SET(MYSQL_FOUND TRUE)
ENDIF(MYSQL_INCLUDE_DIR AND MYSQL_LIBRARY)

IF(MYSQL_FOUND)
	IF(NOT Mysql_FIND_QUIETLY)
		MESSAGE(STATUS "Found MYSQL: ${MYSQL_LIBRARY}")
	ENDIF (NOT Mysql_FIND_QUIETLY)
ELSE(MYSQL_FOUND)
	IF(Mysql_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find MYSQL")
	ENDIF(Mysql_FIND_REQUIRED)
ENDIF (MYSQL_FOUND)
