# Base Io build system
# Written by Jeremy Tregunna <jeremy.tregunna@me.com>
#
# Find libtaglib.

FIND_PATH(TAGLIB_INCLUDE_DIR taglib/tag_c.h)

SET(TAGLIB_NAMES ${TAGLIB_NAMES} tag_c libtag_c)
FIND_LIBRARY(TAGLIB_LIBRARY NAMES ${TAGLIB_NAMES} PATH)

IF(TAGLIB_INCLUDE_DIR AND TAGLIB_LIBRARY)
	SET(TAGLIB_FOUND TRUE)
ENDIF(TAGLIB_INCLUDE_DIR AND TAGLIB_LIBRARY)

IF(TAGLIB_FOUND)
	IF(NOT TagLib_FIND_QUIETLY)
		MESSAGE(STATUS "Found TagLib: ${TAGLIB_LIBRARY}")
	ENDIF (NOT TagLib_FIND_QUIETLY)
ELSE(TAGLIB_FOUND)
	IF(TagLib_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find taglib")
	ENDIF(TagLib_FIND_REQUIRED)
ENDIF (TAGLIB_FOUND)
