/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OptionParser;

public class ProgramArguments {
    private final Map<Option, List<String>> argMap = new EnumMap<Option, List<String>>(Option.class);

    public ProgramArguments(String ... args) {
        Stream.of(Option.values()).forEach(o -> this.argMap.put((Option)((Object)o), new ArrayList()));
        this.buildCommandLineArgumentMap(args);
    }

    private void buildCommandLineArgumentMap(String ... args) {
        OptionParser parser = new OptionParser("JOSM");
        for (Option o : Option.values()) {
            if (o.requiresArgument()) {
                parser.addArgumentParameter(o.getName(), OptionParser.OptionCount.MULTIPLE, p -> this.addOption(o, (String)p));
                continue;
            }
            parser.addFlagParameter(o.getName(), () -> this.addOption(o, ""));
        }
        parser.addShortAlias(Option.HELP.getName(), "h");
        parser.addShortAlias(Option.VERSION.getName(), "v");
        List<String> remaining = parser.parseOptionsOrExit(Arrays.asList(args));
        for (String arg : remaining) {
            this.addOption(Option.DOWNLOAD, arg);
        }
    }

    private void addOption(Option opt, String optarg) {
        this.argMap.get((Object)opt).add(optarg);
    }

    public Optional<String> getSingle(Option option) {
        return this.get(option).stream().findFirst();
    }

    public Collection<String> get(Option option) {
        return Collections.unmodifiableList(this.argMap.get((Object)option));
    }

    public boolean hasOption(Option option) {
        return !this.get(option).isEmpty();
    }

    public boolean showVersion() {
        return this.hasOption(Option.VERSION);
    }

    public boolean showHelp() {
        return !this.get(Option.HELP).isEmpty();
    }

    public Level getLogLevel() {
        if (this.hasOption(Option.TRACE)) {
            return Logging.LEVEL_TRACE;
        }
        if (this.hasOption(Option.DEBUG)) {
            return Logging.LEVEL_DEBUG;
        }
        return Logging.LEVEL_INFO;
    }

    public Map<String, String> getPreferencesToSet() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.get(Option.SET).stream().map(i -> i.split("=", 2)).forEach(kv -> map.put(kv[0], ProgramArguments.getValue(kv)));
        return map;
    }

    private static String getValue(String ... kv) {
        if (kv.length < 2) {
            return "";
        }
        if ("null".equals(kv[1])) {
            return null;
        }
        return kv[1];
    }

    public static enum Option {
        HELP(false),
        VERSION(false),
        DEBUG(false),
        TRACE(false),
        LANGUAGE(true),
        RESET_PREFERENCES(false),
        LOAD_PREFERENCES(true),
        SET(true),
        GEOMETRY(true),
        NO_MAXIMIZE(false),
        MAXIMIZE(false),
        DOWNLOAD(true),
        DOWNLOADGPS(true),
        SELECTION(true),
        OFFLINE(true),
        SKIP_PLUGINS(false);

        private final String name = this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
        private final boolean requiresArg;

        private Option(boolean requiresArgument) {
            this.requiresArg = requiresArgument;
        }

        public String getName() {
            return this.name;
        }

        public boolean requiresArgument() {
            return this.requiresArg;
        }
    }
}

