/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public final class TagConflictResolutionUtil {
    private static final String KEY_SOURCE = "source";
    private static final String GRP_FR_CADASTRE = "FR:cadastre";
    private static final String GRP_CA_CANVEC = "CA:canvec";
    private static final Collection<AutomaticCombine> defaultAutomaticTagConflictCombines = Arrays.asList(new AutomaticCombine("tiger:tlid", "US TIGER tlid", false, ":", "Integer"), new AutomaticCombine("tiger:(?!tlid$).*", "US TIGER not tlid", true, ":", "String"));
    private static final Collection<AutomaticChoice> defaultAutomaticTagConflictChoices = Arrays.asList(new AutomaticChoice("source", "FR:cadastre", "FR cadastre source, manual value", true, "cadastre", "0"), new AutomaticChoice("source", "FR:cadastre", "FR cadastre source, initial format", true, "extraction vectorielle v1 cadastre-dgi-fr source : Direction G[e\u00e9]n[e\u00e9]rale des Imp[o\u00f4]ts - Cadas\\. Mise [a\u00e0] jour : (2[0-9]{3})", "$1 1"), new AutomaticChoice("source", "FR:cadastre", "FR cadastre source, last format", true, "(?:cadastre-dgi-fr source : )?Direction G[e\u00e9]n[e\u00e9]rale des (?:Imp[o\u00f4]ts|Finances Publiques) - Cadas(?:tre)?(?:\\.| ;) [Mm]ise [a\u00e0] jour : (2[0-9]{3})", "$1 2"), new AutomaticChoice("source", "CA:canvec", "CA canvec source, initial value", true, "CanVec_Import_2009", "00"), new AutomaticChoice("source", "CA:canvec", "CA canvec source, 4.0/6.0 value", true, "CanVec ([1-9]).0 - NRCan", "0$1"), new AutomaticChoice("source", "CA:canvec", "CA canvec source, 7.0/8.0 value", true, "NRCan-CanVec-([1-9]).0", "0$1"), new AutomaticChoice("source", "CA:canvec", "CA canvec source, 10.0/12.0 value", true, "NRCan-CanVec-(1[012]).0", "$1"));
    private static volatile Collection<AutomaticTagConflictResolver> automaticTagConflictResolvers;

    private TagConflictResolutionUtil() {
    }

    public static void normalizeTagCollectionBeforeEditing(TagCollection tc, Collection<? extends OsmPrimitive> merged) {
        for (String key : AbstractPrimitive.getDiscardableKeys()) {
            tc.removeByKey(key);
        }
        Collection taggedPrimitives = merged.stream().filter(OsmPrimitive::isTagged).collect(Collectors.toList());
        if (taggedPrimitives.size() <= 1) {
            return;
        }
        for (String key : tc.getKeys()) {
            for (OsmPrimitive p : taggedPrimitives) {
                if (p.get(key) != null) continue;
                tc.add(new Tag(key, ""));
            }
        }
    }

    public static void completeTagCollectionForEditing(TagCollection tc) {
        for (String key : tc.getKeys()) {
            tc.add(new Tag(key, ""));
        }
    }

    public static void applyAutomaticTagConflictResolution(TagCollection tc) {
        try {
            TagConflictResolutionUtil.applyAutomaticTagConflictResolution(tc, TagConflictResolutionUtil.getAutomaticTagConflictResolvers());
        }
        catch (JosmRuntimeException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to automatically resolve tag conflicts", e);
        }
    }

    public static Collection<AutomaticTagConflictResolver> getAutomaticTagConflictResolvers() {
        if (automaticTagConflictResolvers == null) {
            List<AutomaticCombine> automaticTagConflictCombines = StructUtils.getListOfStructs(Config.getPref(), "automatic-tag-conflict-resolution.combine", defaultAutomaticTagConflictCombines, AutomaticCombine.class);
            Collection<AutomaticChoiceGroup> automaticTagConflictChoiceGroups = AutomaticChoiceGroup.groupChoices(StructUtils.getListOfStructs(Config.getPref(), "automatic-tag-conflict-resolution.choice", defaultAutomaticTagConflictChoices, AutomaticChoice.class));
            ArrayList<AutomaticTagConflictResolver> tmp = new ArrayList<AutomaticTagConflictResolver>();
            tmp.addAll(automaticTagConflictCombines);
            tmp.addAll(automaticTagConflictChoiceGroups);
            automaticTagConflictResolvers = tmp;
        }
        return Collections.unmodifiableCollection(automaticTagConflictResolvers);
    }

    public static void applyAutomaticTagConflictResolution(TagCollection tc, Collection<AutomaticTagConflictResolver> resolvers) {
        block2: for (String key : tc.getKeysWithMultipleValues()) {
            for (AutomaticTagConflictResolver resolver : resolvers) {
                try {
                    String result;
                    if (!resolver.matchesKey(key) || (result = resolver.resolve(tc.getValues(key))) == null) continue;
                    tc.setUniqueForKey(key, result);
                    continue block2;
                }
                catch (PatternSyntaxException e) {
                    Logging.error(e);
                }
            }
        }
    }

    public static class AutomaticCombine
    implements AutomaticTagConflictResolver {
        @StructUtils.StructEntry
        public String key;
        @StructUtils.StructEntry
        public String description = "";
        @StructUtils.StructEntry
        public boolean isRegex;
        @StructUtils.StructEntry
        public String separator = ";";
        @StructUtils.StructEntry
        public String sort;

        public AutomaticCombine() {
        }

        public AutomaticCombine(String key, String description, boolean isRegex, String separator, String sort) {
            this.key = key;
            this.description = description;
            this.isRegex = isRegex;
            this.separator = separator;
            this.sort = sort;
        }

        @Override
        public boolean matchesKey(String k) {
            if (this.isRegex) {
                return Pattern.matches(this.key, k);
            }
            return this.key.equals(k);
        }

        Set<String> instantiateSortedSet() {
            if ("String".equals(this.sort)) {
                return new TreeSet<String>();
            }
            if ("Integer".equals(this.sort)) {
                return new TreeSet<String>(Comparator.comparing(Long::valueOf));
            }
            return new LinkedHashSet<String>();
        }

        @Override
        public String resolve(Set<String> values) {
            Set<String> results = this.instantiateSortedSet();
            String pattern = Pattern.quote(this.separator);
            try {
                for (String value : values) {
                    results.addAll(Arrays.asList(value.split(pattern, -1)));
                }
            }
            catch (NumberFormatException e) {
                Logging.error("Unable to parse {0} values in {1} -> {2}", this.sort, this, e.getMessage());
                Logging.debug(e);
                results = values;
            }
            return String.join((CharSequence)this.separator, results);
        }

        public String toString() {
            return AutomaticCombine.class.getSimpleName() + "(key='" + this.key + "', description='" + this.description + "', isRegex=" + this.isRegex + ", separator='" + this.separator + "', sort='" + this.sort + "')";
        }
    }

    public static class AutomaticChoice {
        @StructUtils.StructEntry
        public String key;
        @StructUtils.StructEntry
        public String group;
        @StructUtils.StructEntry
        public String description = "";
        @StructUtils.StructEntry
        public boolean isRegex;
        @StructUtils.StructEntry
        public String value;
        @StructUtils.StructEntry
        public String score;

        public AutomaticChoice() {
        }

        public AutomaticChoice(String key, String group, String description, boolean isRegex, String value, String score) {
            this.key = key;
            this.group = group;
            this.description = description;
            this.isRegex = isRegex;
            this.value = value;
            this.score = score;
        }

        public boolean matchesValue(String v) {
            if (this.isRegex) {
                return Pattern.matches(this.value, v);
            }
            return this.value.equals(v);
        }

        public String computeScoreFromValue(String v) {
            if (this.isRegex) {
                return v.replaceAll("^" + this.value + "$", this.score);
            }
            return this.score;
        }

        public String toString() {
            return AutomaticChoice.class.getSimpleName() + "(key='" + this.key + "', group='" + this.group + "', description='" + this.description + "', isRegex=" + this.isRegex + ", value='" + this.value + "', score='" + this.score + "')";
        }
    }

    public static class AutomaticChoiceGroup
    implements AutomaticTagConflictResolver {
        @StructUtils.StructEntry
        public String key;
        final String group;
        @StructUtils.StructEntry
        public boolean isRegex;
        final List<AutomaticChoice> choices;

        public AutomaticChoiceGroup(String key, String group, boolean isRegex, List<AutomaticChoice> choices) {
            this.key = key;
            this.group = group;
            this.isRegex = isRegex;
            this.choices = choices;
        }

        public static Collection<AutomaticChoiceGroup> groupChoices(Collection<AutomaticChoice> choices) {
            HashMap<Pair<String, String>, AutomaticChoiceGroup> results = new HashMap<Pair<String, String>, AutomaticChoiceGroup>();
            for (AutomaticChoice choice : choices) {
                Pair<String, String> id = new Pair<String, String>(choice.key, choice.group);
                AutomaticChoiceGroup group = (AutomaticChoiceGroup)results.get(id);
                if (group == null) {
                    boolean isRegex = choice.isRegex && !Pattern.quote(choice.key).equals(choice.key);
                    group = new AutomaticChoiceGroup(choice.key, choice.group, isRegex, new ArrayList<AutomaticChoice>());
                    results.put(id, group);
                }
                group.choices.add(choice);
            }
            return results.values();
        }

        @Override
        public boolean matchesKey(String k) {
            if (this.isRegex) {
                return Pattern.matches(this.key, k);
            }
            return this.key.equals(k);
        }

        @Override
        public String resolve(Set<String> values) {
            String bestScore = "";
            String bestValue = "";
            for (String value : values) {
                String score = null;
                for (AutomaticChoice choice : this.choices) {
                    if (!choice.matchesValue(value)) continue;
                    score = choice.computeScoreFromValue(value);
                }
                if (score == null) {
                    return null;
                }
                if (score.compareTo(bestScore) < 0) continue;
                bestScore = score;
                bestValue = value;
            }
            return bestValue;
        }

        public String toString() {
            Collection stringChoices = this.choices.stream().map(AutomaticChoice::toString).collect(Collectors.toCollection(ArrayList::new));
            return AutomaticChoiceGroup.class.getSimpleName() + "(key='" + this.key + "', group='" + this.group + "', isRegex=" + this.isRegex + ", choices=(\n  " + String.join((CharSequence)",\n  ", stringChoices) + "))";
        }
    }

    static interface AutomaticTagConflictResolver {
        public boolean matchesKey(String var1);

        public String resolve(Set<String> var1);
    }
}

