/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.validation;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.ValidatorVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.draw.MapViewPath;
import org.openstreetmap.josm.gui.draw.SymbolShape;
import org.openstreetmap.josm.tools.Utils;

public class PaintVisitor
implements OsmPrimitiveVisitor,
ValidatorVisitor {
    private final Graphics2D g;
    private final MapView mv;
    private Color color;
    private boolean selected;
    private final Set<PaintedPoint> paintedPoints = new HashSet<PaintedPoint>();
    private final Set<PaintedSegment> paintedSegments = new HashSet<PaintedSegment>();

    public PaintVisitor(Graphics2D g, MapView mv) {
        this.g = g;
        this.mv = mv;
    }

    @Override
    public void visit(TestError error) {
        if (error != null && !error.isIgnored()) {
            this.color = error.getSeverity().getColor();
            this.selected = error.isSelected();
            error.visitHighlighted(this);
        }
    }

    @Override
    public void visit(OsmPrimitive p) {
        if (p.isUsable()) {
            p.accept(this);
        }
    }

    protected void drawNode(Node n, Color color) {
        PaintedPoint pp = new PaintedPoint(n.getCoor(), color);
        if (!this.paintedPoints.contains(pp)) {
            MapViewPath circle = new MapViewPath(this.mv.getState()).shapeAround(n, SymbolShape.CIRCLE, 10.0);
            if (this.selected) {
                this.g.setColor(PaintVisitor.getHighlightColor(color));
                this.g.fill(circle);
            }
            this.g.setColor(color);
            this.g.draw(circle);
            this.paintedPoints.add(pp);
        }
    }

    protected void drawSegment(Point p1, Point p2, Color color) {
        double t = Math.atan2((double)p2.x - (double)p1.x, (double)p2.y - (double)p1.y);
        double cosT = 5.0 * Math.cos(t);
        double sinT = 5.0 * Math.sin(t);
        int deg = (int)Utils.toDegrees(t);
        if (this.selected) {
            this.g.setColor(PaintVisitor.getHighlightColor(color));
            int[] x = new int[]{(int)((double)p1.x + cosT), (int)((double)p2.x + cosT), (int)((double)p2.x - cosT), (int)((double)p1.x - cosT)};
            int[] y = new int[]{(int)((double)p1.y - sinT), (int)((double)p2.y - sinT), (int)((double)p2.y + sinT), (int)((double)p1.y + sinT)};
            this.g.fillPolygon(x, y, 4);
            this.g.fillArc(p1.x - 5, p1.y - 5, 10, 10, deg, 180);
            this.g.fillArc(p2.x - 5, p2.y - 5, 10, 10, deg, -180);
        }
        this.g.setColor(color);
        this.g.drawLine((int)((double)p1.x + cosT), (int)((double)p1.y - sinT), (int)((double)p2.x + cosT), (int)((double)p2.y - sinT));
        this.g.drawLine((int)((double)p1.x - cosT), (int)((double)p1.y + sinT), (int)((double)p2.x - cosT), (int)((double)p2.y + sinT));
        this.g.drawArc(p1.x - 5, p1.y - 5, 10, 10, deg, 180);
        this.g.drawArc(p2.x - 5, p2.y - 5, 10, 10, deg, -180);
    }

    protected void drawSegment(Node n1, Node n2, Color color) {
        PaintedSegment ps;
        if (n1.isDrawable() && n2.isDrawable() && this.isSegmentVisible(n1, n2) && !this.paintedSegments.contains(ps = new PaintedSegment(n1.getCoor(), n2.getCoor(), color))) {
            this.drawSegment(this.mv.getPoint(n1), this.mv.getPoint(n2), color);
            this.paintedSegments.add(ps);
        }
    }

    @Override
    public void visit(Node n) {
        if (n.isDrawable() && this.isNodeVisible(n)) {
            this.drawNode(n, this.color);
        }
    }

    @Override
    public void visit(Way w) {
        this.visit(w.getNodes());
    }

    @Override
    public void visit(WaySegment ws) {
        if (ws.lowerIndex < 0 || ws.lowerIndex + 1 >= ws.way.getNodesCount()) {
            return;
        }
        this.drawSegment(ws.getFirstNode(), ws.getSecondNode(), this.color);
    }

    @Override
    public void visit(Relation r) {
    }

    protected boolean isNodeVisible(Node n) {
        Point p = this.mv.getPoint(n);
        return p.x >= 0 && p.y >= 0 && p.x <= this.mv.getWidth() && p.y <= this.mv.getHeight();
    }

    protected boolean isSegmentVisible(Node n1, Node n2) {
        Point p1 = this.mv.getPoint(n1);
        Point p2 = this.mv.getPoint(n2);
        return !(p1.x < 0 && p2.x < 0 || p1.y < 0 && p2.y < 0 || p1.x > this.mv.getWidth() && p2.x > this.mv.getWidth() || p1.y > this.mv.getHeight() && p2.y > this.mv.getHeight());
    }

    @Override
    public void visit(List<Node> nodes) {
        Node lastN = null;
        for (Node n : nodes) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            this.drawSegment(lastN, n, this.color);
            lastN = n;
        }
    }

    private static Color getHighlightColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * 0.4));
    }

    public void clearPaintedObjects() {
        this.paintedPoints.clear();
        this.paintedSegments.clear();
    }

    protected static class PaintedPoint {
        protected final LatLon p1;
        protected final Color color;

        public PaintedPoint(LatLon p1, Color color) {
            this.p1 = p1;
            this.color = color;
        }

        public int hashCode() {
            return Objects.hash(this.p1, this.color);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PaintedPoint that = (PaintedPoint)obj;
            return Objects.equals(this.p1, that.p1) && Objects.equals(this.color, that.color);
        }
    }

    protected static class PaintedSegment
    extends PaintedPoint {
        private final LatLon p2;

        public PaintedSegment(LatLon p1, LatLon p2, Color color) {
            super(p1, color);
            this.p2 = p2;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.p2);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            PaintedSegment that = (PaintedSegment)obj;
            return Objects.equals(this.p2, that.p2);
        }
    }
}

