/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences.sources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourcePrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class MapPaintPrefHelper
extends SourcePrefHelper {
    public static final MapPaintPrefHelper INSTANCE = new MapPaintPrefHelper();

    public MapPaintPrefHelper() {
        super("mappaint.style.entries", SourceType.MAP_PAINT_STYLE);
    }

    @Override
    public List<SourceEntry> get() {
        List<SourceEntry> ls = super.get();
        if (this.insertNewDefaults(ls)) {
            this.put(ls);
        }
        return ls;
    }

    private boolean insertNewDefaults(List<SourceEntry> list) {
        boolean changed = false;
        TreeSet<String> knownDefaults = new TreeSet<String>(Config.getPref().getList("mappaint.style.known-defaults"));
        Collection<ExtendedSourceEntry> defaults = this.getDefault();
        int insertionIdx = 0;
        for (SourceEntry sourceEntry : defaults) {
            int i = Utils.indexOf(list, se -> Objects.equals(def.url, se.url));
            if (i == -1 && !knownDefaults.contains(sourceEntry.url)) {
                sourceEntry.active = false;
                list.add(insertionIdx, sourceEntry);
                ++insertionIdx;
                changed = true;
            } else if (i >= insertionIdx) {
                insertionIdx = i + 1;
            }
            knownDefaults.add(sourceEntry.url);
        }
        Config.getPref().putList("mappaint.style.known-defaults", new ArrayList<String>(knownDefaults));
        list.removeIf(se -> "resource://styles/standard/elemstyles.xml".equals(se.url));
        return changed;
    }

    @Override
    public Collection<ExtendedSourceEntry> getDefault() {
        ExtendedSourceEntry defJosmMapcss = new ExtendedSourceEntry(this.type, "elemstyles.mapcss", "resource://styles/standard/elemstyles.mapcss");
        defJosmMapcss.active = true;
        defJosmMapcss.name = "standard";
        defJosmMapcss.icon = new ImageProvider("logo").getResource();
        defJosmMapcss.title = I18n.tr("JOSM default (MapCSS)", new Object[0]);
        defJosmMapcss.description = I18n.tr("Internal style to be used as base for runtime switchable overlay styles", new Object[0]);
        ExtendedSourceEntry defPL2 = new ExtendedSourceEntry(this.type, "potlatch2.mapcss", "resource://styles/standard/potlatch2.mapcss");
        defPL2.active = false;
        defPL2.name = "standard";
        defPL2.icon = new ImageProvider("dialogs/mappaint", "pl2_small").getResource();
        defPL2.title = I18n.tr("Potlatch 2", new Object[0]);
        defPL2.description = I18n.tr("the main Potlatch 2 style", new Object[0]);
        return Arrays.asList(defJosmMapcss, defPL2);
    }

    @Override
    public Map<String, String> serialize(SourceEntry entry) {
        Map<String, String> res = super.serialize(entry);
        res.put("active", Boolean.toString(entry.active));
        if (entry.name != null) {
            res.put("ptoken", entry.name);
        }
        return res;
    }

    @Override
    public SourceEntry deserialize(Map<String, String> s) {
        return new SourceEntry(this.type, s.get("url"), s.get("ptoken"), s.get("title"), Boolean.parseBoolean(s.get("active")));
    }
}

