/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.vector;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.QuadBucketPrimitiveStore;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.tools.Logging;

class DataStore<O extends IPrimitive, N extends INode, W extends IWay<N>, R extends IRelation<?>> {
    protected final LocalQuadBucketPrimitiveStore<N, W, R> store = new LocalQuadBucketPrimitiveStore();
    protected final Storage<O> allPrimitives = new Storage<PrimitiveId>(new Storage.PrimitiveIdHash(), true);
    protected final Set<Tile> addedTiles = Collections.synchronizedSet(new HashSet());
    protected final Map<PrimitiveId, O> primitivesMap = Collections.synchronizedMap(this.allPrimitives.foreignKey(new Storage.PrimitiveIdHash()));
    protected final Collection<DataSource> dataSources = new LinkedList<DataSource>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    DataStore() {
    }

    public QuadBucketPrimitiveStore<N, W, R> getStore() {
        return this.store;
    }

    public Storage<O> getAllPrimitives() {
        return this.allPrimitives;
    }

    public Map<PrimitiveId, O> getPrimitivesMap() {
        return this.primitivesMap;
    }

    public Collection<DataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.dataSources);
    }

    public void addDataSource(DataSource dataSource) {
        this.dataSources.add(dataSource);
    }

    protected void removePrimitive(O primitive) {
        if (primitive == null) {
            return;
        }
        try {
            this.readWriteLock.writeLock().lockInterruptibly();
            if (this.allPrimitives.contains(primitive)) {
                this.store.removePrimitive((IPrimitive)primitive);
                this.allPrimitives.remove(primitive);
                this.primitivesMap.remove(primitive.getPrimitiveId());
            }
        }
        catch (InterruptedException e) {
            Logging.error(e);
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.readWriteLock.isWriteLockedByCurrentThread()) {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    protected void addPrimitive(O primitive) {
        this.store.addPrimitive((IPrimitive)primitive);
        this.allPrimitives.add(primitive);
        this.primitivesMap.put(primitive.getPrimitiveId(), primitive);
    }

    protected ReentrantReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    static class LocalQuadBucketPrimitiveStore<N extends INode, W extends IWay<N>, R extends IRelation<?>>
    extends QuadBucketPrimitiveStore<N, W, R> {
        LocalQuadBucketPrimitiveStore() {
        }

        @Override
        public void removePrimitive(IPrimitive primitive) {
            super.removePrimitive(primitive);
        }
    }
}

