/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.SaveToFile;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.session.AbstractSessionExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.w3c.dom.Element;

public abstract class GenericSessionExporter<T extends Layer>
extends AbstractSessionExporter<T> {
    private final String type;
    private final String version;
    private final String extension;
    private final JRadioButton link;
    private final JRadioButton include;

    protected GenericSessionExporter(T layer, String type, String version, String extension) {
        super(layer);
        this.type = type;
        this.version = version;
        this.extension = extension;
        this.link = new JRadioButton(I18n.tr("local file", new Object[0]));
        this.include = new JRadioButton(I18n.tr("include", new Object[0]));
    }

    @Override
    public JPanel getExportPanel() {
        JButton save;
        JPanel p = new JPanel(new GridBagLayout());
        JPanel topRow = new JPanel(new GridBagLayout());
        this.export.setSelected(true);
        JLabel lbl = new JLabel(this.layer.getName(), this.layer.getIcon(), 10);
        lbl.setToolTipText(this.layer.getToolTipText());
        lbl.setLabelFor(this.export);
        JLabel lblData = new JLabel(I18n.tr("Data:", new Object[0]));
        this.link.putClientProperty("actionname", "link");
        if (this.layer instanceof OsmDataLayer) {
            this.link.setToolTipText(I18n.tr("Link to a OSM data file on your local disk.", new Object[0]));
            this.include.setToolTipText(I18n.tr("Include OSM data in the .joz session file.", new Object[0]));
        } else if (this.layer instanceof GpxLayer) {
            this.link.setToolTipText(I18n.tr("Link to a GPX data file on your local disk.", new Object[0]));
            this.include.setToolTipText(I18n.tr("Include GPX data in the .joz session file.", new Object[0]));
        }
        this.include.putClientProperty("actionname", "include");
        ButtonGroup group = new ButtonGroup();
        group.add(this.link);
        group.add(this.include);
        JPanel cardLink = new JPanel(new GridBagLayout());
        File file = this.layer.getAssociatedFile();
        boolean modifiable = this.layer instanceof AbstractModifiableLayer;
        LayerSaveAction saveAction = modifiable ? new LayerSaveAction() : null;
        JButton jButton = save = modifiable ? new JButton(saveAction) : null;
        if (file != null && file.exists()) {
            JosmTextField tf = new JosmTextField();
            tf.setText(file.getPath());
            tf.setEditable(false);
            cardLink.add((Component)tf, GBC.std());
            if (save != null) {
                save.setMargin(new Insets(0, 0, 0, 0));
                cardLink.add((Component)save, GBC.eol().insets(2, 0, 0, 0));
            }
        } else {
            cardLink.add((Component)new JLabel(I18n.tr("No file association", new Object[0])), GBC.eol());
        }
        JPanel cardInclude = new JPanel(new GridBagLayout());
        JLabel lblIncl = new JLabel(this.layer instanceof GpxLayer ? I18n.tr("GPX data will be included in the session file.", new Object[0]) : I18n.tr("OSM data will be included in the session file.", new Object[0]));
        lblIncl.setFont(lblIncl.getFont().deriveFont(0));
        cardInclude.add((Component)lblIncl, GBC.eol().fill(2));
        CardLayout cl = new CardLayout();
        JPanel cards = new JPanel(cl);
        cards.add((Component)cardLink, "link");
        cards.add((Component)cardInclude, "include");
        if (file != null && file.exists()) {
            this.link.setSelected(true);
        } else {
            this.link.setEnabled(false);
            this.link.setToolTipText(I18n.tr("No file association", new Object[0]));
            this.include.setSelected(true);
            cl.show(cards, "include");
        }
        this.link.addActionListener(e -> cl.show(cards, "link"));
        this.include.addActionListener(e -> cl.show(cards, "include"));
        topRow.add((Component)this.export, GBC.std());
        topRow.add((Component)lbl, GBC.std());
        topRow.add(GBC.glue(1, 0), GBC.std().fill(2));
        p.add((Component)topRow, GBC.eol().fill(2));
        p.add((Component)lblData, GBC.std().insets(10, 0, 0, 0));
        p.add((Component)this.link, GBC.std());
        p.add((Component)this.include, GBC.eol());
        p.add((Component)cards, GBC.eol().insets(15, 0, 3, 3));
        this.export.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                GuiHelper.setEnabledRec(p, false);
                this.export.setEnabled(true);
            } else {
                GuiHelper.setEnabledRec(p, true);
                if (save != null && saveAction != null) {
                    save.setEnabled(saveAction.isEnabled());
                }
                this.link.setEnabled(file != null && file.exists());
            }
        });
        return p;
    }

    @Override
    public Element export(SessionWriter.ExportSupport support) throws IOException {
        Element layerEl = support.createElement("layer");
        layerEl.setAttribute("type", this.type);
        layerEl.setAttribute("version", this.version);
        Element file = support.createElement("file");
        layerEl.appendChild(file);
        if (this.requiresZip()) {
            String zipPath = "layers/" + String.format("%02d", support.getLayerIndex()) + "/data." + this.extension;
            file.appendChild(support.createTextNode(zipPath));
            this.addDataFile(support.getOutputStreamZip(zipPath));
            this.layer.setAssociatedFile(null);
            if (this.layer instanceof AbstractModifiableLayer) {
                ((AbstractModifiableLayer)this.layer).onPostSaveToFile();
            }
        } else {
            try {
                File f = this.layer.getAssociatedFile();
                if (f != null) {
                    file.appendChild(support.createTextNode(f.toURI().toURL().toString()));
                }
            }
            catch (MalformedURLException e) {
                throw new IOException(e);
            }
        }
        return layerEl;
    }

    @Override
    public boolean requiresZip() {
        return this.include.isSelected();
    }

    protected abstract void addDataFile(OutputStream var1) throws IOException;

    private class LayerSaveAction
    extends AbstractAction {
        LayerSaveAction() {
            new ImageProvider("save").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", ((SaveToFile)((Object)GenericSessionExporter.this.layer)).requiresSaveToFile() ? I18n.tr("Layer contains unsaved data - save to file.", new Object[0]) : I18n.tr("Layer does not contain unsaved data.", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SaveAction.getInstance().doSave(GenericSessionExporter.this.layer, true);
            this.updateEnabledState();
        }

        public final void updateEnabledState() {
            this.setEnabled(((SaveToFile)((Object)GenericSessionExporter.this.layer)).requiresSaveToFile());
        }
    }
}

