/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.JosmTemplatedTMSTileSource;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.InvalidMapboxVectorTileException;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.style.MapboxVectorStyle;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.style.Source;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class MapboxVectorTileSource
extends JosmTemplatedTMSTileSource {
    private final MapboxVectorStyle styleSource;

    public MapboxVectorTileSource(ImageryInfo info) {
        super(info);
        MapboxVectorStyle mapBoxVectorStyle = null;
        try (CachedFile style = new CachedFile(info.getUrl());
             InputStream inputStream = style.getInputStream();
             JsonReader reader = Json.createReader(inputStream);){
            JsonObject object = reader.readObject();
            if (object.containsKey("version") && object.containsKey("layers") && object.containsKey("sources")) {
                mapBoxVectorStyle = MapboxVectorStyle.getMapboxVectorStyle(info.getUrl());
            }
        }
        catch (IOException | InvalidPathException | JsonException e) {
            Logging.trace(e);
        }
        this.styleSource = mapBoxVectorStyle;
        if (this.styleSource != null) {
            Source source;
            List sources = this.styleSource.getSources().keySet().stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (sources.size() == 1) {
                source = (Source)sources.get(0);
            } else if (!sources.isEmpty()) {
                source = GuiHelper.runInEDTAndWaitAndReturn(() -> {
                    ExtendedDialog dialog = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Select Vector Tile Layers", new Object[0]), I18n.tr("Add layers", new Object[0]));
                    JosmComboBox<Source> comboBox = new JosmComboBox<Source>(sources.toArray(new Source[0]));
                    comboBox.setSelectedIndex(0);
                    dialog.setContent(comboBox);
                    dialog.showDialog();
                    return (Source)comboBox.getSelectedItem();
                });
            } else {
                throw new InvalidMapboxVectorTileException(I18n.tr("Cannot understand style source: {0}", info.getUrl()));
            }
            if (source != null) {
                this.name = this.name + ": " + source.getName();
                this.baseUrl = source.getUrls().get(0);
                this.minZoom = source.getMinZoom();
                this.maxZoom = source.getMaxZoom();
                if (source.getAttributionText() != null) {
                    this.setAttributionText(source.getAttributionText());
                }
            }
        }
    }

    public MapboxVectorStyle getStyleSource() {
        return this.styleSource;
    }
}

