/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Objects;
import org.openstreetmap.josm.data.IBounds;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class Bounds
implements IBounds {
    private double minLat;
    private double minLon;
    private double maxLat;
    private double maxLon;

    @Override
    public LatLon getMin() {
        return new LatLon(this.minLat, this.minLon);
    }

    @Override
    public double getMinLat() {
        return this.minLat;
    }

    @Override
    public double getMinLon() {
        return this.minLon;
    }

    @Override
    public LatLon getMax() {
        return new LatLon(this.maxLat, this.maxLon);
    }

    @Override
    public double getMaxLat() {
        return this.maxLat;
    }

    @Override
    public double getMaxLon() {
        return this.maxLon;
    }

    public Bounds(LatLon min, LatLon max) {
        this(min.lat(), min.lon(), max.lat(), max.lon());
    }

    public Bounds(LatLon min, LatLon max, boolean roundToOsmPrecision) {
        this(min.lat(), min.lon(), max.lat(), max.lon(), roundToOsmPrecision);
    }

    public Bounds(LatLon b) {
        this(b, true);
    }

    public Bounds(LatLon b, boolean roundToOsmPrecision) {
        this(b.lat(), b.lon(), roundToOsmPrecision);
    }

    public Bounds(double lat, double lon, boolean roundToOsmPrecision) {
        if (roundToOsmPrecision) {
            this.minLat = LatLon.roundToOsmPrecision(lat);
            this.minLon = LatLon.roundToOsmPrecision(lon);
        } else {
            this.minLat = lat;
            this.minLon = lon;
        }
        this.maxLat = this.minLat;
        this.maxLon = this.minLon;
    }

    public Bounds(double minLat, double minLon, double maxLat, double maxLon) {
        this(minLat, minLon, maxLat, maxLon, true);
    }

    public Bounds(double minLat, double minLon, double maxLat, double maxLon, boolean roundToOsmPrecision) {
        if (roundToOsmPrecision) {
            this.minLat = LatLon.roundToOsmPrecision(minLat);
            this.minLon = LatLon.roundToOsmPrecision(minLon);
            this.maxLat = LatLon.roundToOsmPrecision(maxLat);
            this.maxLon = LatLon.roundToOsmPrecision(maxLon);
        } else {
            this.minLat = minLat;
            this.minLon = minLon;
            this.maxLat = maxLat;
            this.maxLon = maxLon;
        }
    }

    public Bounds(double ... coords) {
        this(coords, true);
    }

    public Bounds(double[] coords, boolean roundToOsmPrecision) {
        CheckParameterUtil.ensureParameterNotNull(coords, "coords");
        if (coords.length != 4) {
            throw new IllegalArgumentException(MessageFormat.format("Expected array of length 4, got {0}", coords.length));
        }
        if (roundToOsmPrecision) {
            this.minLat = LatLon.roundToOsmPrecision(coords[0]);
            this.minLon = LatLon.roundToOsmPrecision(coords[1]);
            this.maxLat = LatLon.roundToOsmPrecision(coords[2]);
            this.maxLon = LatLon.roundToOsmPrecision(coords[3]);
        } else {
            this.minLat = coords[0];
            this.minLon = coords[1];
            this.maxLat = coords[2];
            this.maxLon = coords[3];
        }
    }

    public Bounds(String asString, String separator) {
        this(asString, separator, ParseMethod.MINLAT_MINLON_MAXLAT_MAXLON);
    }

    public Bounds(String asString, String separator, ParseMethod parseMethod) {
        this(asString, separator, parseMethod, true);
    }

    public Bounds(String asString, String separator, ParseMethod parseMethod, boolean roundToOsmPrecision) {
        CheckParameterUtil.ensureParameterNotNull(asString, "asString");
        String[] components = asString.split(separator, -1);
        if (components.length != 4) {
            throw new IllegalArgumentException(MessageFormat.format("Exactly four doubles expected in string, got {0}: {1}", components.length, asString));
        }
        double[] values = new double[4];
        for (int i = 0; i < 4; ++i) {
            try {
                values[i] = Double.parseDouble(components[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageFormat.format("Illegal double value ''{0}''", components[i]), e);
            }
        }
        switch (parseMethod) {
            case LEFT_BOTTOM_RIGHT_TOP: {
                this.minLat = Bounds.initLat(values[1], roundToOsmPrecision);
                this.minLon = Bounds.initLon(values[0], roundToOsmPrecision);
                this.maxLat = Bounds.initLat(values[3], roundToOsmPrecision);
                this.maxLon = Bounds.initLon(values[2], roundToOsmPrecision);
                break;
            }
            default: {
                this.minLat = Bounds.initLat(values[0], roundToOsmPrecision);
                this.minLon = Bounds.initLon(values[1], roundToOsmPrecision);
                this.maxLat = Bounds.initLat(values[2], roundToOsmPrecision);
                this.maxLon = Bounds.initLon(values[3], roundToOsmPrecision);
            }
        }
    }

    protected static double initLat(double value, boolean roundToOsmPrecision) {
        if (!LatLon.isValidLat(value)) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value ''{0}''", value));
        }
        return roundToOsmPrecision ? LatLon.roundToOsmPrecision(value) : value;
    }

    protected static double initLon(double value, boolean roundToOsmPrecision) {
        if (!LatLon.isValidLon(value)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value ''{0}''", value));
        }
        return roundToOsmPrecision ? LatLon.roundToOsmPrecision(value) : value;
    }

    public Bounds(Bounds other) {
        this(other.minLat, other.minLon, other.maxLat, other.maxLon);
    }

    public Bounds(Rectangle2D rect) {
        this(rect.getMinY(), rect.getMinX(), rect.getMaxY(), rect.getMaxX());
    }

    public Bounds(LatLon center, double latExtent, double lonExtent) {
        CheckParameterUtil.ensureParameterNotNull(center, "center");
        if (latExtent <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0.0 expected, got {1}", "latExtent", latExtent));
        }
        if (lonExtent <= 0.0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0.0 expected, got {1}", "lonExtent", lonExtent));
        }
        this.minLat = LatLon.roundToOsmPrecision(LatLon.toIntervalLat(center.lat() - latExtent / 2.0));
        this.minLon = LatLon.roundToOsmPrecision(LatLon.toIntervalLon(center.lon() - lonExtent / 2.0));
        this.maxLat = LatLon.roundToOsmPrecision(LatLon.toIntervalLat(center.lat() + latExtent / 2.0));
        this.maxLon = LatLon.roundToOsmPrecision(LatLon.toIntervalLon(center.lon() + lonExtent / 2.0));
    }

    public BBox toBBox() {
        return new BBox(this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    public String toString() {
        return "Bounds[" + this.minLat + ',' + this.minLon + ',' + this.maxLat + ',' + this.maxLon + ']';
    }

    public String toShortString(DecimalFormat format) {
        return format.format(this.minLat) + ' ' + format.format(this.minLon) + " / " + format.format(this.maxLat) + ' ' + format.format(this.maxLon);
    }

    @Override
    public LatLon getCenter() {
        if (this.crosses180thMeridian()) {
            double lat = (this.minLat + this.maxLat) / 2.0;
            double lon = (this.minLon + this.maxLon - 360.0) / 2.0;
            if (lon < -180.0) {
                lon += 360.0;
            }
            return new LatLon(lat, lon);
        }
        return new LatLon((this.minLat + this.maxLat) / 2.0, (this.minLon + this.maxLon) / 2.0);
    }

    public void extend(LatLon ll) {
        this.extend(ll.lat(), ll.lon());
    }

    public void extend(double lat, double lon) {
        if (lat < this.minLat) {
            this.minLat = LatLon.roundToOsmPrecision(lat);
        }
        if (lat > this.maxLat) {
            this.maxLat = LatLon.roundToOsmPrecision(lat);
        }
        if (this.crosses180thMeridian()) {
            if (lon > this.maxLon && lon < this.minLon) {
                if (Math.abs(lon - this.minLon) <= Math.abs(lon - this.maxLon)) {
                    this.minLon = LatLon.roundToOsmPrecision(lon);
                } else {
                    this.maxLon = LatLon.roundToOsmPrecision(lon);
                }
            }
        } else {
            if (lon < this.minLon) {
                this.minLon = LatLon.roundToOsmPrecision(lon);
            }
            if (lon > this.maxLon) {
                this.maxLon = LatLon.roundToOsmPrecision(lon);
            }
        }
    }

    public void extend(Bounds b) {
        this.extend(b.minLat, b.minLon);
        this.extend(b.maxLat, b.maxLon);
    }

    public boolean contains(LatLon ll) {
        return this.contains((ILatLon)ll);
    }

    @Override
    public boolean contains(ILatLon ll) {
        if (!ll.isLatLonKnown()) {
            return false;
        }
        if (ll.lat() < this.minLat || ll.lat() > this.maxLat) {
            return false;
        }
        return !(this.crosses180thMeridian() ? ll.lon() > this.maxLon && ll.lon() < this.minLon : ll.lon() < this.minLon || ll.lon() > this.maxLon);
    }

    private static boolean intersectsLonCrossing(IBounds crossing, IBounds notCrossing) {
        return notCrossing.getMinLon() <= crossing.getMaxLon() || notCrossing.getMaxLon() >= crossing.getMinLon();
    }

    public boolean intersects(Bounds b) {
        return this.intersects((IBounds)b);
    }

    @Override
    public boolean intersects(IBounds b) {
        if (b.getMaxLat() < this.minLat || b.getMinLat() > this.maxLat) {
            return false;
        }
        if (this.crosses180thMeridian() && !b.crosses180thMeridian()) {
            return Bounds.intersectsLonCrossing(this, b);
        }
        if (!this.crosses180thMeridian() && b.crosses180thMeridian()) {
            return Bounds.intersectsLonCrossing(b, this);
        }
        if (this.crosses180thMeridian() && b.crosses180thMeridian()) {
            return true;
        }
        return b.getMaxLon() >= this.minLon && b.getMinLon() <= this.maxLon;
    }

    @Override
    public boolean crosses180thMeridian() {
        return this.minLon > this.maxLon;
    }

    public Rectangle2D.Double asRect() {
        return new Rectangle2D.Double(this.minLon, this.minLat, this.getWidth(), this.getHeight());
    }

    @Override
    public double getHeight() {
        return this.maxLat - this.minLat;
    }

    @Override
    public double getWidth() {
        return this.maxLon - this.minLon + (this.crosses180thMeridian() ? 360.0 : 0.0);
    }

    @Override
    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    public String encodeAsString(String separator) {
        return this.minLat + separator + this.minLon + separator + this.maxLat + separator + this.maxLon;
    }

    public boolean isCollapsed() {
        return Double.doubleToLongBits(this.minLat) == Double.doubleToLongBits(this.maxLat) && Double.doubleToLongBits(this.minLon) == Double.doubleToLongBits(this.maxLon);
    }

    public boolean isOutOfTheWorld() {
        return !LatLon.isValidLat(this.minLat) || !LatLon.isValidLat(this.maxLat) || !LatLon.isValidLon(this.minLon) || !LatLon.isValidLon(this.maxLon);
    }

    public void normalize() {
        this.minLat = LatLon.toIntervalLat(this.minLat);
        this.maxLat = LatLon.toIntervalLat(this.maxLat);
        this.minLon = LatLon.toIntervalLon(this.minLon);
        this.maxLon = LatLon.toIntervalLon(this.maxLon);
    }

    public int hashCode() {
        return Objects.hash(this.minLat, this.minLon, this.maxLat, this.maxLon);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Bounds bounds = (Bounds)obj;
        return Double.compare(bounds.minLat, this.minLat) == 0 && Double.compare(bounds.minLon, this.minLon) == 0 && Double.compare(bounds.maxLat, this.maxLat) == 0 && Double.compare(bounds.maxLon, this.maxLon) == 0;
    }

    public static enum ParseMethod {
        MINLAT_MINLON_MAXLAT_MAXLON,
        LEFT_BOTTOM_RIGHT_TOP;

    }
}

