/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Action;
import org.openstreetmap.josm.actions.SelectByInternalPointAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.PlatformManager;

public class SelectionManager
implements MouseListener,
MouseMotionListener,
PropertyChangeListener {
    private final SelectionEnded selectionEndedListener;
    private Point mousePosStart;
    private Point mousePos;
    private final NavigatableComponent nc;
    private final boolean aspectRatio;
    private boolean lassoMode;
    private final Polygon lasso = new Polygon();
    private Polygon selectionResult = new Polygon();
    private final SelectionHintLayer selectionHintLayer = new SelectionHintLayer();

    public SelectionManager(SelectionEnded selectionEndedListener, boolean aspectRatio, NavigatableComponent navComp) {
        this.selectionEndedListener = selectionEndedListener;
        this.aspectRatio = aspectRatio;
        this.nc = navComp;
    }

    public void register(MapView eventSource, boolean lassoMode) {
        this.lassoMode = lassoMode;
        eventSource.addMouseListener(this);
        eventSource.addMouseMotionListener(this);
        this.selectionEndedListener.addPropertyChangeListener(this);
        eventSource.addPropertyChangeListener("scale", evt -> this.abortSelecting());
        eventSource.addTemporaryLayer(this.selectionHintLayer);
    }

    public void unregister(MapView eventSource) {
        this.abortSelecting();
        eventSource.removeTemporaryLayer(this.selectionHintLayer);
        eventSource.removeMouseListener(this);
        eventSource.removeMouseMotionListener(this);
        this.selectionEndedListener.removePropertyChangeListener(this);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() > 1 && MainApplication.getLayerManager().getActiveDataSet() != null) {
            SelectByInternalPointAction.performSelection(MainApplication.getMap().mapView.getEastNorth(e.getX(), e.getY()), (e.getModifiersEx() & 0x40) != 0, (e.getModifiersEx() & PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()) != 0);
        } else if (e.getButton() == 1) {
            this.mousePosStart = this.mousePos = e.getPoint();
            this.lasso.reset();
            this.lasso.addPoint(this.mousePosStart.x, this.mousePosStart.y);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int buttonPressed = e.getModifiersEx() & 0x1400;
        if (buttonPressed != 0) {
            if (this.mousePosStart == null) {
                this.mousePosStart = this.mousePos = e.getPoint();
            }
            this.selectionAreaChanged();
        }
        if (buttonPressed == 1024) {
            this.mousePos = e.getPoint();
            this.addLassoPoint(e.getPoint());
            this.selectionAreaChanged();
        } else if (buttonPressed == 5120) {
            this.moveSelection(e.getX() - this.mousePos.x, e.getY() - this.mousePos.y);
            this.mousePos = e.getPoint();
            this.selectionAreaChanged();
        }
    }

    private void moveSelection(int dx, int dy) {
        this.mousePosStart.x += dx;
        this.mousePosStart.y += dy;
        this.lasso.translate(dx, dy);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.endSelecting(e);
        }
    }

    public void endSelecting(MouseEvent e) {
        boolean rightMouseStillPressed;
        this.mousePos = e.getPoint();
        if (this.lassoMode) {
            this.addLassoPoint(e.getPoint());
        }
        boolean bl = rightMouseStillPressed = (e.getModifiersEx() & 0x1000) != 0;
        if (!rightMouseStillPressed) {
            this.selectingDone(e);
        }
        this.abortSelecting();
    }

    private void addLassoPoint(Point point) {
        if (this.isNoSelection()) {
            return;
        }
        this.lasso.addPoint(point.x, point.y);
    }

    private boolean isNoSelection() {
        return this.mousePos == null || this.mousePosStart == null || this.mousePos == this.mousePosStart;
    }

    private Rectangle getSelectionRectangle() {
        int x = this.mousePosStart.x;
        int y = this.mousePosStart.y;
        int w = this.mousePos.x - this.mousePosStart.x;
        int h = this.mousePos.y - this.mousePosStart.y;
        if (w < 0) {
            x += w;
            w = -w;
        }
        if (h < 0) {
            y += h;
            h = -h;
        }
        if (this.aspectRatio) {
            double aspectRatio = (double)this.nc.getWidth() / (double)this.nc.getHeight();
            if ((double)w / (double)h < aspectRatio) {
                int neww = (int)((double)h * aspectRatio);
                if (this.mousePos.x < this.mousePosStart.x) {
                    x += w - neww;
                }
                w = neww;
            } else {
                int newh = (int)((double)w / aspectRatio);
                if (this.mousePos.y < this.mousePosStart.y) {
                    y += h - newh;
                }
                h = newh;
            }
        }
        return new Rectangle(x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("active".equals(evt.getPropertyName()) && !((Boolean)evt.getNewValue()).booleanValue()) {
            this.abortSelecting();
        }
    }

    private void selectingDone(MouseEvent e) {
        Rectangle r;
        if (this.isNoSelection()) {
            return;
        }
        if (this.lassoMode) {
            r = this.lasso.getBounds();
            this.selectionResult = new Polygon(this.lasso.xpoints, this.lasso.ypoints, this.lasso.npoints);
        } else {
            r = this.getSelectionRectangle();
            this.selectionResult = SelectionManager.rectToPolygon(r);
        }
        this.selectionEndedListener.selectionEnded(r, e);
    }

    private void abortSelecting() {
        if (this.mousePosStart != null) {
            this.mousePosStart = null;
            this.mousePos = null;
            this.lasso.reset();
            this.selectionAreaChanged();
        }
    }

    private void selectionAreaChanged() {
        this.selectionHintLayer.invalidate();
    }

    public Collection<OsmPrimitive> getSelectedObjects(boolean alt) {
        LinkedList<OsmPrimitive> selection = new LinkedList<OsmPrimitive>();
        boolean clicked = false;
        Rectangle bounding = this.selectionResult.getBounds();
        if (bounding.height <= 2 && bounding.width <= 2) {
            clicked = true;
        }
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (clicked) {
            Point center = new Point(this.selectionResult.xpoints[0], this.selectionResult.ypoints[0]);
            OsmPrimitive osm = this.nc.getNearestNodeOrWay(center, OsmPrimitive::isSelectable, false);
            if (osm != null) {
                selection.add(osm);
            }
        } else if (ds != null) {
            for (Node n2 : ds.getNodes()) {
                if (!n2.isSelectable() || !this.selectionResult.contains(this.nc.getPoint2D(n2))) continue;
                selection.add(n2);
            }
            for (Way w : ds.getWays()) {
                if (!w.isSelectable() || w.isEmpty()) continue;
                if (alt) {
                    if (!w.getNodes().stream().anyMatch(n -> !n.isIncomplete() && this.selectionResult.contains(this.nc.getPoint2D((Node)n)))) continue;
                    selection.add(w);
                    continue;
                }
                boolean allIn = w.getNodes().stream().allMatch(n -> n.isIncomplete() || this.selectionResult.contains(this.nc.getPoint((Node)n)));
                if (!allIn) continue;
                selection.add(w);
            }
        }
        return selection;
    }

    private static Polygon rectToPolygon(Rectangle r) {
        Polygon poly = new Polygon();
        poly.addPoint(r.x, r.y);
        poly.addPoint(r.x, r.y + r.height);
        poly.addPoint(r.x + r.width, r.y + r.height);
        poly.addPoint(r.x + r.width, r.y);
        return poly;
    }

    public void setLassoMode(boolean lassoMode) {
        this.lassoMode = lassoMode;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private class SelectionHintLayer
    extends AbstractMapViewPaintable {
        private SelectionHintLayer() {
        }

        @Override
        public void paint(Graphics2D g, MapView mv, Bounds bbox) {
            if (SelectionManager.this.mousePos == null || SelectionManager.this.mousePosStart == null || SelectionManager.this.mousePos == SelectionManager.this.mousePosStart) {
                return;
            }
            Color color = ColorHelper.complement(PaintColors.getBackgroundColor());
            g.setColor(color);
            if (SelectionManager.this.lassoMode) {
                g.drawPolygon(SelectionManager.this.lasso);
                g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() / 8));
                g.fillPolygon(SelectionManager.this.lasso);
            } else {
                Rectangle paintRect = SelectionManager.this.getSelectionRectangle();
                g.drawRect(paintRect.x, paintRect.y, paintRect.width, paintRect.height);
            }
        }
    }

    public static interface SelectionEnded
    extends Action {
        public void selectionEnded(Rectangle var1, MouseEvent var2);
    }
}

