/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.openstreetmap.josm.actions.RestorePropertyAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.dialogs.properties.CopyAllKeyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.CopyKeyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.CopyValueAction;
import org.openstreetmap.josm.gui.dialogs.properties.HelpTagAction;
import org.openstreetmap.josm.gui.dialogs.properties.TaginfoAction;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryViewerPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.TagInfoTransferHandler;
import org.openstreetmap.josm.gui.history.TagTableColumnModel;
import org.openstreetmap.josm.gui.history.TagTableModel;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;

public class TagInfoViewer
extends HistoryViewerPanel {
    public TagInfoViewer(HistoryBrowserModel model) {
        super(model);
    }

    @Override
    protected JTable buildReferenceTable() {
        return this.buildTable(PointInTimeType.REFERENCE_POINT_IN_TIME);
    }

    @Override
    protected JTable buildCurrentTable() {
        return this.buildTable(PointInTimeType.CURRENT_POINT_IN_TIME);
    }

    private JTable buildTable(PointInTimeType pointInTime) {
        TagTableModel tagTableModel = this.model.getTagTableModel(pointInTime);
        JTable table = new JTable(tagTableModel, new TagTableColumnModel());
        TableHelper.setFont(table, this.getClass());
        table.setSelectionMode(2);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.getTableHeader().setReorderingAllowed(false);
        table.setTransferHandler(new TagInfoTransferHandler());
        table.addFocusListener(new RepaintOnFocusChange());
        JPopupMenu tagMenu = new JPopupMenu();
        IntFunction<String> tagKeyFn = x -> (String)table.getValueAt(x, 0);
        IntFunction<String> tagValueFn = x -> tagTableModel.getValue((String)tagKeyFn.apply(x));
        IntFunction<Map<String, Integer>> tagValuesFn = x -> {
            String value = (String)tagValueFn.apply(x);
            return value != null ? Collections.singletonMap(value, 1) : Collections.emptyMap();
        };
        Supplier<Collection<? extends Tagged>> objectSp = () -> Collections.singletonList(this.model.getPointInTime(pointInTime));
        Supplier<OsmPrimitive> primitiveSupplier = () -> this.getPrimitiveFromDataSet(pointInTime);
        tagMenu.add(this.trackJosmAction(new CopyValueAction(table, tagKeyFn, objectSp)));
        CopyKeyValueAction copyKeyValueAction = new CopyKeyValueAction(table, tagKeyFn, objectSp);
        tagMenu.add(this.trackJosmAction(copyKeyValueAction));
        tagMenu.addPopupMenuListener(copyKeyValueAction);
        tagMenu.add(this.trackJosmAction(new CopyAllKeyValueAction(table, tagKeyFn, objectSp)));
        tagMenu.add(new RestorePropertyAction(tagKeyFn, tagValueFn, primitiveSupplier, table.getSelectionModel()));
        tagMenu.addSeparator();
        tagMenu.add(this.trackJosmAction(new HelpTagAction(table, tagKeyFn, tagValuesFn)));
        TaginfoAction taginfoAction = new TaginfoAction(table, tagKeyFn, tagValuesFn, null, null);
        tagMenu.add(this.trackJosmAction(taginfoAction.toTagHistoryAction()));
        tagMenu.add(this.trackJosmAction(taginfoAction));
        table.addMouseListener(new PopupMenuLauncher(tagMenu));
        return table;
    }

    private static final class RepaintOnFocusChange
    implements FocusListener {
        private RepaintOnFocusChange() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            RepaintOnFocusChange.repaintSelected(e);
        }

        @Override
        public void focusGained(FocusEvent e) {
            RepaintOnFocusChange.repaintSelected(e);
        }

        private static void repaintSelected(FocusEvent e) {
            e.getComponent().repaint();
        }
    }
}

