/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.jcs3.access.CacheAccess;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.ImageCache;
import org.openstreetmap.josm.data.osm.visitor.paint.MapRendererFactory;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.data.osm.visitor.paint.TileZXY;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class StyledTiledMapRenderer
extends StyledMapRenderer {
    private static final int BUFFER_TILES = 2;
    private static final int BUFFER_PIXELS = 16;
    private CacheAccess<TileZXY, ImageCache> cache;
    private int zoom;
    private Consumer<TileZXY> notifier;

    public StyledTiledMapRenderer(Graphics2D g, NavigatableComponent nc, boolean isInactiveMode) {
        super(g, nc, isInactiveMode);
    }

    @Override
    public void render(OsmData<?, ?, ?, ?> data, boolean renderVirtualNodes, Bounds bounds) {
        double percentDrawn;
        int tileSize;
        if (this.cache == null) {
            super.render(data, renderVirtualNodes, bounds);
            return;
        }
        ExecutorService worker = MainApplication.worker;
        BufferedImage tempImage = this.nc.getGraphicsConfiguration().createCompatibleImage(this.nc.getWidth(), this.nc.getHeight(), 3);
        Graphics2D tempG2d = tempImage.createGraphics();
        tempG2d.setComposite(AlphaComposite.DstAtop);
        List toRender = TileZXY.boundsToTiles(bounds.getMinLat(), bounds.getMinLon(), bounds.getMaxLat(), bounds.getMaxLon(), this.zoom).collect(Collectors.toList());
        Bounds box = new Bounds(bounds);
        toRender.stream().map(TileZXY::tileToBounds).forEach(box::extend);
        if (toRender.isEmpty()) {
            tileSize = Config.getPref().getInt("mappaint.fast_render.tile_size", 256);
        } else {
            TileZXY tile2 = (TileZXY)toRender.get(0);
            Bounds box2 = TileZXY.tileToBounds(tile2);
            Point min = this.nc.getPoint(box2.getMin());
            Point max = this.nc.getPoint(box2.getMax());
            tileSize = max.x - min.x + 16;
        }
        if (this.nc instanceof MapView) {
            MapView mv = (MapView)this.nc;
            MouseEvent mouseEvent = mv.lastMEvent;
            LatLon mousePosition = this.nc.getLatLon(mouseEvent.getX(), mouseEvent.getY());
            TileZXY mouseTile = TileZXY.latLonToTile(mousePosition.lat(), mousePosition.lon(), this.zoom);
            toRender.sort(Comparator.comparingInt(tile -> {
                int x = tile.x() - mouseTile.x();
                int y = tile.y() - mouseTile.y();
                return x * x + y * y;
            }));
        }
        int submittedTile = 5;
        int painted = 0;
        for (TileZXY tile3 : toRender) {
            Image tileImage;
            boolean wasDirty;
            ImageCache tImg = this.cache.get(tile3);
            boolean bl = wasDirty = tImg != null && tImg.isDirty();
            if (tImg != null && !tImg.isDirty() && tImg.imageFuture() != null) {
                submittedTile = 0;
            }
            if (submittedTile > 0 && (tImg == null || tImg.isDirty())) {
                if (tImg != null && tImg.imageFuture() != null) {
                    tImg.imageFuture().cancel();
                }
                --submittedTile;
                TileLoader loader = new TileLoader(data, tile3, tileSize, new ArrayList<TileLoader>());
                worker.execute(loader);
                if (tImg == null) {
                    this.cache.put(tile3, new ImageCache(null, loader, false));
                } else {
                    this.cache.put(tile3, new ImageCache(tImg.image(), loader, true));
                }
                tileImage = tImg != null ? tImg.image() : null;
            } else {
                tileImage = tImg != null ? tImg.image() : null;
            }
            Point point = this.nc.getPoint(tile3);
            if (tileImage != null) {
                if (wasDirty && Logging.isTraceEnabled() || this.isInactiveMode) {
                    tempG2d.setColor(Color.DARK_GRAY);
                    tempG2d.fillRect(point.x, point.y, tileSize, tileSize);
                } else {
                    ++painted;
                }
                tempG2d.drawImage(tileImage, point.x + 1, point.y + 1, null, null);
                continue;
            }
            Logging.trace("StyledMapRenderer did not paint tile {1}", tile3);
        }
        if (submittedTile <= 0) {
            worker.execute(this.nc::invalidate);
        }
        if ((percentDrawn = (double)(100 * painted) / (double)toRender.size()) < 99.99) {
            boolean x = false;
            int y = this.nc.getHeight() / 8;
            String message = I18n.tr("Rendering Status: {0}%", Math.floor(percentDrawn));
            tempG2d.setComposite(AlphaComposite.SrcOver);
            tempG2d.setFont(new Font("sansserif", 1, 13));
            tempG2d.setColor(Color.BLACK);
            tempG2d.drawString(message, 1, y);
            tempG2d.setColor(Color.LIGHT_GRAY);
            tempG2d.drawString(message, 0, y);
        }
        tempG2d.dispose();
        this.g.drawImage((Image)tempImage, 0, 0, null);
    }

    public void setCache(Bounds box, CacheAccess<TileZXY, ImageCache> cache, int zoom, Consumer<TileZXY> notifier) {
        this.cache = cache;
        this.zoom = zoom;
        this.notifier = notifier != null ? notifier : tile -> {};
        Set tiles = TileZXY.boundsToTiles(box.getMinLat(), box.getMinLon(), box.getMaxLat(), box.getMaxLon(), zoom).collect(Collectors.toSet());
        cache.getMatching(".*").forEach((key, value) -> {
            if (!tiles.contains(key)) {
                StyledTiledMapRenderer.cancelImageFuture(cache, key, value);
            }
        });
    }

    private static void cancelImageFuture(CacheAccess<TileZXY, ImageCache> cache, TileZXY key, ImageCache value) {
        if (value.imageFuture() != null) {
            value.imageFuture().cancel();
            if (value.image() == null) {
                cache.remove(key);
            } else {
                cache.put(key, new ImageCache(value.image(), null, value.isDirty()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage generateTiles(OsmData<?, ?, ?, ?> data, Collection<TileZXY> tiles, int tileSize) {
        if (tiles.isEmpty()) {
            throw new IllegalArgumentException("tiles cannot be empty");
        }
        IntSummaryStatistics xStats = tiles.stream().mapToInt(TileZXY::x).distinct().summaryStatistics();
        IntSummaryStatistics yStats = tiles.stream().mapToInt(TileZXY::y).distinct().summaryStatistics();
        int xCount = xStats.getMax() - xStats.getMin() + 1;
        int yCount = yStats.getMax() - yStats.getMin() + 1;
        final int width = tileSize * (4 + xCount);
        final int height = tileSize * (4 + yCount);
        NavigatableComponent temporaryView = new NavigatableComponent(){

            @Override
            public int getWidth() {
                return width;
            }

            @Override
            public int getHeight() {
                return height;
            }
        };
        Bounds bounds = StyledTiledMapRenderer.generateRenderArea(tiles);
        temporaryView.zoomTo(bounds.getCenter().getEastNorth(ProjectionRegistry.getProjection()), this.mapState.getScale());
        BufferedImage bufferedImage = Optional.ofNullable(this.nc.getGraphicsConfiguration()).map(gc -> gc.createCompatibleImage(tileSize * xCount + xCount, tileSize * yCount + yCount, 3)).orElseGet(() -> new BufferedImage(tileSize * xCount + xCount, tileSize * yCount + yCount, 2));
        Graphics2D g2d = bufferedImage.createGraphics();
        try {
            g2d.setRenderingHints(Map.of(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2d.setTransform(AffineTransform.getTranslateInstance(-2.0 * (double)tileSize, -2.0 * (double)tileSize));
            AbstractMapRenderer tilePainter = MapRendererFactory.getInstance().createActiveRenderer(g2d, temporaryView, false);
            tilePainter.render(data, true, bounds);
        }
        finally {
            g2d.dispose();
        }
        return bufferedImage;
    }

    private static Bounds generateRenderArea(Collection<TileZXY> tiles) {
        Bounds bounds = null;
        for (TileZXY tile : tiles) {
            if (bounds == null) {
                bounds = TileZXY.tileToBounds(tile);
            }
            bounds.extend(TileZXY.tileToBounds(new TileZXY(tile.zoom(), tile.x() - 2, tile.y() - 2)));
            bounds.extend(TileZXY.tileToBounds(new TileZXY(tile.zoom(), tile.x() + 2, tile.y() + 2)));
        }
        return Objects.requireNonNull(bounds);
    }

    class TileLoader
    implements Runnable {
        private final TileZXY tile;
        private final int tileSize;
        private final OsmData<?, ?, ?, ?> data;
        private boolean cancel;
        private final Collection<TileLoader> tileCollection;
        private boolean done;

        TileLoader(OsmData<?, ?, ?, ?> data, TileZXY tile, int tileSize, Collection<TileLoader> tileCollection) {
            this.data = data;
            this.tile = tile;
            this.tileSize = tileSize;
            this.tileCollection = tileCollection;
            this.tileCollection.add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.cancel) {
                Collection<TileLoader> collection = this.tileCollection;
                synchronized (collection) {
                    if (!this.done) {
                        BufferedImage tImage = StyledTiledMapRenderer.this.generateTiles(this.data, this.tileCollection.stream().map(t -> t.tile).collect(Collectors.toList()), this.tileSize);
                        int minX = this.tileCollection.stream().map(t -> t.tile).mapToInt(TileZXY::x).min().orElse(this.tile.x());
                        int minY = this.tileCollection.stream().map(t -> t.tile).mapToInt(TileZXY::y).min().orElse(this.tile.y());
                        for (TileLoader loader : this.tileCollection) {
                            TileZXY txy = loader.tile;
                            int x = (txy.x() - minX) * (this.tileSize - 16) + 8;
                            int y = (txy.y() - minY) * (this.tileSize - 16) + 8;
                            int wh = this.tileSize - 8;
                            BufferedImage tileImage = tImage.getSubimage(x, y, wh, wh);
                            loader.cacheTile(tileImage);
                        }
                    }
                }
            }
        }

        private void cacheTile(BufferedImage tImage) {
            StyledTiledMapRenderer.this.cache.put(this.tile, new ImageCache(tImage, null, false));
            this.done = true;
            StyledTiledMapRenderer.this.notifier.accept(this.tile);
        }

        void cancel() {
            this.cancel = true;
        }
    }
}

