/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.RotateCommand;
import org.openstreetmap.josm.command.ScaleCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.AbstractMapRenderer;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierExListener;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SelectAction
extends MapMode
implements ModifierExListener,
KeyPressReleaseListener,
SelectionManager.SelectionEnded {
    private static final String NORMAL = "normal";
    private static final CachingProperty<Boolean> MERGE_BY_DEFAULT = new BooleanProperty("edit.move.merge-by-default", false).cached();
    private boolean lassoMode;
    private boolean repeatedKeySwitchLassoOption;
    private MouseEvent oldEvent;
    private Mode mode;
    private final transient SelectionManager selectionManager;
    private boolean cancelDrawMode;
    private boolean drawTargetHighlight;
    private boolean didMouseDrag;
    private final MapView mv;
    private Point startingDraggingPos;
    private EastNorth startEN;
    private Point lastMousePos;
    private long mouseDownTime;
    private int mouseDownButton;
    private long mouseReleaseTime;
    private int initialMoveDelay;
    private int initialMoveThreshold;
    private boolean initialMoveThresholdExceeded;
    private transient OsmPrimitive currentHighlight;
    private final transient CycleManager cycleManager = new CycleManager();
    private final transient VirtualManager virtualManager = new VirtualManager();

    public SelectAction(MapFrame mapFrame) {
        super(I18n.tr("Select mode", new Object[0]), "move/move", I18n.tr("Select, move, scale and rotate objects", new Object[0]), Shortcut.registerShortcut("mapmode:select", I18n.tr("Mode: {0}", I18n.tr("Select mode", new Object[0])), 83, 5003), ImageProvider.getCursor(NORMAL, "selection"));
        this.mv = mapFrame.mapView;
        this.setHelpId(HelpUtil.ht("/Action/Select"));
        this.selectionManager = new SelectionManager(this, false, this.mv);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(Config.getPref().getInt("mappaint.node.virtual-size", 8) != 0);
        this.drawTargetHighlight = Config.getPref().getBoolean("draw.target-highlight", true);
        this.initialMoveDelay = Config.getPref().getInt("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Config.getPref().getInt("edit.initial-move-threshold", 5);
        this.repeatedKeySwitchLassoOption = Config.getPref().getBoolean("mappaint.select.toggle-lasso-on-repeated-S", true);
        this.cycleManager.init();
        this.virtualManager.init();
        MapFrame map = MainApplication.getMap();
        map.keyDetector.addModifierExListener(this);
        map.keyDetector.addKeyListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.cycleManager.cycleStart = null;
        this.cycleManager.cycleList = SelectAction.asColl(null);
        this.selectionManager.unregister(this.mv);
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(false);
        MapFrame map = MainApplication.getMap();
        map.keyDetector.removeModifierExListener(this);
        map.keyDetector.removeKeyListener(this);
        this.removeHighlighting();
        this.virtualManager.clear();
    }

    @Override
    public void modifiersExChanged(int modifiers) {
        if (!MainApplication.isDisplayingMapView() || this.oldEvent == null) {
            return;
        }
        if (this.giveUserFeedback(this.oldEvent, modifiers)) {
            this.mv.repaint();
        }
    }

    private boolean giveUserFeedback(MouseEvent e) {
        return this.giveUserFeedback(e, e.getModifiersEx());
    }

    private boolean giveUserFeedback(MouseEvent e, int modifiers) {
        Optional<OsmPrimitive> c = Optional.ofNullable(this.mv.getNearestNodeOrWay(e.getPoint(), this.mv.isSelectablePredicate, true));
        this.updateKeyModifiersEx(modifiers);
        this.determineMapMode(c.isPresent());
        this.virtualManager.clear();
        if (this.mode == Mode.MOVE && !this.dragInProgress() && this.virtualManager.activateVirtualNodeNearPoint(e.getPoint())) {
            DataSet ds = this.getLayerManager().getActiveDataSet();
            if (ds != null && this.drawTargetHighlight) {
                ds.setHighlightedVirtualNodes(this.virtualManager.virtualWays);
            }
            this.mv.setNewCursor(SelectActionCursor.virtual_node.cursor(), (Object)this);
            return this.repaintIfRequired(null);
        }
        this.mv.setNewCursor(this.getCursor(c.orElse(null)), (Object)this);
        if (!this.drawTargetHighlight || this.mode != Mode.MOVE && this.mode != Mode.SELECT || !c.isPresent()) {
            return this.repaintIfRequired(null);
        }
        boolean isToggleMode = this.platformMenuShortcutKeyMask && !this.dragInProgress();
        OsmPrimitive newHighlight = null;
        if (isToggleMode || !c.get().isSelected()) {
            newHighlight = c.get();
        }
        return this.repaintIfRequired(newHighlight);
    }

    private Cursor getCursor(OsmPrimitive nearbyStuff) {
        Object c = "rect";
        switch (this.mode.ordinal()) {
            case 0: {
                if (this.virtualManager.hasVirtualNode()) {
                    c = "virtual_node";
                    break;
                }
                OsmPrimitive osm = nearbyStuff;
                if (this.dragInProgress()) {
                    if (!this.isMergeRequested() || this.getLayerManager().getEditDataSet().getSelectedNodes().isEmpty()) {
                        c = "move";
                        break;
                    }
                    boolean hasTarget = osm instanceof Node && !osm.isSelected();
                    c = hasTarget ? "merge_to_node" : "merge";
                    break;
                }
                c = osm instanceof Node ? "node" : c;
                Object object = c = osm instanceof Way ? "way" : c;
                if (this.shift) {
                    c = (String)c + "_add";
                    break;
                }
                if (!this.platformMenuShortcutKeyMask) break;
                c = (String)c + (osm == null || osm.isSelected() ? "_rm" : "_add");
                break;
            }
            case 1: {
                c = "rotate";
                break;
            }
            case 2: {
                c = "scale";
                break;
            }
            case 3: {
                c = this.lassoMode ? "lasso" : (this.shift ? "rect_add" : (this.platformMenuShortcutKeyMask ? "rect_rm" : "rect"));
            }
        }
        return SelectActionCursor.valueOf((String)c).cursor();
    }

    private boolean removeHighlighting() {
        boolean needsRepaint = false;
        OsmData<?, ?, ?, ?> ds = this.getLayerManager().getActiveData();
        if (ds != null && !ds.getHighlightedVirtualNodes().isEmpty()) {
            needsRepaint = true;
            ds.clearHighlightedVirtualNodes();
        }
        if (this.currentHighlight == null) {
            return needsRepaint;
        }
        this.currentHighlight.setHighlighted(false);
        this.currentHighlight = null;
        return true;
    }

    private boolean repaintIfRequired(OsmPrimitive newHighlight) {
        if (!this.drawTargetHighlight || Objects.equals(this.currentHighlight, newHighlight)) {
            return false;
        }
        if (this.currentHighlight != null) {
            this.currentHighlight.setHighlighted(false);
        }
        if (newHighlight != null) {
            newHighlight.setHighlighted(true);
        }
        this.currentHighlight = newHighlight;
        return true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDownButton = e.getButton();
        if (!this.mv.isActiveLayerVisible() || Boolean.FALSE.equals(this.getValue("active")) || this.mouseDownButton != 1) {
            return;
        }
        this.mv.requestFocus();
        this.updateKeyModifiers(e);
        this.cancelDrawMode = this.shift || this.platformMenuShortcutKeyMask;
        this.didMouseDrag = false;
        this.initialMoveThresholdExceeded = false;
        this.mouseDownTime = System.currentTimeMillis();
        this.lastMousePos = e.getPoint();
        this.startEN = this.mv.getEastNorth(this.lastMousePos.x, this.lastMousePos.y);
        OsmPrimitive nearestPrimitive = this.mv.getNearestNodeOrWay(e.getPoint(), this.mv.isSelectablePredicate, true);
        this.determineMapMode(nearestPrimitive != null);
        switch (this.mode.ordinal()) {
            case 1: 
            case 2: {
                DataSet ds = this.getLayerManager().getEditDataSet();
                if (!ds.selectionEmpty()) break;
                ds.setSelected(SelectAction.asColl(nearestPrimitive));
                break;
            }
            case 0: {
                if (!this.cancelDrawMode && nearestPrimitive instanceof Way) {
                    this.virtualManager.activateVirtualNodeNearPoint(e.getPoint());
                }
                OsmPrimitive toSelect = this.cycleManager.cycleSetup(nearestPrimitive, e.getPoint());
                this.selectPrims(SelectAction.asColl(toSelect), false, false);
                this.useLastMoveCommandIfPossible();
                GuiHelper.scheduleTimer(this.initialMoveDelay + 1, evt -> this.updateStatusLine(), false);
                break;
            }
            case 3: {
                if (this.ctrl && PlatformManager.isPlatformOsx()) break;
                this.selectionManager.register(this.mv, this.lassoMode);
                this.selectionManager.mousePressed(e);
            }
        }
        if (this.giveUserFeedback(e)) {
            this.mv.repaint();
        }
        this.updateStatusLine();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.oldEvent = e;
        if (this.giveUserFeedback(e)) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        if (this.mouseDownButton == 1 && this.mouseReleaseTime > this.mouseDownTime) {
            return;
        }
        this.updateKeyModifiers(e);
        this.cancelDrawMode = true;
        if (this.mode == Mode.SELECT) {
            if (this.ctrl && PlatformManager.isPlatformOsx()) {
                this.selectionManager.unregister(this.mv);
                this.mv.setNewCursor(13, (Object)this);
            }
            return;
        }
        if (this.mode == Mode.MOVE && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.ROTATE && this.mode != Mode.SCALE && (e.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.MOVE) {
            boolean canMerge = this.isMergeRequested() && !this.getLayerManager().getEditDataSet().getSelectedNodes().isEmpty();
            Node p = canMerge ? this.findNodeToMergeTo(e.getPoint()) : null;
            boolean needsRepaint = this.removeHighlighting();
            if (p != null) {
                p.setHighlighted(true);
                this.currentHighlight = p;
                needsRepaint = true;
            }
            this.mv.setNewCursor(this.getCursor(p), (Object)this);
            this.oldEvent = e;
            if (needsRepaint) {
                this.mv.repaint();
            }
        }
        if (this.startingDraggingPos == null) {
            this.startingDraggingPos = new Point(e.getX(), e.getY());
        }
        if (this.lastMousePos == null) {
            this.lastMousePos = e.getPoint();
            return;
        }
        if (!this.initialMoveThresholdExceeded) {
            int dp = (int)this.lastMousePos.distance(e.getX(), e.getY());
            if (dp < this.initialMoveThreshold) {
                return;
            }
            this.initialMoveThresholdExceeded = true;
        }
        if (e.getPoint().equals(this.lastMousePos)) {
            return;
        }
        EastNorth currentEN = this.mv.getEastNorth(e.getX(), e.getY());
        if (this.virtualManager.hasVirtualWaysToBeConstructed()) {
            this.virtualManager.createMiddleNodeFromVirtual(currentEN);
        } else if (!this.updateCommandWhileDragging(e, currentEN)) {
            return;
        }
        this.mv.repaint();
        if (this.mode != Mode.SCALE) {
            this.lastMousePos = e.getPoint();
        }
        this.didMouseDrag = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.removeHighlighting()) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        this.startingDraggingPos = null;
        this.mouseReleaseTime = System.currentTimeMillis();
        MapFrame map = MainApplication.getMap();
        if (this.mode == Mode.SELECT) {
            if (e.getButton() != 1) {
                return;
            }
            this.selectionManager.endSelecting(e);
            this.selectionManager.unregister(this.mv);
            if (!this.cancelDrawMode && this.getLayerManager().getActiveDataSet().selectionEmpty()) {
                map.selectDrawTool(true);
                this.updateStatusLine();
                return;
            }
        }
        if (this.mode == Mode.MOVE && e.getButton() == 1) {
            DataSet ds = this.getLayerManager().getEditDataSet();
            if (!this.didMouseDrag) {
                this.virtualManager.clear();
                if (this.lastMousePos == null || this.lastMousePos.distanceSq(e.getPoint()) < 100.0) {
                    this.updateKeyModifiers(e);
                    this.selectPrims(this.cycleManager.cyclePrims(), true, false);
                    Collection c = ds.getSelected();
                    if (e.getClickCount() >= 2 && c.size() == 1 && c.iterator().next() instanceof Node) {
                        MainApplication.worker.execute(() -> map.selectDrawTool(true));
                        return;
                    }
                }
            } else {
                this.confirmOrUndoMovement(e);
            }
        }
        this.mode = null;
        if (e.getButton() == 2) {
            this.removeHighlighting();
        } else {
            this.giveUserFeedback(e);
        }
        this.updateStatusLine();
    }

    @Override
    public void selectionEnded(Rectangle r, MouseEvent e) {
        this.updateKeyModifiers(e);
        this.selectPrims(this.selectionManager.getSelectedObjects(this.alt), true, true);
    }

    @Override
    public void doKeyPressed(KeyEvent e) {
        if (!(this.repeatedKeySwitchLassoOption && MainApplication.isDisplayingMapView() && this.getShortcut().isEvent(e))) {
            return;
        }
        if (Logging.isDebugEnabled()) {
            Logging.debug("{0} consuming event {1}", this.getClass().getName(), e);
        }
        e.consume();
        MapFrame map = MainApplication.getMap();
        if (!this.lassoMode) {
            map.selectMapMode(map.mapModeSelectLasso);
        } else {
            map.selectMapMode(map.mapModeSelect);
        }
    }

    @Override
    public void doKeyReleased(KeyEvent e) {
    }

    private void determineMapMode(boolean hasSelectionNearby) {
        this.mode = this.getLayerManager().getEditDataSet() != null ? (this.shift && this.platformMenuShortcutKeyMask ? Mode.ROTATE : (this.alt && this.platformMenuShortcutKeyMask ? Mode.SCALE : (hasSelectionNearby || this.dragInProgress() ? Mode.MOVE : Mode.SELECT))) : Mode.SELECT;
    }

    private boolean dragInProgress() {
        return this.didMouseDrag && this.startingDraggingPos != null;
    }

    private boolean updateCommandWhileDragging(MouseEvent mouseEvent, EastNorth currentEN) {
        Collection<Node> affectedNodes;
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection<OsmPrimitive> selection = ds.getSelectedNodesAndWays();
        if (selection.isEmpty()) {
            ds.setSelected(this.mv.getNearestNodeOrWay(this.mv.getPoint(this.startEN), this.mv.isSelectablePredicate, true));
        }
        if ((affectedNodes = AllNodesVisitor.getAllNodes(selection)).size() < 2 && (this.mode == Mode.ROTATE || this.mode == Mode.SCALE)) {
            return false;
        }
        Command c = SelectAction.getLastCommandInDataset(ds);
        if (this.mode == Mode.MOVE) {
            if (this.startEN == null) {
                return false;
            }
            return ds.update(() -> {
                MoveCommand moveCmd = null;
                if (c instanceof MoveCommand && affectedNodes.equals(((MoveCommand)c).getParticipatingPrimitives())) {
                    Way w;
                    EastNorth clampedEastNorth = currentEN;
                    if (this.platformMenuShortcutKeyMask && (w = ds.getLastSelectedWay()) != null && w.getNodesCount() == 2) {
                        double clamph = w.firstNode().getEastNorth().heading(w.lastNode().getEastNorth());
                        double dh = this.startEN.heading(currentEN, clamph);
                        switch ((int)(dh / 0.7853981633974483)) {
                            case 1: 
                            case 2: {
                                dh -= 1.5707963267948966;
                                break;
                            }
                            case 3: 
                            case 4: {
                                dh += Math.PI;
                                break;
                            }
                            case 5: 
                            case 6: {
                                dh += 1.5707963267948966;
                                break;
                            }
                        }
                        clampedEastNorth = currentEN.rotate(this.startEN, -dh);
                    }
                    moveCmd = (MoveCommand)c;
                    moveCmd.saveCheckpoint();
                    moveCmd.applyVectorTo(clampedEastNorth);
                } else if (!selection.isEmpty()) {
                    moveCmd = new MoveCommand(selection, this.startEN, currentEN);
                    UndoRedoHandler.getInstance().add(moveCmd);
                }
                for (Node n : affectedNodes) {
                    if (!n.isOutSideWorld()) continue;
                    if (moveCmd != null) {
                        moveCmd.resetToCheckpoint();
                    }
                    JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Cannot move objects outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                    this.mv.setNewCursor(this.cursor, (Object)this);
                    return false;
                }
                return true;
            });
        }
        this.startEN = currentEN;
        if (this.mode != Mode.ROTATE && this.mode != Mode.SCALE || SwingUtilities.isRightMouseButton(mouseEvent)) {
            return false;
        }
        return ds.update(() -> {
            if (this.mode == Mode.ROTATE) {
                if (c instanceof RotateCommand && affectedNodes.equals(((RotateCommand)c).getTransformedNodes())) {
                    ((RotateCommand)c).handleEvent(currentEN);
                } else {
                    UndoRedoHandler.getInstance().add(new RotateCommand(selection, currentEN));
                }
            } else if (this.mode == Mode.SCALE) {
                if (c instanceof ScaleCommand && affectedNodes.equals(((ScaleCommand)c).getTransformedNodes())) {
                    ((ScaleCommand)c).handleEvent(currentEN);
                } else {
                    UndoRedoHandler.getInstance().add(new ScaleCommand(selection, currentEN));
                }
            }
            Collection<Way> ways = ds.getSelectedWays();
            if (SelectAction.doesImpactStatusLine(affectedNodes, ways)) {
                MainApplication.getMap().statusLine.setDist(ways);
            }
            if (c instanceof RotateCommand) {
                double angle = Utils.toDegrees(((RotateCommand)c).getRotationAngle());
                MainApplication.getMap().statusLine.setAngleNaN(angle);
            } else if (c instanceof ScaleCommand) {
                String angle = String.format("%.2f", ((ScaleCommand)c).getScalingFactor()) + " \u00d7";
                MainApplication.getMap().statusLine.setAngleText(angle);
            }
            return true;
        });
    }

    private static boolean doesImpactStatusLine(Collection<Node> affectedNodes, Collection<Way> selectedWays) {
        return selectedWays.stream().flatMap(w -> w.getNodes().stream()).anyMatch(affectedNodes::contains);
    }

    private void useLastMoveCommandIfPossible() {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            return;
        }
        Command c = SelectAction.getLastCommandInDataset(dataSet);
        Collection<Node> affectedNodes = AllNodesVisitor.getAllNodes(dataSet.getSelected());
        if (c instanceof MoveCommand && affectedNodes.equals(((MoveCommand)c).getParticipatingPrimitives())) {
            ((MoveCommand)c).changeStartPoint(this.startEN);
        }
    }

    private static Command getLastCommandInDataset(DataSet ds) {
        Command lastCommand = UndoRedoHandler.getInstance().getLastCommand();
        if (lastCommand instanceof SequenceCommand) {
            lastCommand = ((SequenceCommand)lastCommand).getLastCommand();
        }
        if (lastCommand != null && ds.equals(lastCommand.getAffectedDataSet())) {
            return lastCommand;
        }
        return null;
    }

    private void confirmOrUndoMovement(MouseEvent e) {
        Command lastCommand;
        if (this.movesHiddenWay()) {
            ConfirmMoveDialog ed = new ConfirmMoveDialog();
            ed.setContent(I18n.tr("Are you sure that you want to move elements with attached ways that are hidden by filters?", new Object[0]));
            ed.toggleEnable("movedHiddenElements");
            SelectAction.showConfirmMoveDialog(ed);
        }
        if ((lastCommand = UndoRedoHandler.getInstance().getLastCommand()) == null) {
            Logging.warn("No command found in undo/redo history, skipping confirmOrUndoMovement");
            return;
        }
        SelectAction.checkCommandForLargeDistance(lastCommand);
        int moveCount = lastCommand.getParticipatingPrimitives().size();
        int max = Config.getPref().getInt("warn.move.maxelements", 20);
        if (moveCount > max) {
            ConfirmMoveDialog ed = new ConfirmMoveDialog();
            ed.setContent(I18n.trn("You moved more than {0} element. Moving a large number of elements is often an error.\nReally move them?", "You moved more than {0} elements. Moving a large number of elements is often an error.\nReally move them?", max, max));
            ed.toggleEnable("movedManyElements");
            SelectAction.showConfirmMoveDialog(ed);
        } else {
            this.updateKeyModifiers(e);
            if (this.isMergeRequested()) {
                this.mergePrims(e.getPoint());
            }
        }
    }

    static void checkCommandForLargeDistance(Command lastCommand) {
        double moveDistance;
        if (lastCommand == null) {
            return;
        }
        int moveCount = lastCommand.getParticipatingPrimitives().size();
        if (lastCommand instanceof MoveCommand && Double.isFinite(moveDistance = ((MoveCommand)lastCommand).getDistance(n -> !n.isNew())) && moveDistance > (double)Config.getPref().getInt("warn.move.maxdistance", 200)) {
            ConfirmMoveDialog ed = new ConfirmMoveDialog();
            ed.setContent(I18n.trn("You moved {0} element by a distance of {1}. Moving elements by a large distance is often an error.\nReally move them?", "You moved {0} elements by a distance of {1}. Moving elements by a large distance is often an error.\nReally move them?", moveCount, moveCount, SystemOfMeasurement.getSystemOfMeasurement().getDistText(moveDistance)));
            ed.toggleEnable("movedLargeDistance");
            SelectAction.showConfirmMoveDialog(ed);
        }
    }

    private static void showConfirmMoveDialog(ConfirmMoveDialog ed) {
        if (ed.showDialog().getValue() != 1) {
            UndoRedoHandler.getInstance().undo();
        }
    }

    private boolean movesHiddenWay() {
        DataSet ds = this.getLayerManager().getEditDataSet();
        HashSet elementsToTest = new HashSet(ds.getSelectedNodes());
        for (Way osm : ds.getSelectedWays()) {
            elementsToTest.addAll(osm.getNodes());
        }
        return elementsToTest.stream().flatMap(n -> n.referrers(Way.class)).anyMatch(AbstractPrimitive::isDisabledAndHidden);
    }

    private boolean isMergeRequested() {
        return MERGE_BY_DEFAULT.get() ^ this.platformMenuShortcutKeyMask;
    }

    private void mergePrims(Point p) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection selNodes = ds.getSelectedNodes();
        if (selNodes.isEmpty()) {
            return;
        }
        Node target = this.findNodeToMergeTo(p);
        if (target == null) {
            return;
        }
        if (selNodes.size() == 1) {
            Collection<OsmPrimitive> selection = ds.getSelectedNodesAndWays();
            Collection<Node> affectedNodes = AllNodesVisitor.getAllNodes(selection);
            Command c = SelectAction.getLastCommandInDataset(ds);
            ds.update(() -> {
                if (c instanceof MoveCommand && affectedNodes.equals(((MoveCommand)c).getParticipatingPrimitives())) {
                    Node selectedNode = (Node)selNodes.iterator().next();
                    EastNorth selectedEN = selectedNode.getEastNorth();
                    EastNorth targetEN = target.getEastNorth();
                    ((MoveCommand)c).moveAgain(targetEN.getX() - selectedEN.getX(), targetEN.getY() - selectedEN.getY());
                }
            });
        }
        LinkedList<Node> nodesToMerge = new LinkedList<Node>(selNodes);
        nodesToMerge.add(target);
        this.mergeNodes(MainApplication.getLayerManager().getEditLayer(), nodesToMerge, target);
    }

    public void mergeNodes(OsmDataLayer layer, Collection<Node> nodes, Node targetLocationNode) {
        MergeNodesAction.doMergeNodes(layer, nodes, targetLocationNode);
    }

    private Node findNodeToMergeTo(Point p) {
        List<Node> target = this.mv.getNearestNodes(p, this.getLayerManager().getEditDataSet().getSelectedNodes(), this.mv.isSelectablePredicate);
        return target.isEmpty() ? null : (Node)target.iterator().next();
    }

    private void selectPrims(Collection<OsmPrimitive> prims, boolean released, boolean area) {
        DataSet ds = this.getLayerManager().getActiveDataSet();
        if (ds == null || this.shift && this.platformMenuShortcutKeyMask || this.platformMenuShortcutKeyMask && !released || this.virtualManager.hasVirtualWaysToBeConstructed() && !released) {
            return;
        }
        if (!released) {
            this.shift |= ds.getSelected().containsAll(prims);
        }
        if (this.platformMenuShortcutKeyMask) {
            if (area) {
                ds.clearSelection(prims);
            } else {
                ds.toggleSelected(prims);
            }
        } else if (this.shift) {
            ds.addSelected(prims);
        } else {
            ds.setSelected(prims);
        }
    }

    public final Mode getMode() {
        return this.mode;
    }

    @Override
    public String getModeHelpText() {
        String type;
        String menuKey;
        switch (PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()) {
            case 128: {
                menuKey = I18n.trc("SelectAction help", "Ctrl");
                break;
            }
            case 256: {
                menuKey = I18n.trc("SelectAction help", "Meta");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown platform menu shortcut key for " + PlatformManager.getPlatform().getOSDescription());
            }
        }
        String string = type = this.lassoMode ? I18n.trc("SelectAction help", "lasso") : I18n.trc("SelectAction help", "rectangle");
        if (this.mouseDownButton == 1 && this.mouseReleaseTime < this.mouseDownTime) {
            if (this.mode == Mode.SELECT) {
                return I18n.tr("Release the mouse button to select the objects in the {0}.", type);
            }
            if (this.mode == Mode.MOVE && System.currentTimeMillis() - this.mouseDownTime >= (long)this.initialMoveDelay) {
                DataSet ds = this.getLayerManager().getEditDataSet();
                boolean canMerge = ds != null && !ds.getSelectedNodes().isEmpty();
                String mergeHelp = canMerge ? " " + I18n.tr("{0} to merge with nearest node.", menuKey) : "";
                return I18n.tr("Release the mouse button to stop moving.", new Object[0]) + mergeHelp;
            }
            if (this.mode == Mode.ROTATE) {
                return I18n.tr("Release the mouse button to stop rotating.", new Object[0]);
            }
            if (this.mode == Mode.SCALE) {
                return I18n.tr("Release the mouse button to stop scaling.", new Object[0]);
            }
        }
        return I18n.tr("Move objects by dragging; Shift to add to selection ({0} to toggle); Shift-{0} to rotate selected; Alt-{0} to scale selected; or change selection", menuKey);
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    public void setLassoMode(boolean lassoMode) {
        this.selectionManager.setLassoMode(lassoMode);
        this.lassoMode = lassoMode;
    }

    protected static <T> Collection<T> asColl(T o) {
        return o == null ? Collections.emptySet() : Collections.singleton(o);
    }

    private final class CycleManager {
        private Collection<OsmPrimitive> cycleList = Collections.emptyList();
        private boolean cyclePrims;
        private OsmPrimitive cycleStart;
        private boolean waitForMouseUpParameter;
        private boolean multipleMatchesParameter;

        private CycleManager() {
        }

        private void init() {
            this.waitForMouseUpParameter = Config.getPref().getBoolean("mappaint.select.waits-for-mouse-up", false);
            this.multipleMatchesParameter = Config.getPref().getBoolean("selectaction.cycles.multiple.matches", false);
        }

        private OsmPrimitive cycleSetup(OsmPrimitive nearest, Point p) {
            OsmPrimitive osm = null;
            if (nearest != null) {
                osm = nearest;
                if (!SelectAction.this.alt && !this.multipleMatchesParameter) {
                    this.cycleList = SelectAction.asColl(osm);
                    if (this.waitForMouseUpParameter) {
                        osm = SelectAction.this.mv.getNearestNodeOrWay(p, SelectAction.this.mv.isSelectablePredicate, true);
                    }
                } else {
                    this.cycleList = SelectAction.this.mv.getAllNearest(p, SelectAction.this.mv.isSelectablePredicate);
                    if (this.cycleList.size() > 1) {
                        this.cyclePrims = false;
                        OsmPrimitive old = osm;
                        for (OsmPrimitive o : this.cycleList) {
                            if (!o.isSelected()) continue;
                            this.cyclePrims = true;
                            osm = o;
                            break;
                        }
                        if (!(this.cycleList.size() != 2 || this.waitForMouseUpParameter || osm.equals(old) || osm.isNew() || SelectAction.this.platformMenuShortcutKeyMask)) {
                            this.cyclePrims = false;
                            osm = old;
                        }
                    }
                }
            }
            return osm;
        }

        private Collection<OsmPrimitive> cyclePrims() {
            if (this.cycleList.size() <= 1) {
                return this.cycleList;
            }
            DataSet ds = SelectAction.this.getLayerManager().getActiveDataSet();
            OsmPrimitive first = this.cycleList.iterator().next();
            OsmPrimitive foundInDS = null;
            OsmPrimitive nxt = first;
            if (this.cyclePrims && SelectAction.this.shift) {
                OsmPrimitive osmPrimitive;
                Iterator<OsmPrimitive> iterator = this.cycleList.iterator();
                while (iterator.hasNext() && (nxt = (osmPrimitive = iterator.next())).isSelected()) {
                }
            } else {
                Iterator<OsmPrimitive> i = this.cycleList.iterator();
                while (i.hasNext()) {
                    nxt = i.next();
                    if (!nxt.isSelected()) continue;
                    foundInDS = nxt;
                    if (!this.cyclePrims && !SelectAction.this.platformMenuShortcutKeyMask) break;
                    ds.clearSelection(foundInDS);
                    OsmPrimitive osmPrimitive = nxt = i.hasNext() ? i.next() : first;
                    break;
                }
            }
            if (SelectAction.this.platformMenuShortcutKeyMask) {
                if (foundInDS != null) {
                    if (!this.cycleList.contains(this.cycleStart)) {
                        ds.clearSelection(this.cycleList);
                        this.cycleStart = foundInDS;
                    } else if (this.cycleStart.equals(nxt)) {
                        ds.addSelected(nxt);
                    }
                } else {
                    this.cycleStart = nxt = this.cycleList.contains(this.cycleStart) ? this.cycleStart : first;
                }
            } else {
                this.cycleStart = null;
            }
            return SelectAction.asColl(nxt);
        }
    }

    private final class VirtualManager {
        private Node virtualNode;
        private Collection<WaySegment> virtualWays = new LinkedList<WaySegment>();
        private int nodeVirtualSize;
        private int virtualSnapDistSq2;
        private int virtualSpace;

        private VirtualManager() {
        }

        private void init() {
            this.nodeVirtualSize = Config.getPref().getInt("mappaint.node.virtual-size", 8);
            int virtualSnapDistSq = Config.getPref().getInt("mappaint.node.virtual-snap-distance", 8);
            this.virtualSnapDistSq2 = virtualSnapDistSq * virtualSnapDistSq;
            this.virtualSpace = Config.getPref().getInt("mappaint.node.virtual-space", 70);
        }

        private boolean activateVirtualNodeNearPoint(Point p) {
            if (this.nodeVirtualSize > 0) {
                LinkedList<WaySegment> selVirtualWays = new LinkedList<WaySegment>();
                Pair<Node, Node> vnp = null;
                Pair<Object, Object> wnp = new Pair<Object, Object>(null, null);
                for (WaySegment ws : SelectAction.this.mv.getNearestWaySegments(p, SelectAction.this.mv.isSelectablePredicate)) {
                    Point2D.Double pc;
                    MapViewState.MapViewPoint p2;
                    Way w = (Way)ws.getWay();
                    wnp.a = w.getNode(ws.getLowerIndex());
                    wnp.b = w.getNode(ws.getUpperIndex());
                    MapViewState.MapViewPoint p1 = SelectAction.this.mv.getState().getPointFor((Node)wnp.a);
                    if (!AbstractMapRenderer.isLargeSegment(p1, p2 = SelectAction.this.mv.getState().getPointFor((Node)wnp.b), this.virtualSpace) || !(p.distanceSq(pc = new Point2D.Double((p1.getInViewX() + p2.getInViewX()) / 2.0, (p1.getInViewY() + p2.getInViewY()) / 2.0)) < (double)this.virtualSnapDistSq2)) continue;
                    Pair.sort(wnp);
                    if (vnp == null) {
                        vnp = new Pair<Node, Node>((Node)wnp.a, (Node)wnp.b);
                        this.virtualNode = new Node(SelectAction.this.mv.getLatLon(((Point2D)pc).getX(), ((Point2D)pc).getY()));
                    }
                    if (!vnp.equals(wnp)) continue;
                    (w.isSelected() ? selVirtualWays : this.virtualWays).add(ws);
                }
                if (!selVirtualWays.isEmpty()) {
                    this.virtualWays = selVirtualWays;
                }
            }
            return !this.virtualWays.isEmpty();
        }

        private void createMiddleNodeFromVirtual(EastNorth currentEN) {
            if (SelectAction.this.startEN == null) {
                return;
            }
            DataSet ds = SelectAction.this.getLayerManager().getEditDataSet();
            LinkedList<Command> virtualCmds = new LinkedList<Command>();
            virtualCmds.add(new AddCommand(ds, this.virtualNode));
            for (WaySegment virtualWay : this.virtualWays) {
                Way w = (Way)virtualWay.getWay();
                List<Node> modNodes = w.getNodes();
                modNodes.add(virtualWay.getUpperIndex(), this.virtualNode);
                virtualCmds.add(new ChangeNodesCommand(ds, w, modNodes));
            }
            virtualCmds.add(new MoveCommand(ds, this.virtualNode, SelectAction.this.startEN, currentEN));
            String text = I18n.trn("Add and move a virtual new node to way", "Add and move a virtual new node to {0} ways", this.virtualWays.size(), this.virtualWays.size());
            UndoRedoHandler.getInstance().add(new SequenceCommand(text, virtualCmds));
            ds.setSelected(Collections.singleton(this.virtualNode));
            this.clear();
        }

        private void clear() {
            this.virtualWays.clear();
            this.virtualNode = null;
        }

        private boolean hasVirtualNode() {
            return this.virtualNode != null;
        }

        private boolean hasVirtualWaysToBeConstructed() {
            return !this.virtualWays.isEmpty();
        }
    }

    public static enum Mode {
        MOVE,
        ROTATE,
        SCALE,
        SELECT;

    }

    static enum SelectActionCursor {
        rect("normal", "selection"),
        rect_add("normal", "select_add"),
        rect_rm("normal", "select_remove"),
        way("normal", "select_way"),
        way_add("normal", "select_way_add"),
        way_rm("normal", "select_way_remove"),
        node("normal", "select_node"),
        node_add("normal", "select_node_add"),
        node_rm("normal", "select_node_remove"),
        virtual_node("normal", "addnode"),
        scale("scale", null),
        rotate("rotate", null),
        merge("crosshair", null),
        lasso("normal", "rope"),
        merge_to_node("crosshair", "joinnode"),
        move(13);

        private final Cursor c;

        private SelectActionCursor(String main, String sub) {
            this.c = ImageProvider.getCursor(main, sub);
        }

        private SelectActionCursor(int systemCursor) {
            this.c = Cursor.getPredefinedCursor(systemCursor);
        }

        public Cursor cursor() {
            return this.c;
        }
    }

    static class ConfirmMoveDialog
    extends ExtendedDialog {
        ConfirmMoveDialog() {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Move elements", new Object[0]), I18n.tr("Move them", new Object[0]), I18n.tr("Undo move", new Object[0]));
            this.setButtonIcons("reorder", "cancel");
            this.setCancelButton(2);
        }
    }
}

