/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.validation.tests.CrossingWays;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.Subpart;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.CompositeList;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public interface Selector {
    public static final String BASE_ANY = "*";
    public static final String BASE_NODE = "node";
    public static final String BASE_WAY = "way";
    public static final String BASE_RELATION = "relation";
    public static final String BASE_AREA = "area";
    public static final String BASE_META = "meta";
    public static final String BASE_CANVAS = "canvas";
    public static final String BASE_SETTING = "setting";
    public static final String BASE_SETTINGS = "settings";

    public boolean matches(Environment var1);

    public Subpart getSubpart();

    public Range getRange();

    public String getBase();

    public List<Condition> getConditions();

    public static class GeneralSelector
    extends AbstractSelector {
        public final String base;
        public final Range range;
        public final Subpart subpart;

        public GeneralSelector(String base, Range range, List<Condition> conds, Subpart subpart) {
            super(conds);
            this.base = GeneralSelector.checkBase(base);
            this.range = Objects.requireNonNull(range, "range");
            this.subpart = subpart != null ? subpart : Subpart.DEFAULT_SUBPART;
        }

        @Override
        public Subpart getSubpart() {
            return this.subpart;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        public boolean matchesConditions(Environment e) {
            return super.matches(e);
        }

        @Override
        public boolean matches(Environment e) {
            return this.matchesBase(e) && super.matches(e);
        }

        private static String checkBase(String base) {
            switch (base) {
                case "*": {
                    return Selector.BASE_ANY;
                }
                case "node": {
                    return Selector.BASE_NODE;
                }
                case "way": {
                    return Selector.BASE_WAY;
                }
                case "relation": {
                    return Selector.BASE_RELATION;
                }
                case "area": {
                    return Selector.BASE_AREA;
                }
                case "meta": {
                    return Selector.BASE_META;
                }
                case "canvas": {
                    return Selector.BASE_CANVAS;
                }
                case "setting": {
                    return Selector.BASE_SETTING;
                }
                case "settings": {
                    return Selector.BASE_SETTINGS;
                }
            }
            throw new IllegalArgumentException(MessageFormat.format("Unknown MapCSS base selector {0}", base));
        }

        @Override
        public String getBase() {
            return this.base;
        }

        public boolean matchesBase(OsmPrimitiveType type) {
            if (Selector.BASE_ANY.equals(this.base)) {
                return true;
            }
            if (OsmPrimitiveType.NODE == type) {
                return Selector.BASE_NODE.equals(this.base);
            }
            if (OsmPrimitiveType.WAY == type) {
                return Selector.BASE_WAY.equals(this.base) || Selector.BASE_AREA.equals(this.base);
            }
            if (OsmPrimitiveType.RELATION == type) {
                return Selector.BASE_AREA.equals(this.base) || Selector.BASE_RELATION.equals(this.base) || Selector.BASE_CANVAS.equals(this.base);
            }
            return false;
        }

        public boolean matchesBase(IPrimitive p) {
            if (!this.matchesBase(p.getType())) {
                return false;
            }
            if (p instanceof IRelation) {
                if (Selector.BASE_AREA.equals(this.base)) {
                    return ((IRelation)p).isMultipolygon();
                }
                if (Selector.BASE_CANVAS.equals(this.base)) {
                    return p.get("#canvas") != null;
                }
            }
            return true;
        }

        public boolean matchesBase(Environment e) {
            return this.matchesBase(e.osm);
        }

        public static Range fromLevel(int a, int b) {
            double lower = 0.0;
            double upper = Double.POSITIVE_INFINITY;
            if (b != Integer.MAX_VALUE) {
                lower = GeneralSelector.level2scale(b + 1);
            }
            if (a != 0) {
                upper = GeneralSelector.level2scale(a);
            }
            return new Range(lower, upper);
        }

        public static double level2scale(int lvl) {
            if (lvl < 0) {
                throw new IllegalArgumentException("lvl must be >= 0 but is " + lvl);
            }
            return Math.PI * 2 * Ellipsoid.WGS84.a / Math.pow(2.0, lvl) / 2.56;
        }

        public static int scale2level(double scale) {
            if (scale < 0.0) {
                throw new IllegalArgumentException("scale must be >= 0 but is " + scale);
            }
            return (int)Math.floor(Math.log(Math.PI * 2 * Ellipsoid.WGS84.a / 2.56 / scale) / Math.log(2.0));
        }

        public String toString() {
            return this.base + (Range.ZERO_TO_INFINITY.equals(this.range) ? "" : this.range) + (this.conds != null ? this.conds.stream().map(String::valueOf).collect(Collectors.joining("")) : "") + (this.subpart != null && this.subpart != Subpart.DEFAULT_SUBPART ? "::" + this.subpart : "");
        }
    }

    public static class LinkSelector
    extends AbstractSelector {
        public LinkSelector(List<Condition> conditions) {
            super(conditions);
        }

        @Override
        public boolean matches(Environment env) {
            Utils.ensure(env.isLinkContext(), "Requires LINK context in environment, got ''{0}''", new Object[]{env.getContext()});
            return super.matches(env);
        }

        @Override
        public String getBase() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Subpart getSubpart() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Range getRange() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "LinkSelector{conditions=" + this.conds + '}';
        }
    }

    public static abstract class AbstractSelector
    implements Selector {
        protected final List<Condition> conds;

        protected AbstractSelector(List<Condition> conditions) {
            this.conds = Utils.toUnmodifiableList(conditions);
        }

        @Override
        public boolean matches(Environment env) {
            CheckParameterUtil.ensureParameterNotNull(env, "env");
            for (Condition c : this.conds) {
                try {
                    if (c.applies(env)) continue;
                    return false;
                }
                catch (PatternSyntaxException e) {
                    Logging.log(Logging.LEVEL_ERROR, "PatternSyntaxException while applying condition" + c + ':', e);
                    return false;
                }
            }
            return true;
        }

        @Override
        public List<Condition> getConditions() {
            return this.conds;
        }
    }

    public static class ChildOrParentSelector
    implements Selector {
        public final Selector left;
        public final LinkSelector link;
        public final Selector right;
        public final ChildOrParentSelectorType type;

        public ChildOrParentSelector(Selector a, LinkSelector link, Selector b, ChildOrParentSelectorType type) {
            CheckParameterUtil.ensureParameterNotNull(a, "a");
            CheckParameterUtil.ensureParameterNotNull(b, "b");
            CheckParameterUtil.ensureParameterNotNull(link, "link");
            CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
            this.left = a;
            this.link = link;
            this.right = b;
            this.type = type;
        }

        @Override
        public String getBase() {
            return this.right.getBase();
        }

        @Override
        public List<Condition> getConditions() {
            return new CompositeList<Condition>(this.left.getConditions(), this.right.getConditions());
        }

        private void visitBBox(Environment e, AbstractFinder finder) {
            boolean withNodes = finder instanceof ContainsFinder;
            if (e.osm.getDataSet() != null) {
                if (this.left instanceof GeneralSelector) {
                    if (withNodes && ((GeneralSelector)this.left).matchesBase(OsmPrimitiveType.NODE)) {
                        finder.visit(e.osm.getDataSet().searchNodes(e.osm.getBBox()));
                    }
                    if (((GeneralSelector)this.left).matchesBase(OsmPrimitiveType.WAY)) {
                        finder.visit(e.osm.getDataSet().searchWays(e.osm.getBBox()));
                    }
                    if (((GeneralSelector)this.left).matchesBase(OsmPrimitiveType.RELATION)) {
                        finder.visit(e.osm.getDataSet().searchRelations(e.osm.getBBox()));
                    }
                } else {
                    if (withNodes) {
                        finder.visit(e.osm.getDataSet().searchNodes(e.osm.getBBox()));
                    }
                    finder.visit(e.osm.getDataSet().searchWays(e.osm.getBBox()));
                    finder.visit(e.osm.getDataSet().searchRelations(e.osm.getBBox()));
                }
            }
        }

        private static boolean isArea(IPrimitive p) {
            return p instanceof IWay && ((IWay)p).isClosed() && ((IWay)p).getNodesCount() >= 4 || p instanceof IRelation && p.isMultipolygon() && !p.isIncomplete();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(Environment e) {
            block23: {
                block22: {
                    if (!this.right.matches(e)) {
                        return false;
                    }
                    if (ChildOrParentSelectorType.SUBSET_OR_EQUAL == this.type || ChildOrParentSelectorType.NOT_SUBSET_OR_EQUAL == this.type) {
                        if (e.osm.getDataSet() == null || !ChildOrParentSelector.isArea(e.osm)) {
                            return ChildOrParentSelectorType.NOT_SUBSET_OR_EQUAL == this.type;
                        }
                        ContainsFinder containsFinder = new ContainsFinder(e);
                        e.parent = e.osm;
                        this.visitBBox(e, containsFinder);
                        containsFinder.execGeometryTests();
                        return ChildOrParentSelectorType.SUBSET_OR_EQUAL == this.type ? e.children != null : e.children == null;
                    }
                    if (ChildOrParentSelectorType.SUPERSET_OR_EQUAL == this.type || ChildOrParentSelectorType.NOT_SUPERSET_OR_EQUAL == this.type) {
                        if (e.osm.getDataSet() == null || e.osm instanceof INode && ((INode)e.osm).getCoor() == null || !(e.osm instanceof INode) && !ChildOrParentSelector.isArea(e.osm)) {
                            return ChildOrParentSelectorType.NOT_SUPERSET_OR_EQUAL == this.type;
                        }
                        InsideOrEqualFinder insideOrEqualFinder = new InsideOrEqualFinder(e);
                        e.parent = e.osm;
                        this.visitBBox(e, insideOrEqualFinder);
                        return ChildOrParentSelectorType.SUPERSET_OR_EQUAL == this.type ? e.children != null : e.children == null;
                    }
                    if (ChildOrParentSelectorType.CROSSING == this.type) {
                        e.parent = e.osm;
                        if (e.osm.getDataSet() != null && ChildOrParentSelector.isArea(e.osm)) {
                            CrossingFinder crossingFinder = new CrossingFinder(e);
                            this.visitBBox(e, crossingFinder);
                            return e.children != null;
                        }
                        return e.children != null;
                    }
                    if (ChildOrParentSelectorType.SIBLING != this.type) break block22;
                    if (!(e.osm instanceof INode)) break block23;
                    for (IPrimitive iPrimitive : e.osm.getReferrers(true)) {
                        Object n;
                        Environment e2;
                        IWay w;
                        int i;
                        if (!(iPrimitive instanceof IWay) || (i = (w = (IWay)iPrimitive).getNodes().indexOf(e.osm)) - 1 < 0 || !this.left.matches(e2 = e.withPrimitive((IPrimitive)(n = w.getNode(i - 1))).withParent(w).withChild(e.osm)) || !this.link.matches(e2.withLinkContext())) continue;
                        e.child = n;
                        e.index = i;
                        e.count = w.getNodesCount();
                        e.parent = w;
                        return true;
                    }
                    break block23;
                }
                if (ChildOrParentSelectorType.CHILD == this.type && this.link.conds != null && !this.link.conds.isEmpty() && this.link.conds.get(0) instanceof ConditionFactory.OpenEndPseudoClassCondition) {
                    if (e.osm instanceof INode) {
                        e.osm.visitReferrers(new MultipolygonOpenEndFinder(e));
                        return e.parent != null;
                    }
                } else if (ChildOrParentSelectorType.CHILD == this.type) {
                    MatchingReferrerFinder collector = new MatchingReferrerFinder(e);
                    e.osm.visitReferrers(collector);
                    if (e.parent != null) {
                        return true;
                    }
                } else if (ChildOrParentSelectorType.PARENT == this.type) {
                    if (e.osm instanceof IWay) {
                        void var3_11;
                        List wayNodes = ((IWay)e.osm).getNodes();
                        boolean bl = false;
                        while (var3_11 < wayNodes.size()) {
                            INode n = (INode)wayNodes.get((int)var3_11);
                            if (this.left.matches(e.withPrimitive(n)) && this.link.matches(e.withChildAndIndexAndLinkContext(n, (int)var3_11, wayNodes.size()))) {
                                e.child = n;
                                e.index = (int)var3_11;
                                e.count = wayNodes.size();
                                return true;
                            }
                            ++var3_11;
                        }
                    } else if (e.osm instanceof IRelation) {
                        void var3_13;
                        List members = ((IRelation)e.osm).getMembers();
                        boolean bl = false;
                        while (var3_13 < members.size()) {
                            Object member = ((IRelationMember)members.get((int)var3_13)).getMember();
                            if (this.left.matches(e.withPrimitive((IPrimitive)member)) && this.link.matches(e.withChildAndIndexAndLinkContext((IPrimitive)member, (int)var3_13, members.size()))) {
                                e.child = member;
                                e.index = (int)var3_13;
                                e.count = members.size();
                                return true;
                            }
                            ++var3_13;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public Subpart getSubpart() {
            return this.right.getSubpart();
        }

        @Override
        public Range getRange() {
            return this.right.getRange();
        }

        public String toString() {
            return this.left.toString() + ' ' + (ChildOrParentSelectorType.PARENT == this.type ? (char)'<' : '>') + this.link + ' ' + this.right;
        }

        private class InsideOrEqualFinder
        extends AbstractFinder {
            protected InsideOrEqualFinder(Environment e) {
                super(e);
            }

            @Override
            public void visit(IWay<?> w) {
                if (ChildOrParentSelector.this.left.matches(new Environment(w).withParent(this.e.osm)) && w.getBBox().bounds(this.e.osm.getBBox()) && !Geometry.filterInsidePolygon(Collections.singletonList(this.e.osm), w).isEmpty()) {
                    this.addToChildren(this.e, w);
                }
            }

            @Override
            public void visit(IRelation<?> r) {
                if (r instanceof Relation && r.isMultipolygon() && r.getBBox().bounds(this.e.osm.getBBox()) && ChildOrParentSelector.this.left.matches(new Environment(r).withParent(this.e.osm)) && !Geometry.filterInsideMultipolygon(Collections.singletonList(this.e.osm), (Relation)r).isEmpty()) {
                    this.addToChildren(this.e, r);
                }
            }
        }

        private class ContainsFinder
        extends AbstractFinder {
            protected List<IPrimitive> toCheck;

            protected ContainsFinder(Environment e) {
                super(e);
                CheckParameterUtil.ensureThat(!(e.osm instanceof INode), "Nodes not supported");
            }

            @Override
            public void visit(Collection<? extends IPrimitive> primitives) {
                for (IPrimitive iPrimitive : primitives) {
                    if (iPrimitive == this.e.osm || !this.isPrimitiveUsable(iPrimitive) || !ChildOrParentSelector.this.left.matches(new Environment(iPrimitive).withParent(this.e.osm))) continue;
                    if (this.toCheck == null) {
                        this.toCheck = new ArrayList<IPrimitive>();
                    }
                    this.toCheck.add(iPrimitive);
                }
            }

            void execGeometryTests() {
                if (this.toCheck == null || this.toCheck.isEmpty()) {
                    return;
                }
                for (IPrimitive p : Geometry.filterInsideAnyPolygon(this.toCheck, this.e.osm)) {
                    this.addToChildren(this.e, p);
                }
            }
        }

        private final class CrossingFinder
        extends AbstractFinder {
            private final String layer;
            private Area area;
            Map<Point2D, List<WaySegment>> cellSegments;

            private CrossingFinder(Environment e) {
                super(e);
                CheckParameterUtil.ensureThat(ChildOrParentSelector.isArea(e.osm), "Only areas are supported");
                this.layer = OsmUtils.getLayer(e.osm);
            }

            private Area getAreaEastNorth(IPrimitive p, Environment e) {
                if (e.mpAreaCache != null && p.isMultipolygon()) {
                    Area a = e.mpAreaCache.get(p);
                    if (a == null) {
                        a = Geometry.getAreaEastNorth(p);
                        e.mpAreaCache.put(p, a);
                    }
                    return a;
                }
                return Geometry.getAreaEastNorth(p);
            }

            private Map<List<Way>, List<WaySegment>> findCrossings(IPrimitive area, Map<Point2D, List<WaySegment>> cellSegments) {
                HashMap<List<Way>, List<WaySegment>> crossingWays = new HashMap<List<Way>, List<WaySegment>>(50);
                if (area instanceof Way) {
                    CrossingWays.findIntersectingWay((Way)area, cellSegments, crossingWays, false);
                } else if (area instanceof Relation && area.isMultipolygon()) {
                    Relation r = (Relation)area;
                    for (Way w : r.getMemberPrimitives(Way.class)) {
                        if (w.hasIncompleteNodes()) continue;
                        CrossingWays.findIntersectingWay(w, cellSegments, crossingWays, false);
                    }
                }
                return crossingWays;
            }

            @Override
            public void visit(Collection<? extends IPrimitive> primitives) {
                Set<OsmPrimitive> toIgnore = this.e.osm instanceof Relation ? ((Relation)this.e.osm).getMemberPrimitives() : null;
                for (IPrimitive iPrimitive : primitives) {
                    if (!this.isPrimitiveUsable(iPrimitive) || !Objects.equals(this.layer, OsmUtils.getLayer(iPrimitive)) || !ChildOrParentSelector.this.left.matches(new Environment(iPrimitive).withParent(this.e.osm)) || !ChildOrParentSelector.isArea(iPrimitive) || toIgnore != null && toIgnore.contains(iPrimitive) || this.e.osm instanceof Way && ((Way)this.e.osm).referrers(Relation.class).anyMatch(ref -> ref == p)) continue;
                    this.visitArea(iPrimitive);
                }
            }

            private void visitArea(IPrimitive p) {
                if (this.area == null) {
                    this.area = this.getAreaEastNorth(this.e.osm, this.e);
                }
                Area otherArea = this.getAreaEastNorth(p, this.e);
                if (this.area.isEmpty() || otherArea.isEmpty()) {
                    this.useFindCrossings(p);
                } else {
                    Pair<Geometry.PolygonIntersection, Area> is = Geometry.polygonIntersectionResult(otherArea, this.area, 1.0E-4);
                    if (Geometry.PolygonIntersection.CROSSING == is.a) {
                        this.addToChildren(this.e, p);
                        if (this.e.intersections == null) {
                            this.e.intersections = new HashMap<IPrimitive, Area>();
                        }
                        this.e.intersections.put(p, (Area)is.b);
                    }
                }
            }

            private void useFindCrossings(IPrimitive p) {
                HashMap<Point2D, List<WaySegment>> tmpCellSegments;
                Map<List<Way>, List<WaySegment>> crossingWays;
                if (this.cellSegments == null) {
                    this.cellSegments = new HashMap<Point2D, List<WaySegment>>();
                    this.findCrossings(this.e.osm, this.cellSegments);
                }
                if (!(crossingWays = this.findCrossings(p, tmpCellSegments = new HashMap<Point2D, List<WaySegment>>(this.cellSegments))).isEmpty()) {
                    this.addToChildren(this.e, p);
                    if (this.e.crossingWaysMap == null) {
                        this.e.crossingWaysMap = new HashMap<IPrimitive, Map<List<Way>, List<WaySegment>>>();
                    }
                    this.e.crossingWaysMap.put(p, crossingWays);
                }
            }
        }

        private class MultipolygonOpenEndFinder
        extends AbstractFinder {
            private final PrimitiveVisitor innerVisitor;

            @Override
            public void visit(IWay<?> w) {
                w.visitReferrers(this.innerVisitor);
            }

            MultipolygonOpenEndFinder(Environment e) {
                super(e);
                this.innerVisitor = new AbstractFinder(this.e){

                    @Override
                    public void visit(IRelation<?> r) {
                        List<Node> openEnds;
                        int openEndIndex;
                        if (r instanceof Relation && ChildOrParentSelector.this.left.matches(this.e.withPrimitive(r)) && (openEndIndex = (openEnds = MultipolygonCache.getInstance().get((Relation)r).getOpenEnds()).indexOf(this.e.osm)) >= 0) {
                            this.e.parent = r;
                            this.e.index = openEndIndex;
                            this.e.count = openEnds.size();
                        }
                    }
                };
            }
        }

        private static abstract class AbstractFinder
        implements PrimitiveVisitor {
            protected final Environment e;

            protected AbstractFinder(Environment e) {
                this.e = e;
            }

            @Override
            public void visit(INode n) {
            }

            @Override
            public void visit(IWay<?> w) {
            }

            @Override
            public void visit(IRelation<?> r) {
            }

            public void visit(Collection<? extends IPrimitive> primitives) {
                for (IPrimitive iPrimitive : primitives) {
                    if (this.e.child != null) break;
                    if (!this.isPrimitiveUsable(iPrimitive)) continue;
                    iPrimitive.accept(this);
                }
            }

            public boolean isPrimitiveUsable(IPrimitive p) {
                return !this.e.osm.equals(p) && p.isUsable();
            }

            protected void addToChildren(Environment e, IPrimitive p) {
                if (e.children == null) {
                    e.children = new LinkedHashSet<IPrimitive>();
                }
                e.children.add(p);
            }
        }

        private class MatchingReferrerFinder
        implements PrimitiveVisitor {
            private final Environment e;

            MatchingReferrerFinder(Environment e) {
                this.e = e;
            }

            @Override
            public void visit(INode n) {
                throw new AssertionError();
            }

            private <T extends IPrimitive> void doVisit(T parent, IntSupplier counter, IntFunction<IPrimitive> getter) {
                if (this.e.parent != null) {
                    return;
                }
                if (!ChildOrParentSelector.this.left.matches(this.e.withPrimitive(parent))) {
                    return;
                }
                int count = counter.getAsInt();
                if (ChildOrParentSelector.this.link.conds == null || ChildOrParentSelector.this.link.conds.isEmpty()) {
                    this.e.parent = parent;
                    this.e.count = count;
                    return;
                }
                int step = this.firstAndLastOnly() ? count - 1 : 1;
                for (int i = 0; i < count; i += step) {
                    if (!getter.apply(i).equals(this.e.osm) || !ChildOrParentSelector.this.link.matches(this.e.withParentAndIndexAndLinkContext(parent, i, count))) continue;
                    this.e.parent = parent;
                    this.e.index = i;
                    this.e.count = count;
                    return;
                }
            }

            private boolean firstAndLastOnly() {
                return ChildOrParentSelector.this.link.conds.stream().allMatch(c -> c instanceof ConditionFactory.IndexCondition && ((ConditionFactory.IndexCondition)c).isFirstOrLast);
            }

            @Override
            public void visit(IWay<?> w) {
                this.doVisit(w, w::getNodesCount, w::getNode);
            }

            @Override
            public void visit(IRelation<?> r) {
                this.doVisit(r, r::getMembersCount, i -> r.getMember(i).getMember());
            }
        }
    }

    public static enum ChildOrParentSelectorType {
        CHILD,
        PARENT,
        SUBSET_OR_EQUAL,
        NOT_SUBSET_OR_EQUAL,
        SUPERSET_OR_EQUAL,
        NOT_SUPERSET_OR_EQUAL,
        CROSSING,
        SIBLING;

    }
}

