/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.UnJoinNodeWayAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SplitWayCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitWayAction
extends JosmAction {
    public SplitWayAction() {
        super(I18n.tr("Split Way", new Object[0]), "splitway", I18n.tr("Split a way at the selected node.", new Object[0]), Shortcut.registerShortcut("tools:splitway", I18n.tr("Tools: {0}", I18n.tr("Split Way", new Object[0])), 80, 5003), true);
        this.setHelpId(HelpUtil.ht("/Action/SplitWay"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SplitWayAction.runOn(this.getLayerManager().getEditDataSet());
    }

    public static void runOn(DataSet ds) {
        List mainWays;
        if (SegmentToKeepSelectionDialog.DISPLAY_COUNT.get() > 0) {
            new Notification(I18n.tr("Cannot split since another split operation is already in progress", new Object[0])).setIcon(2).show();
            return;
        }
        ArrayList<Node> selectedNodes = new ArrayList<Node>(ds.getSelectedNodes());
        ArrayList<Way> selectedWays = new ArrayList<Way>(ds.getSelectedWays());
        List<Way> applicableWays = SplitWayAction.getApplicableWays(selectedWays, selectedNodes);
        if (applicableWays == null) {
            new Notification(I18n.tr("The current selection cannot be used for splitting - no node is selected.", new Object[0])).setIcon(2).show();
            return;
        }
        if (applicableWays.isEmpty()) {
            new Notification(I18n.tr("The selected nodes do not share the same way.", new Object[0])).setIcon(2).show();
            return;
        }
        if (applicableWays.size() > 1) {
            applicableWays.removeIf(w -> selectedNodes.stream().noneMatch(w::isInnerNode));
        }
        if (applicableWays.size() > 1 && (mainWays = applicableWays.stream().filter(w -> w.hasKey("highway", "railway", "waterway")).collect(Collectors.toList())).size() == 1) {
            applicableWays = mainWays;
        }
        if (applicableWays.isEmpty()) {
            new Notification(I18n.trn("The selected node is not in the middle of any way.", "The selected nodes are not in the middle of any way.", selectedNodes.size(), new Object[0])).setIcon(2).show();
            return;
        }
        if (applicableWays.size() > 1) {
            new Notification(I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", selectedNodes.size(), new Object[0])).setIcon(2).show();
            return;
        }
        Way selectedWay = applicableWays.get(0);
        List<List<Node>> wayChunks = SplitWayCommand.buildSplitChunks(selectedWay, selectedNodes);
        if (wayChunks != null) {
            ArrayList<OsmPrimitive> sel = new ArrayList<OsmPrimitive>(ds.getSelectedRelations());
            sel.addAll(selectedWays);
            List<Way> newWays = SplitWayCommand.createNewWaysFromChunks(selectedWay, wayChunks);
            Way wayToKeep = SplitWayCommand.Strategy.keepLongestChunk().determineWayToKeep(newWays);
            if (ExpertToggleAction.isExpert() && !selectedWay.isNew()) {
                SegmentToKeepSelectionDialog dialog = new SegmentToKeepSelectionDialog(selectedWay, newWays, wayToKeep, sel);
                dialog.toggleEnable("way.split.segment-selection-dialog");
                if (!dialog.toggleCheckState()) {
                    dialog.setModal(false);
                    dialog.showDialog();
                    return;
                }
            }
            if (wayToKeep != null) {
                SplitWayAction.doSplitWay(selectedWay, wayToKeep, newWays, sel);
            }
        }
    }

    static List<Way> getApplicableWays(List<Way> selectedWays, List<Node> selectedNodes) {
        if (selectedNodes.isEmpty()) {
            return null;
        }
        if (selectedNodes.size() == 1) {
            Node n = selectedNodes.get(0);
            List<Way> referredWays = n.getParentWays();
            Way inTheMiddle = null;
            for (Way w : referredWays) {
                if (!selectedWays.contains(w) || !w.isInnerNode(n)) continue;
                if (inTheMiddle == null) {
                    inTheMiddle = w;
                    continue;
                }
                inTheMiddle = null;
                break;
            }
            if (inTheMiddle != null) {
                return Collections.singletonList(inTheMiddle);
            }
        }
        return UnJoinNodeWayAction.getApplicableWays(selectedWays, selectedNodes);
    }

    static void doSplitWay(Way way, Way wayToKeep, List<Way> newWays, List<OsmPrimitive> newSelection) {
        MapFrame map = MainApplication.getMap();
        boolean isMapModeDraw = map != null && map.mapMode == map.mapModeDraw;
        Optional<SplitWayCommand> splitWayCommand = SplitWayCommand.doSplitWay(way, wayToKeep, newWays, !isMapModeDraw ? newSelection : null, SplitWayCommand.WhenRelationOrderUncertain.ASK_USER_FOR_CONSENT_TO_DOWNLOAD);
        splitWayCommand.ifPresent(result -> {
            UndoRedoHandler.getInstance().add((Command)result);
            List<? extends PrimitiveId> newSel = result.getNewSelection();
            if (newSel != null && !newSel.isEmpty()) {
                way.getDataSet().setSelected(newSel);
            }
        });
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(OsmUtils.isOsmCollectionEditable(selection) && selection.stream().anyMatch(o -> o instanceof Node && !o.isIncomplete()));
    }

    static class SegmentListCellRenderer
    extends DefaultListCellRenderer {
        SegmentListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String name = DefaultNameFormatter.getInstance().format((Way)value);
            String nameWithoutId = name.replace(I18n.tr(" [id: {0}]", ((Way)value).getId()), "").replace(I18n.tr(" [id: {0}]", ((Way)value).getUniqueId()), "");
            ((JLabel)c).setText(I18n.tr("Segment {0}: {1}", index + 1, nameWithoutId));
            return c;
        }
    }

    static class SegmentToKeepSelectionDialog
    extends ExtendedDialog {
        static final AtomicInteger DISPLAY_COUNT = new AtomicInteger();
        final transient Way selectedWay;
        final transient List<Way> newWays;
        final JList<Way> list;
        final transient List<OsmPrimitive> selection;
        final transient Way wayToKeep;

        SegmentToKeepSelectionDialog(Way selectedWay, List<Way> newWays, Way wayToKeep, List<OsmPrimitive> selection) {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Which way segment should reuse the history of {0}?", selectedWay.getId()), new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0])}, true);
            this.selectedWay = selectedWay;
            this.newWays = newWays;
            this.selection = selection;
            this.wayToKeep = wayToKeep;
            this.list = new JList<Way>(newWays.toArray(new Way[0]));
            this.configureList();
            this.setButtonIcons("ok", "cancel");
            JPanel pane = new JPanel(new GridBagLayout());
            pane.add((Component)new JLabel(this.getTitle()), GBC.eol().fill(2));
            pane.add(this.list, GBC.eop().fill(2));
            this.setContent(pane);
            this.setDefaultCloseOperation(1);
        }

        private void configureList() {
            this.list.setSelectionMode(0);
            this.list.addListSelectionListener(e -> {
                Way selected = this.list.getSelectedValue();
                if (selected != null && MainApplication.isDisplayingMapView() && selected.getNodesCount() > 1) {
                    ArrayList<WaySegment> segments = new ArrayList<WaySegment>(selected.getNodesCount() - 1);
                    Iterator<Node> it = selected.getNodes().iterator();
                    Node previousNode = it.next();
                    while (it.hasNext()) {
                        Node node = it.next();
                        segments.add(WaySegment.forNodePair(this.selectedWay, previousNode, node));
                        previousNode = node;
                    }
                    this.setHighlightedWaySegments(segments);
                }
            });
            this.list.setCellRenderer(new SegmentListCellRenderer());
        }

        protected void setHighlightedWaySegments(Collection<WaySegment> segments) {
            this.selectedWay.getDataSet().setHighlightedWaySegments(segments);
            MainApplication.getMap().mapView.repaint();
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                DISPLAY_COUNT.incrementAndGet();
                this.list.setSelectedValue(this.wayToKeep, true);
            } else {
                this.setHighlightedWaySegments(Collections.emptyList());
                DISPLAY_COUNT.decrementAndGet();
            }
        }

        @Override
        protected void buttonAction(int buttonIndex, ActionEvent evt) {
            super.buttonAction(buttonIndex, evt);
            this.toggleSaveState();
            if (this.getValue() == 1) {
                SplitWayAction.doSplitWay(this.selectedWay, this.list.getSelectedValue(), this.newWays, this.selection);
            }
        }
    }
}

