/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class CloseChangesetTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private final Collection<Changeset> changesets;
    private final List<Changeset> closedChangesets;

    public CloseChangesetTask(Collection<Changeset> changesets) {
        super(I18n.tr("Closing changeset", new Object[0]), false);
        this.changesets = Optional.ofNullable(changesets).orElseGet(ArrayList::new);
        this.closedChangesets = new ArrayList<Changeset>();
    }

    @Override
    protected void cancel() {
        this.canceled = true;
        OsmApi.getOsmApi().cancel();
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
        SwingUtilities.invokeLater(() -> ChangesetCache.getInstance().update(this.closedChangesets));
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            for (Changeset cs : this.changesets) {
                if (this.canceled) {
                    return;
                }
                if (cs == null || cs.getId() <= 0 || !cs.isOpen()) continue;
                this.getProgressMonitor().subTask(I18n.tr("Closing changeset {0}", cs.getId()));
                OsmApi.getOsmApi().closeChangeset(cs, this.getProgressMonitor().createSubTaskMonitor(1, false));
                this.closedChangesets.add(cs);
            }
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            this.lastException = e;
        }
    }
}

