#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>

#ifndef LINUX
#include <CoreServices/CoreServices.h>
#endif

#define GLOBAL
#include "global.h"

int qual_22_44[4] = { 4, 3, 2, 1 };
int qual_srad[4] = { 8, 8, 16, 16 };
int qual_hf_quant[4] = { 1, 1, 1, 1 }; // 0 = normal, 1 = reduce hf, 2 = keep hf

int usage(char *name)
{
	fprintf(stderr, "Usage is : %s <lowering factor> <quality 0=fast..3=high quality> <input m2v size in bytes>\n", name);
	return -1;
}

int extractFrame();

int main(int argc, char *argv[])
{
	int param_qual,			// quality preset, 0=fast, 3=hq
		param_quant,	// base thing
#ifndef LINUX
		param_num_cpus = MPProcessors(); // 1 = mono, 2 = dual
#else
		param_num_cpus = 1;
#endif
	double param_fact_x;	// total size should be divided by this factor
	long long param_orim2vsize;
	
	if (argc == 2)
	{
		if (!strcmp(argv[1],"extractFrame"))
			return extractFrame();
	}
	
	if (argc != 4) return usage(argv[0]);
	
	param_fact_x = atof(argv[1]);
	param_qual = atoi(argv[2]);
	// param_orim2vsize = atoll(argv[3]); // not available on 10.2
	sscanf(argv[3], "%lld", &param_orim2vsize);
	
	if (param_fact_x <= 1.0)
	{
		unsigned char buf[4096];

		while(1)
		{		
			int i = read(0, buf, 4096);
			if (i > 0) write(1, buf, i);
			else return 0;
		}
	}
	
	if ( (param_qual<0) || (param_qual>3) ) return usage(argv[0]);
	
	param_quant = param_fact_x;
	
	fprintf(stderr, "M2VDownsizer by Makira.\n");
	fprintf(stderr, "Using %f as factor, %lld as size and %i as quality - %i cpu(s).\n",
						param_fact_x, param_orim2vsize, param_qual, param_num_cpus);
						
	//sleep(10);

	reencode(	qual_hf_quant[param_qual],
				qual_22_44[param_qual],
				qual_22_44[param_qual],
				qual_srad[param_qual],
				param_quant,
				param_fact_x,
				param_num_cpus,
				param_orim2vsize );

	return 0;
}




// - - - - - - - - - -
#include "mpeg2.h"
#define RAWBUFSIZE (1024*1024*8)
int HasAltiVec(); // defined in readPic.c
int extractFrame()
{
	mpeg2dec_t *mpeg2dec;
	uint32_t accel;
#ifndef LINUX
	if (HasAltiVec()) accel = MPEG2_ACCEL_PPC_ALTIVEC;
	else accel = 0; 
#else
	accel = 0;
#endif

	mpeg2_accel(accel);
	mpeg2dec = mpeg2_init(); assert(mpeg2dec);
	
	unsigned char *rawbuf = malloc(RAWBUFSIZE);
	int i, c = 0;
	
	while(c < RAWBUFSIZE)
	{
		i = read(0, rawbuf+c, RAWBUFSIZE-c);
		//fprintf(stderr, "i: %i\n", i);
		
		if (i <= 0)
		{
			if (c == 0) return 0; // original m2v stream is void
			else break;
		}
		else
		{
			c += i;
		}
	}	
	close(0);
	
	//fprintf(stderr, "c: %i\n", c);
		
	mpeg2_buffer(mpeg2dec,rawbuf,rawbuf+c);
	
	const mpeg2_info_t *info = mpeg2_info(mpeg2dec);
	while (1)
	{
		int state = mpeg2_parse(mpeg2dec);
		switch(state)
		{
			case STATE_SLICE:
			case STATE_END:
				if (info->current_fbuf)
				{
					int w = info->sequence->width, h = info->sequence->height, wh = w * h;
					
					write(1, &w, sizeof(int));
					write(1, &h, sizeof(int));
					
					write(1, info->current_fbuf->buf[0], wh);
					
					h >>= 1; w >>= 1; wh = w * h;
					write(1, info->current_fbuf->buf[1], wh);
					write(1, info->current_fbuf->buf[2], wh);
					
					//fprintf(stderr, "w: %i h:%i\n", w, h);
					return 0;
				}
				break;

			case STATE_BUFFER:
				// not enough data for a pict
				return 1;
			
			default:
				break;
		}
	}

}






