% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gibbs.R
\name{Gibbs}
\alias{Gibbs}
\title{Gibbs}
\usage{
Gibbs(y, X, a, b, lambda, maxiter, burn.in, initial.beta = NULL, sigma = 1)
}
\arguments{
\item{y}{A vector of continuous responses (n x 1).}

\item{X}{The design matrix (n x p), without an intercept.}

\item{a, b}{Parameters of the prior.}

\item{lambda}{A two-dim vector = c(lambda0, lambda1).}

\item{maxiter}{An integer which specifies the maximum number of iterations for MCMC.}

\item{burn.in}{An integer which specifies the maximum number of burn-in iterations for MCMC.}

\item{initial.beta}{A vector of initial values of beta to used. If set to NULL, the LASSO solution with 10-fold cross validation is used. Default is NULL.}

\item{sigma}{Noise standard deviation. Default is 1.}
}
\value{
A list, including matrix 'beta' ((maxiter-burn.in) x p), matrix 'tau2' ((maxiter-burn.in) x p),
matrix 'gamma' ((maxiter-burn.in) x p), vector 'theta' ((maxiter-burn.in) x 1).
}
\description{
This function runs SSVS for linear regression with Spike-and-Slab LASSO prior.
By default, this function uses the speed-up trick in Bhattacharya et al. (2016) when p > n.
}
\examples{
n = 50; p = 12;
truth.beta = c(1.3, 1.3, 1.3, 1.3);
truth.sigma = 1
data = Generate_data(truth.beta, p, n, truth.sigma = 1, rho = 0.6,"block",4)
y = data$y; X = data$X; beta = data$beta

# --------------- set parameters -----------------
lambda0 = 7; lambda1 = 0.15; lambda = c(lambda0, lambda1)
a = 1; b = p #beta prior for theta

# this is for demonstration of usage only
# in practice, you may want to use more iterations!
MCchain1 = Gibbs(y, X, a, b, lambda, maxiter = 1000, burn.in = 100)
}
\references{
Nie, L., & Ročková, V. (2020). Bayesian Bootstrap Spike-and-Slab LASSO. arXiv:2011.14279.

Bhattacharya, A., Chakraborty, A., & Mallick, B. K. (2016). Fast sampling with Gaussian scale mixture priors in high-dimensional regression. Biometrika, 103(4):985.
}
\author{
Lizhen Nie \href{mailto:lizhen@statistics.uchicago.edu}{lizhen@statistics.uchicago.edu}, Veronika Rockova \href{mailto:Veronika.Rockova@chicagobooth.edu}{Veronika.Rockova@chicagobooth.edu}
}
