% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/length.R
\name{set_size}
\alias{set_size}
\alias{set_size,TidySet-method}
\title{Calculates the size of a set}
\usage{
set_size(object, sets = NULL)

\S4method{set_size}{TidySet}(object, sets = NULL)
}
\arguments{
\item{object}{A TidySet object.}

\item{sets}{The sets from which the length is calculated.}
}
\value{
A list with the size of the set or the probability of having that
size.
}
\description{
Assuming that the fuzzy values are probabilities,
calculates the probability of being of different sizes for a given set.
}
\section{Methods (by class)}{
\itemize{
\item \code{TidySet}: Calculates the size of a set using \code{\link[=length_set]{length_set()}}
}}

\examples{
relations <- data.frame(
    sets = c(rep("A", 5), "B", "C"),
    elements = c(letters[seq_len(6)], letters[6]),
    fuzzy = runif(7)
)
a <- tidySet(relations)
set_size(a)
}
\seealso{
cardinality

Other sizes: 
\code{\link{element_size}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{methods}
\concept{sizes}
