% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors-informed.R
\name{prior_informed}
\alias{prior_informed}
\title{Creates an informed prior distribution based on research}
\usage{
prior_informed(name, parameter = NULL, type = "smd")
}
\arguments{
\item{name}{name of the prior distribution. There are many options based on prior psychological
or medical research.
For psychology, the possible options are
\describe{
\item{\code{"van Erp"}}{for an informed prior distribution for the heterogeneity parameter tau
of meta-analytic effect size estimates based on standardized mean differences
\insertCite{erp2017estimates}{BayesTools},}
\item{\code{"Oosterwijk"}}{for an informed prior distribution for the effect sizes expected in
social psychology based on prior elicitation with dr. Oosterwijk
\insertCite{gronau2017bayesian}{BayesTools}.}
}
For medicine, the possible options are based on \insertCite{bartos2021bayesian;textual}{BayesTools}
who developed empirical prior distributions for the effect size and heterogeneity parameters of the
continuous standardized outcomes based on the Cochrane database of systematic reviews.
Use \code{"Cochrane"} for a prior distribution based on the whole database or call
\code{print(prior_informed_medicine_names)} to inspect the names of
all 46 subfields and set the appropriate \code{parameter} and \code{type}.}

\item{parameter}{parameter name describing what prior distribution is supposed to be produced in cases
where the \code{name} corresponds to multiple prior distributions. Relevant only for the empirical medical
prior distributions.}

\item{type}{prior type describing what prior distribution is supposed to be produced in cases
where the \code{name} and \code{parameter} correspond to multiple prior distributions. Relevant only for
the empirical medical prior distributions.}
}
\value{
\code{prior_informed} returns an object of class 'prior'.
}
\description{
\code{prior_informed} creates an informed prior distribution based on past
research. The prior can be visualized by the \code{plot} function.
}
\examples{
# prior distribution representing expected effect sizes in social psychology
# based on prior elicitation with dr. Oosterwijk
p1 <- prior_informed("Oosterwijk")

# the prior distribution can be visualized using the plot function
# (see ?plot.prior for all options)
plot(p1)


# empirical prior distribution for the standardized mean differences from the oral health
# medical subfield based on meta-analytic effect size estimates from the
# Cochrane database of systematic reviews
p2 <- prior_informed("Oral Health", parameter = "effect", type = "smd")
print(p2)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=prior]{prior()}}, \link{prior_informed_medicine_names}
}
