% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/colAnyMissings.R,
%   R/colAnyNAs.R, R/rowAnyMissings.R, R/rowAnyNAs.R
\name{colAnyMissings}
\alias{colAnyMissings}
\alias{rowAnyMissings}
\alias{colAnyMissings,DelayedMatrix-method}
\alias{colAnyNAs,DelayedMatrix-method}
\alias{rowAnyMissings,DelayedMatrix-method}
\alias{rowAnyNAs,DelayedMatrix-method}
\title{Checks if there are any missing values in an object or not}
\usage{
colAnyMissings(x, rows = NULL, cols = NULL, ..., useNames = NA)

rowAnyMissings(x, rows = NULL, cols = NULL, ..., useNames = NA)

\S4method{colAnyMissings}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{colAnyNAs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowAnyMissings}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowAnyNAs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows}{A \code{\link[base]{vector}} indicating subset of rows to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{cols}{A \code{\link[base]{vector}} indicating subset of columns to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}
}
\value{
Returns \code{\link[base:logical]{TRUE}} if a missing value was
detected, otherwise \code{\link[base:logical]{FALSE}}.
}
\description{
Checks if there are any missing values in an object or not.
\emph{Please use \code{base::anyNA()} instead of \code{anyMissing()},
\code{colAnyNAs()} instead of \code{colAnyMissings()}, and
\code{rowAnyNAs()} instead of \code{rowAnyMissings()}.}
}
\details{
The implementation of this method is optimized for both speed and memory.
The method will return \code{\link[base:logical]{TRUE}} as soon as a missing
value is detected.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'HDF5ArraySeed' seed
# NOTE: Requires that the HDF5Array package is installed
library(HDF5Array)
dm_HDF5 <- writeHDF5Array(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))

dm_matrix[dm_matrix > 3] <- NA
colAnyNAs(dm_matrix)
dm_HDF5[dm_HDF5 > 3] <- NA
rowAnyNAs(dm_HDF5)
}
\seealso{
Starting with R v3.1.0, there is \code{anyNA()} in the \pkg{base},
which provides the same functionality as \code{anyMissing()}.
}
\author{
Peter Hickey
}
