% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colMeans2.R, R/rowMeans2.R
\name{colMeans2,DelayedMatrix-method}
\alias{colMeans2,DelayedMatrix-method}
\alias{colMeans2,Matrix-method}
\alias{colMeans2,SolidRleArraySeed-method}
\alias{rowMeans2,DelayedMatrix-method}
\alias{rowMeans2,Matrix-method}
\title{Calculates the mean for each row (column) of a matrix-like object}
\usage{
\S4method{colMeans2}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{colMeans2}{Matrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)

\S4method{colMeans2}{SolidRleArraySeed}(x, rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)

\S4method{rowMeans2}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowMeans2}{Matrix}(x, rows = NULL, cols = NULL, na.rm = FALSE, ..., useNames = TRUE)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the mean for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowMeans2}} /
\code{matrixStats::\link[matrixStats]{colMeans2}}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'SolidRleArraySeed' seed
dm_Rle <- RleArray(Rle(c(rep(1L, 5),
                         as.integer((0:4) ^ 2),
                         seq(-5L, -1L, 1L))),
                   dim = c(5, 3))

colMeans2(dm_matrix)

# NOTE: Temporarily use verbose output to demonstrate which method is
#       which method is being used
options(DelayedMatrixStats.verbose = TRUE)
# By default, this uses a seed-aware method for a DelayedMatrix with a
# 'SolidRleArraySeed' seed
rowMeans2(dm_Rle)
# Alternatively, can use the block-processing strategy
rowMeans2(dm_Rle, force_block_processing = TRUE)
options(DelayedMatrixStats.verbose = FALSE)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowMeans2}()} and
\code{matrixStats::\link[matrixStats:rowMeans2]{colMeans2}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \code{\link[base:colSums]{rowMeans}()} for the
corresponding function in base R.
\item For variance estimates, see \code{\link[MatrixGenerics]{rowVars}()}.
\item See also the base R version \code{base::\link[MatrixGenerics]{rowMeans}()}.
}
}
\author{
Peter Hickey
}
